/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.adminconsole;

import com.google.gwt.cell.client.FieldUpdater;
import com.google.gwt.cell.client.SafeHtmlCell;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.cellview.client.CellTable;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.ColumnSortEvent;
import com.google.gwt.user.cellview.client.TextColumn;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.HasData;
import com.google.gwt.view.client.ListDataProvider;
import com.google.gwt.view.client.SelectionChangeEvent;
import com.google.gwt.view.client.SingleSelectionModel;
import com.sap.sailing.gwt.ui.adminconsole.FileStorageServiceConnectionTestObservable;
import com.sap.sailing.gwt.ui.adminconsole.ImageConfigImagesBarCell;
import com.sap.sailing.gwt.ui.adminconsole.ImageCreateDialog;
import com.sap.sailing.gwt.ui.adminconsole.ImageEditDialog;
import com.sap.sailing.gwt.ui.adminconsole.ImagesListComposite;
import com.sap.sailing.gwt.ui.client.SailingServiceAsync;
import com.sap.sailing.gwt.ui.client.SailingServiceWriteAsync;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sse.gwt.adminconsole.AdminConsoleTableResources;
import com.sap.sse.gwt.client.celltable.BaseCelltable;
import com.sap.sse.gwt.client.celltable.ImagesBarCell;
import com.sap.sse.gwt.client.celltable.ImagesBarColumn;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;
import com.sap.sse.gwt.client.media.ImageDTO;
import com.sap.sse.gwt.client.media.ImageResizingTaskDTO;
import java.util.Comparator;
import java.util.List;

public class ImagesListComposite
extends Composite {
    private final StringMessages stringMessages;
    private final SailingServiceWriteAsync sailingServiceWrite;
    private CellTable<ImageDTO> imageTable;
    private SingleSelectionModel<ImageDTO> imageSelectionModel;
    private ListDataProvider<ImageDTO> imageListDataProvider;
    private final Label noImagesLabel;
    private final FileStorageServiceConnectionTestObservable storageServiceAvailable;
    private final SimplePanel mainPanel;
    private final VerticalPanel panel;
    private static AnchorTemplates ANCHORTEMPLATE = (AnchorTemplates)GWT.create(AnchorTemplates.class);
    private final AdminConsoleTableResources tableRes = (AdminConsoleTableResources)GWT.create(AdminConsoleTableResources.class);

    public ImagesListComposite(SailingServiceWriteAsync sailingServiceWrite, StringMessages stringMessages, FileStorageServiceConnectionTestObservable storageServiceAvailable) {
        this.sailingServiceWrite = sailingServiceWrite;
        this.stringMessages = stringMessages;
        this.storageServiceAvailable = storageServiceAvailable;
        this.mainPanel = new SimplePanel();
        this.panel = new VerticalPanel();
        this.mainPanel.setWidget((Widget)this.panel);
        HorizontalPanel imagesControlsPanel = new HorizontalPanel();
        imagesControlsPanel.setSpacing(5);
        this.panel.add((Widget)imagesControlsPanel);
        Button addPhotoBtn = new Button(stringMessages.addGalleryPhoto());
        addPhotoBtn.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        imagesControlsPanel.add((Widget)addPhotoBtn);
        Button addStateImageBtn = new Button(stringMessages.addStageImage());
        addStateImageBtn.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        imagesControlsPanel.add((Widget)addStateImageBtn);
        Button addEventTeaseImageBtn = new Button(stringMessages.addTeaserImage());
        addEventTeaseImageBtn.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        imagesControlsPanel.add((Widget)addEventTeaseImageBtn);
        Button addLogoImageBtn = new Button(stringMessages.addEventLogo());
        addLogoImageBtn.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        imagesControlsPanel.add((Widget)addLogoImageBtn);
        this.imageSelectionModel = new SingleSelectionModel();
        this.imageListDataProvider = new ListDataProvider();
        this.imageTable = this.createImagesTable();
        this.imageTable.ensureDebugId("ImagesCellTable");
        this.imageTable.setVisible(false);
        this.imageSelectionModel.addSelectionChangeHandler((SelectionChangeEvent.Handler)new /* Unavailable Anonymous Inner Class!! */);
        this.panel.add((Widget)this.imageTable);
        this.noImagesLabel = new Label(stringMessages.noImagesDefinedYet());
        this.noImagesLabel.ensureDebugId("NoImagesLabel");
        this.noImagesLabel.setWordWrap(false);
        this.panel.add((Widget)this.noImagesLabel);
        this.initWidget((Widget)this.mainPanel);
    }

    private CellTable<ImageDTO> createImagesTable() {
        BaseCelltable table = new BaseCelltable(10000, (CellTable.Resources)this.tableRes);
        this.imageListDataProvider.addDataDisplay((HasData)table);
        table.setWidth("100%");
        AnchorCell anchorCell = new AnchorCell();
        6 shortImageNameColumn = new /* Unavailable Anonymous Inner Class!! */;
        7 titleColumn = new /* Unavailable Anonymous Inner Class!! */;
        8 sizeColumn = new /* Unavailable Anonymous Inner Class!! */;
        9 createdAtDateColumn = new /* Unavailable Anonymous Inner Class!! */;
        SafeHtmlCell tagsCell = new SafeHtmlCell();
        10 tagsColumn = new /* Unavailable Anonymous Inner Class!! */;
        ImagesBarColumn imageActionColumn = new ImagesBarColumn((ImagesBarCell)new ImageConfigImagesBarCell(this.stringMessages));
        imageActionColumn.setFieldUpdater((FieldUpdater)new /* Unavailable Anonymous Inner Class!! */);
        titleColumn.setSortable(true);
        createdAtDateColumn.setSortable(true);
        table.addColumn((Column)shortImageNameColumn, this.stringMessages.name());
        table.addColumn((Column)titleColumn, this.stringMessages.title());
        table.addColumn((Column)createdAtDateColumn, this.stringMessages.createdAt());
        table.addColumn((Column)sizeColumn, this.stringMessages.size());
        table.addColumn((Column)tagsColumn, this.stringMessages.tags());
        table.addColumn((Column)imageActionColumn, this.stringMessages.actions());
        table.addColumnSortHandler((ColumnSortEvent.Handler)this.getImageTableColumnSortHandler(this.imageListDataProvider.getList(), (TextColumn)titleColumn, (TextColumn)createdAtDateColumn));
        table.getColumnSortList().push((Column)createdAtDateColumn);
        return table;
    }

    private ColumnSortEvent.ListHandler<ImageDTO> getImageTableColumnSortHandler(List<ImageDTO> imageRecords, TextColumn<ImageDTO> titleColumn, TextColumn<ImageDTO> createdAtDateColumn) {
        ColumnSortEvent.ListHandler result = new ColumnSortEvent.ListHandler(imageRecords);
        result.setComparator(titleColumn, (Comparator)new /* Unavailable Anonymous Inner Class!! */);
        result.setComparator(createdAtDateColumn, (Comparator)new /* Unavailable Anonymous Inner Class!! */);
        return result;
    }

    private void openCreateImageDialog(String initialTag) {
        ImageCreateDialog dialog = new ImageCreateDialog(initialTag, (SailingServiceAsync)this.sailingServiceWrite, this.stringMessages, this.storageServiceAvailable, (DataEntryDialog.DialogCallback)new /* Unavailable Anonymous Inner Class!! */);
        dialog.show();
    }

    private void openEditImageDialog(ImageDTO selectedImage) {
        ImageEditDialog dialog = new ImageEditDialog(selectedImage, (SailingServiceAsync)this.sailingServiceWrite, this.stringMessages, this.storageServiceAvailable, (DataEntryDialog.DialogCallback)new /* Unavailable Anonymous Inner Class!! */);
        dialog.show();
    }

    protected void callResizingServiceAndUpdateTable(ImageResizingTaskDTO resizingTask, ImageDTO originalImage) {
        this.sailingServiceWrite.resizeImage(resizingTask, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void updateTableVisibility() {
        if (this.imageListDataProvider.getList().isEmpty()) {
            this.imageTable.setVisible(false);
            this.noImagesLabel.setVisible(true);
        } else {
            this.imageTable.setVisible(true);
            this.noImagesLabel.setVisible(false);
        }
    }

    public void fillImages(List<? extends ImageDTO> images) {
        this.imageSelectionModel.clear();
        this.imageListDataProvider.getList().clear();
        this.imageListDataProvider.getList().addAll(images);
        this.updateTableVisibility();
    }

    public List<ImageDTO> getAllImages() {
        return this.imageListDataProvider.getList();
    }

    static /* synthetic */ void access$0(ImagesListComposite imagesListComposite, String string) {
        imagesListComposite.openCreateImageDialog(string);
    }

    static /* synthetic */ AnchorTemplates access$1() {
        return ANCHORTEMPLATE;
    }

    static /* synthetic */ ListDataProvider access$2(ImagesListComposite imagesListComposite) {
        return imagesListComposite.imageListDataProvider;
    }

    static /* synthetic */ void access$3(ImagesListComposite imagesListComposite) {
        imagesListComposite.updateTableVisibility();
    }

    static /* synthetic */ void access$4(ImagesListComposite imagesListComposite, ImageDTO imageDTO) {
        imagesListComposite.openEditImageDialog(imageDTO);
    }

    static /* synthetic */ StringMessages access$5(ImagesListComposite imagesListComposite) {
        return imagesListComposite.stringMessages;
    }
}

