/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.adminconsole;

import com.google.gwt.dom.client.Style;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.FocusWidget;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.TabLayoutPanel;
import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.domain.common.windfinder.AvailableWindFinderSpotCollections;
import com.sap.sailing.gwt.ui.adminconsole.CourseAreaListInlineEditorComposite;
import com.sap.sailing.gwt.ui.adminconsole.EventDialog;
import com.sap.sailing.gwt.ui.adminconsole.ExternalLinksComposite;
import com.sap.sailing.gwt.ui.adminconsole.FileStorageServiceConnectionTestObservable;
import com.sap.sailing.gwt.ui.adminconsole.ImagesListComposite;
import com.sap.sailing.gwt.ui.adminconsole.SuggestedCourseAreaNames;
import com.sap.sailing.gwt.ui.adminconsole.VideosListComposite;
import com.sap.sailing.gwt.ui.client.DataEntryDialogWithDateTimeBox;
import com.sap.sailing.gwt.ui.client.SailingServiceWriteAsync;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.shared.EventDTO;
import com.sap.sailing.gwt.ui.shared.LeaderboardGroupDTO;
import com.sap.sailing.gwt.ui.shared.VenueDTO;
import com.sap.sse.gwt.client.DateAndTimeFormatterUtil;
import com.sap.sse.gwt.client.IconResources;
import com.sap.sse.gwt.client.controls.datetime.DateAndTimeInput;
import com.sap.sse.gwt.client.controls.listedit.GenericStringListEditorComposite;
import com.sap.sse.gwt.client.controls.listedit.ListEditorUiStrategy;
import com.sap.sse.gwt.client.controls.listedit.StringConstantsListEditorComposite;
import com.sap.sse.gwt.client.controls.listedit.StringListInlineEditorComposite;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;
import com.sap.sse.gwt.client.media.ImageDTO;
import com.sap.sse.gwt.client.media.VideoDTO;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public abstract class EventDialog
extends DataEntryDialogWithDateTimeBox<EventDTO> {
    protected StringMessages stringMessages;
    protected TextBox nameEntryField;
    protected TextArea descriptionEntryField;
    protected TextBox venueEntryField;
    protected DateAndTimeInput startDateBox;
    protected DateAndTimeInput endDateBox;
    protected CheckBox isPublicCheckBox;
    protected UUID id;
    protected TextBox baseURLEntryField;
    protected CourseAreaListInlineEditorComposite courseAreaNameList;
    protected StringConstantsListEditorComposite leaderboardGroupList;
    protected StringListInlineEditorComposite windFinderSpotCollectionIdsComposite;
    protected Map<String, LeaderboardGroupDTO> availableLeaderboardGroupsByName;
    protected ImagesListComposite imagesListComposite;
    protected VideosListComposite videosListComposite;
    protected ExternalLinksComposite externalLinksComposite;
    private final FileStorageServiceConnectionTestObservable storageServiceAvailable;

    public EventDialog(EventParameterValidator validator, SailingServiceWriteAsync sailingServiceWrite, StringMessages stringMessages, List<LeaderboardGroupDTO> availableLeaderboardGroups, Iterable<LeaderboardGroupDTO> leaderboardGroupsOfEvent, DataEntryDialog.DialogCallback<EventDTO> callback) {
        super(stringMessages.event(), null, stringMessages.ok(), stringMessages.cancel(), (DataEntryDialog.Validator)validator, callback);
        this.ensureDebugId("eventDialog");
        this.storageServiceAvailable = new FileStorageServiceConnectionTestObservable(sailingServiceWrite);
        this.stringMessages = stringMessages;
        this.availableLeaderboardGroupsByName = new HashMap();
        for (LeaderboardGroupDTO lgDTO : availableLeaderboardGroups) {
            this.availableLeaderboardGroupsByName.put(lgDTO.getName(), lgDTO);
        }
        this.getDialogBox().getWidget().setWidth("800px");
        1 valueChangeHandler = new /* Unavailable Anonymous Inner Class!! */;
        2 courseAreaValueChangeHandler = new /* Unavailable Anonymous Inner Class!! */;
        this.courseAreaNameList = new CourseAreaListInlineEditorComposite(Collections.emptyList(), (ListEditorUiStrategy)new CourseAreaListInlineEditorComposite.ExpandedUi(stringMessages, IconResources.INSTANCE.removeIcon(), SuggestedCourseAreaNames.suggestedCourseAreaNames, stringMessages.enterCourseAreaName(), 30));
        this.courseAreaNameList.addValueChangeHandler((ValueChangeHandler)courseAreaValueChangeHandler);
        ArrayList<String> leaderboardGroupNames = new ArrayList<String>();
        for (LeaderboardGroupDTO leaderboardGroupDTO : availableLeaderboardGroups) {
            leaderboardGroupNames.add(leaderboardGroupDTO.getName());
        }
        this.leaderboardGroupList = new StringConstantsListEditorComposite(Collections.emptyList(), (ListEditorUiStrategy)new StringConstantsListEditorComposite.ExpandedUi((com.sap.sse.gwt.client.StringMessages)stringMessages, IconResources.INSTANCE.removeIcon(), leaderboardGroupNames, stringMessages.selectALeaderboardGroup()));
        this.leaderboardGroupList.addValueChangeHandler((ValueChangeHandler)valueChangeHandler);
        this.imagesListComposite = new ImagesListComposite(sailingServiceWrite, stringMessages, this.storageServiceAvailable);
        this.videosListComposite = new VideosListComposite(stringMessages, this.storageServiceAvailable);
        this.externalLinksComposite = new ExternalLinksComposite(stringMessages);
        List suggestedWindFinderSpotCollections = AvailableWindFinderSpotCollections.getAllAvailableWindFinderSpotCollectionsInAlphabeticalOrder() == null ? Collections.emptyList() : AvailableWindFinderSpotCollections.getAllAvailableWindFinderSpotCollectionsInAlphabeticalOrder();
        this.windFinderSpotCollectionIdsComposite = new StringListInlineEditorComposite(Collections.emptyList(), (ListEditorUiStrategy)new GenericStringListEditorComposite.ExpandedUi((com.sap.sse.gwt.client.StringMessages)stringMessages, IconResources.INSTANCE.removeIcon(), (Iterable)suggestedWindFinderSpotCollections, stringMessages.enterIdOfWindFinderReviewedSpotCollection(), Integer.valueOf(35)));
    }

    protected EventDTO getResult() {
        ArrayList<LeaderboardGroupDTO> leaderboardGroups = new ArrayList<LeaderboardGroupDTO>();
        List leaderboardGroupNames = this.leaderboardGroupList.getValue();
        for (String lgName : leaderboardGroupNames) {
            LeaderboardGroupDTO lgDTO = (LeaderboardGroupDTO)this.availableLeaderboardGroupsByName.get(lgName);
            if (lgDTO == null) continue;
            leaderboardGroups.add(lgDTO);
        }
        EventDTO result = new EventDTO(this.nameEntryField.getText(), leaderboardGroups);
        result.setDescription(this.descriptionEntryField.getText());
        result.setOfficialWebsiteURL(this.externalLinksComposite.getOfficialWebsiteURLValue());
        result.setBaseURL(this.baseURLEntryField.getText().trim().isEmpty() ? null : this.baseURLEntryField.getText().trim());
        result.setSailorsInfoWebsiteURLs(this.externalLinksComposite.getSailorsInfoWebsiteURLs());
        result.startDate = this.startDateBox.getValue();
        result.endDate = this.endDateBox.getValue();
        result.isPublic = this.isPublicCheckBox.getValue();
        result.id = this.id;
        List courseAreas = this.courseAreaNameList.getValue();
        for (ImageDTO image : this.imagesListComposite.getAllImages()) {
            result.addImage(image);
        }
        for (VideoDTO video : this.videosListComposite.getAllVideos()) {
            result.addVideo(video);
        }
        result.setVenue(new VenueDTO(this.venueEntryField.getText(), courseAreas));
        result.setWindFinderReviewedSpotsCollection((Iterable)this.windFinderSpotCollectionIdsComposite.getValue());
        return result;
    }

    protected Widget getAdditionalWidget() {
        VerticalPanel panel = new VerticalPanel();
        panel.setWidth("100%");
        Widget additionalWidget = super.getAdditionalWidget();
        if (additionalWidget != null) {
            panel.add(additionalWidget);
        }
        Grid formGrid = new Grid(8, 2);
        int rowIndex = 0;
        formGrid.setWidget(rowIndex, 0, (Widget)new Label(String.valueOf(this.stringMessages.name()) + ":"));
        formGrid.setWidget(rowIndex++, 1, (Widget)this.nameEntryField);
        formGrid.setWidget(rowIndex, 0, (Widget)new Label(String.valueOf(this.stringMessages.description()) + ":"));
        formGrid.setWidget(rowIndex++, 1, (Widget)this.descriptionEntryField);
        formGrid.setWidget(rowIndex, 0, (Widget)new Label(String.valueOf(this.stringMessages.venue()) + ":"));
        formGrid.setWidget(rowIndex++, 1, (Widget)this.venueEntryField);
        formGrid.setWidget(rowIndex, 0, (Widget)new Label(String.valueOf(this.stringMessages.timeZone()) + ":"));
        formGrid.setWidget(rowIndex++, 1, (Widget)new Label(DateAndTimeFormatterUtil.getClientTimeZoneAsGMTString()));
        formGrid.setWidget(rowIndex, 0, (Widget)new Label(String.valueOf(this.stringMessages.startDate()) + ":"));
        formGrid.setWidget(rowIndex++, 1, (Widget)this.startDateBox);
        formGrid.setWidget(rowIndex, 0, (Widget)new Label(String.valueOf(this.stringMessages.endDate()) + ":"));
        formGrid.setWidget(rowIndex++, 1, (Widget)this.endDateBox);
        formGrid.setWidget(rowIndex, 0, (Widget)new Label(String.valueOf(this.stringMessages.isListedOnHomepage()) + ":"));
        formGrid.setWidget(rowIndex++, 1, (Widget)this.isPublicCheckBox);
        formGrid.setWidget(rowIndex, 0, (Widget)new Label(String.valueOf(this.stringMessages.eventBaseURL()) + ":"));
        formGrid.setWidget(rowIndex++, 1, (Widget)this.baseURLEntryField);
        TabLayoutPanel tabPanel = new TabLayoutPanel(30.0, Style.Unit.PX);
        tabPanel.ensureDebugId("EventDialogTabs");
        tabPanel.setHeight("400px");
        panel.add((Widget)tabPanel);
        ScrollPanel eventTab = new ScrollPanel((Widget)formGrid);
        eventTab.ensureDebugId("EventTab");
        tabPanel.add((Widget)eventTab, this.stringMessages.event());
        ScrollPanel externalLinksCompositeTab = new ScrollPanel((Widget)this.externalLinksComposite);
        externalLinksCompositeTab.ensureDebugId("ExternalLinksCompositeTab");
        tabPanel.add((Widget)externalLinksCompositeTab, this.stringMessages.externalLinks());
        ScrollPanel leaderboardGroupTab = new ScrollPanel((Widget)this.leaderboardGroupList);
        leaderboardGroupTab.ensureDebugId("LeaderboardGroupsTab");
        tabPanel.add((Widget)leaderboardGroupTab, this.stringMessages.leaderboardGroups());
        ScrollPanel courseAreasTab = new ScrollPanel((Widget)this.courseAreaNameList);
        courseAreasTab.ensureDebugId("CourseAreasTab");
        tabPanel.add((Widget)courseAreasTab, this.stringMessages.courseAreas());
        ScrollPanel imagesTab = new ScrollPanel((Widget)this.imagesListComposite);
        imagesTab.ensureDebugId("ImagesTab");
        tabPanel.add((Widget)imagesTab, this.stringMessages.images());
        ScrollPanel videosTab = new ScrollPanel((Widget)this.videosListComposite);
        videosTab.ensureDebugId("VideosTab");
        tabPanel.add((Widget)videosTab, this.stringMessages.videos());
        ScrollPanel windFinderTab = new ScrollPanel((Widget)this.windFinderSpotCollectionIdsComposite);
        windFinderTab.ensureDebugId("WindFinderTab");
        tabPanel.add((Widget)windFinderTab, this.stringMessages.windFinder());
        return panel;
    }

    protected FocusWidget getInitialFocusWidget() {
        return this.nameEntryField;
    }

    static /* synthetic */ void access$2(EventDialog eventDialog) {
        eventDialog.validateAndUpdate();
    }
}

