/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.adminconsole;

import com.google.gwt.safehtml.shared.UriUtils;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.CaptionPanel;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.domain.common.dto.CourseAreaDTO;
import com.sap.sailing.gwt.settings.client.EntryPointWithSettingsLinkFactory;
import com.sap.sailing.gwt.settings.client.regattaoverview.RegattaOverviewContextDefinition;
import com.sap.sailing.gwt.ui.adminconsole.EventDetailsComposite;
import com.sap.sailing.gwt.ui.client.SailingServiceAsync;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.shared.EventDTO;
import com.sap.sailing.gwt.ui.shared.LeaderboardGroupDTO;
import com.sap.sse.gwt.client.ErrorReporter;
import com.sap.sse.gwt.client.media.ImageDTO;
import com.sap.sse.gwt.client.media.VideoDTO;
import java.util.ArrayList;

public class EventDetailsComposite
extends Composite {
    private EventDTO event;
    private final StringMessages stringMessages;
    private final Label eventId;
    private final Label eventName;
    private final Label venueName;
    private final Label description;
    private final Label startDate;
    private final Label endDate;
    private final Label isPublic;
    private final Anchor officialWebsiteURL;
    private final Anchor baseURL;
    private final SimpleAnchorListComposite sailorsInfoWebsiteURLList;
    private final Anchor eventOverviewURL;
    private final SimpleStringListComposite courseAreaNamesList;
    private final SimpleAnchorListComposite imageURLList;
    private final SimpleAnchorListComposite videoURLList;
    private final SimpleStringListComposite leaderboardGroupList;
    private final SimpleStringListComposite windfinderSpotCollectionsList;
    private final CaptionPanel mainPanel;

    public EventDetailsComposite(SailingServiceAsync sailingService, ErrorReporter errorReporter, StringMessages stringMessages) {
        this.stringMessages = stringMessages;
        this.event = null;
        this.mainPanel = new CaptionPanel(stringMessages.regatta());
        VerticalPanel vPanel = new VerticalPanel();
        this.mainPanel.add((Widget)vPanel);
        int rows = 17;
        Grid grid = new Grid(rows, 2);
        vPanel.add((Widget)grid);
        int currentRow = 0;
        this.eventId = this.createLabelAndValueWidget(grid, currentRow++, stringMessages.id(), "IdLabel");
        this.eventName = this.createLabelAndValueWidget(grid, currentRow++, stringMessages.eventName(), "NameLabel");
        this.description = this.createLabelAndValueWidget(grid, currentRow++, stringMessages.description(), "DescriptionLabel");
        this.venueName = this.createLabelAndValueWidget(grid, currentRow++, stringMessages.venue(), "VenueLabel");
        this.startDate = this.createLabelAndValueWidget(grid, currentRow++, stringMessages.startDate(), "StartDateLabel");
        this.endDate = this.createLabelAndValueWidget(grid, currentRow++, stringMessages.endDate(), "EndDateLabel");
        this.isPublic = this.createLabelAndValueWidget(grid, currentRow++, stringMessages.isListedOnHomepage(), "IsPublicLabel");
        this.officialWebsiteURL = this.createLabelAndAnchorWidget(grid, currentRow++, stringMessages.eventOfficialWebsiteURL(), "OfficialWebsiteURLLabel");
        this.baseURL = this.createLabelAndAnchorWidget(grid, currentRow++, stringMessages.eventBaseURL(), "BaseURLLabel");
        this.sailorsInfoWebsiteURLList = this.createLabelAndAnchorListWidget(grid, currentRow++, stringMessages.eventSailorsInfoWebsiteURL(), "SailorsInfoWebsiteURLLabel");
        this.eventOverviewURL = this.createLabelAndAnchorWidget(grid, currentRow++, stringMessages.eventOverviewURL(), "EventOverviewURLLabel");
        this.courseAreaNamesList = this.createLabelAndValueListWidget(grid, currentRow++, stringMessages.courseAreas(), "CourseAreaValueList");
        this.imageURLList = this.createLabelAndAnchorListWidget(grid, currentRow++, stringMessages.images(), "ImageURLValueList");
        this.videoURLList = this.createLabelAndAnchorListWidget(grid, currentRow++, stringMessages.videos(), "VideoURLValueList");
        this.leaderboardGroupList = this.createLabelAndValueListWidget(grid, currentRow++, stringMessages.leaderboardGroups(), "LeaderboardGroupValueList");
        this.windfinderSpotCollectionsList = this.createLabelAndValueListWidget(grid, currentRow++, stringMessages.windFinderSpotCollectionsList(), "WindFinderSpotCollectionsList");
        int i = 0;
        while (i < rows) {
            grid.getCellFormatter().setVerticalAlignment(i, 0, HasVerticalAlignment.ALIGN_TOP);
            grid.getCellFormatter().setVerticalAlignment(i, 1, HasVerticalAlignment.ALIGN_TOP);
            ++i;
        }
        this.initWidget((Widget)this.mainPanel);
    }

    private Label createLabelAndValueWidget(Grid grid, int row, String label, String debugId) {
        Label valueLabel = new Label();
        valueLabel.ensureDebugId(debugId);
        grid.setWidget(row, 0, (Widget)new Label(String.valueOf(label) + ":"));
        grid.setWidget(row, 1, (Widget)valueLabel);
        return valueLabel;
    }

    private Anchor createLabelAndAnchorWidget(Grid grid, int row, String label, String debugId) {
        Anchor valueAnchor = new Anchor();
        valueAnchor.setTarget("_blank");
        valueAnchor.ensureDebugId(debugId);
        grid.setWidget(row, 0, (Widget)new Label(String.valueOf(label) + ":"));
        grid.setWidget(row, 1, (Widget)valueAnchor);
        return valueAnchor;
    }

    private SimpleAnchorListComposite createLabelAndAnchorListWidget(Grid grid, int row, String label, String debugId) {
        SimpleAnchorListComposite valueList = new SimpleAnchorListComposite(this);
        valueList.ensureDebugId(debugId);
        grid.setWidget(row, 0, (Widget)new Label(String.valueOf(label) + ":"));
        grid.setWidget(row, 1, (Widget)valueList);
        return valueList;
    }

    private SimpleStringListComposite createLabelAndValueListWidget(Grid grid, int row, String label, String debugId) {
        SimpleStringListComposite valueList = new SimpleStringListComposite(this);
        valueList.ensureDebugId(debugId);
        grid.setWidget(row, 0, (Widget)new Label(String.valueOf(label) + ":"));
        grid.setWidget(row, 1, (Widget)valueList);
        return valueList;
    }

    public EventDTO getEvent() {
        return this.event;
    }

    public void setEvent(EventDTO event) {
        this.event = event;
        this.updateEventDetails();
    }

    private void updateEventDetails() {
        if (this.event != null) {
            this.mainPanel.setCaptionText(String.valueOf(this.stringMessages.event()) + " " + this.event.getName());
            this.eventName.setText(this.event.getName());
            this.eventId.setText(this.event.id.toString());
            this.venueName.setText(this.event.getVenue().getName());
            this.description.setText(this.event.getDescription());
            this.startDate.setText(this.event.startDate != null ? this.event.startDate.toString() : "");
            this.endDate.setText(this.event.endDate != null ? this.event.endDate.toString() : "");
            this.isPublic.setText(String.valueOf(this.event.isPublic));
            this.officialWebsiteURL.setText(this.event.getOfficialWebsiteURL());
            this.officialWebsiteURL.setHref(this.event.getOfficialWebsiteURL());
            this.baseURL.setText(this.event.getBaseURL());
            this.baseURL.setHref(this.event.getBaseURL());
            this.sailorsInfoWebsiteURLList.setValues(new ArrayList(this.event.getSailorsInfoWebsiteURLs().values()));
            String regattaOverviewLink = EntryPointWithSettingsLinkFactory.createRegattaOverviewLink((RegattaOverviewContextDefinition)new RegattaOverviewContextDefinition(this.event.id));
            this.eventOverviewURL.setText(regattaOverviewLink);
            this.eventOverviewURL.setHref(UriUtils.fromString((String)regattaOverviewLink));
            ArrayList<String> courseAreaNames = new ArrayList<String>();
            if (this.event.getVenue().getCourseAreas() != null && this.event.getVenue().getCourseAreas().size() > 0) {
                for (CourseAreaDTO courseArea : this.event.getVenue().getCourseAreas()) {
                    courseAreaNames.add(courseArea.getName());
                }
            }
            this.courseAreaNamesList.setValues(courseAreaNames);
            ArrayList<String> imageURLStringsAsList = new ArrayList<String>();
            for (ImageDTO image : this.event.getImages()) {
                imageURLStringsAsList.add(image.getSourceRef());
            }
            this.imageURLList.setValues(imageURLStringsAsList);
            ArrayList<String> videoURLStringsAsList = new ArrayList<String>();
            for (VideoDTO video : this.event.getVideos()) {
                videoURLStringsAsList.add(video.getSourceRef());
            }
            this.videoURLList.setValues(videoURLStringsAsList);
            ArrayList<String> leaderboardGroupNamesAsList = new ArrayList<String>();
            for (LeaderboardGroupDTO leaderboardGroupDTO : this.event.getLeaderboardGroups()) {
                leaderboardGroupNamesAsList.add(leaderboardGroupDTO.getName());
            }
            this.leaderboardGroupList.setValues(leaderboardGroupNamesAsList);
            ArrayList<String> windfinderSpotCollectionsNamesAsList = new ArrayList<String>();
            for (String windfinderSpotCollection : this.event.getWindFinderReviewedSpotsCollectionIds()) {
                windfinderSpotCollectionsNamesAsList.add(windfinderSpotCollection);
            }
            this.windfinderSpotCollectionsList.setValues(windfinderSpotCollectionsNamesAsList);
        }
    }
}

