/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.adminconsole;

import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.LongBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;
import java.util.ArrayList;

public class DiscardThresholdBoxes {
    private static final int MAX_NUMBER_OF_DISCARDED_RESULTS = 15;
    private static final int NUMBER_OF_BOXES_PER_LINE = 5;
    private final LongBox[] discardThresholdBoxes = new LongBox[15];
    private final Widget widget;

    public DiscardThresholdBoxes(DataEntryDialog<?> parent, StringMessages stringMessages) {
        this(parent, new int[0], stringMessages);
    }

    public DiscardThresholdBoxes(DataEntryDialog<?> parent, int[] initialDiscardThresholds, StringMessages stringMessages) {
        int i = 0;
        while (i < this.discardThresholdBoxes.length) {
            this.discardThresholdBoxes[i] = initialDiscardThresholds != null && i < initialDiscardThresholds.length ? parent.createLongBox((long)initialDiscardThresholds[i], 2) : parent.createLongBoxWithOptionalValue(null, 2);
            this.discardThresholdBoxes[i].setVisibleLength(2);
            ++i;
        }
        this.widget = this.createDiscardThresholdBoxesPanel(stringMessages);
    }

    public Widget getWidget() {
        return this.widget;
    }

    public int[] getDiscardThresholds() {
        ArrayList<Integer> discardThresholds = new ArrayList<Integer>();
        int i = this.discardThresholdBoxes.length - 1;
        while (i >= 0) {
            if (this.discardThresholdBoxes[i].getValue() != null && ((Long)this.discardThresholdBoxes[i].getValue()).toString().length() > 0 || !discardThresholds.isEmpty()) {
                if (this.discardThresholdBoxes[i].getValue() == null) {
                    discardThresholds.add(0, 0);
                } else {
                    discardThresholds.add(0, ((Long)this.discardThresholdBoxes[i].getValue()).intValue());
                }
            }
            --i;
        }
        int[] discardThresholdsBoxContents = new int[discardThresholds.size()];
        int i2 = 0;
        while (i2 < discardThresholds.size()) {
            discardThresholdsBoxContents[i2] = (Integer)discardThresholds.get(i2);
            ++i2;
        }
        return discardThresholdsBoxContents;
    }

    private Widget createDiscardThresholdBoxesPanel(StringMessages stringMessages) {
        assert (this.discardThresholdBoxes != null && this.discardThresholdBoxes.length == 15);
        VerticalPanel vp = new VerticalPanel();
        vp.add((Widget)new Label(stringMessages.applyDiscardsBasedOnNumberOfScoredRaces(15)));
        Grid grid = new Grid(0, 10);
        grid.setCellSpacing(3);
        vp.add((Widget)grid);
        int i = 0;
        while (i < this.discardThresholdBoxes.length) {
            if (i % 5 == 0) {
                grid.resizeRows(i / 5 + 1);
            }
            grid.setWidget(i / 5, 2 * (i % 5), (Widget)new Label(i + 1 + "."));
            grid.setWidget(i / 5, 2 * (i % 5) + 1, (Widget)this.discardThresholdBoxes[i]);
            ++i;
        }
        return vp;
    }

    public static String getErrorMessage(int[] discardThresholds, StringMessages stringMessages) {
        String errorMessage = null;
        if (discardThresholds != null) {
            boolean discardThresholdsAscending = true;
            int i = 1;
            while (i < discardThresholds.length) {
                if (discardThresholds.length > 0) {
                    discardThresholdsAscending = discardThresholdsAscending && discardThresholds[i - 1] < discardThresholds[i] && (discardThresholds[i] == 0 || discardThresholds[i - 1] > 0);
                }
                ++i;
            }
            if (!discardThresholdsAscending) {
                errorMessage = stringMessages.discardThresholdsMustBeAscending();
            }
        }
        return errorMessage;
    }
}

