/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.adminconsole;

import com.google.gwt.http.client.URL;
import com.sap.sailing.domain.common.racelog.tracking.QRCodeURLCreationException;
import com.sap.sailing.gwt.ui.adminconsole.BaseQRIdentifierWidget;
import com.sap.sailing.gwt.ui.adminconsole.DeviceMappingQRCodeWidget;
import com.sap.sailing.gwt.ui.client.StringMessages;

public class DeviceMappingQRCodeWidget
extends BaseQRIdentifierWidget {
    private static final int qrCodeSize = 320;
    private static final int errorCorrectionLevel = 1;
    private String mappedItemId;
    private String mappedItemType;
    private final URLFactory urlFactory;

    public DeviceMappingQRCodeWidget(StringMessages stringMessages, URLFactory urlFactory) {
        super(320, stringMessages, 1);
        this.urlFactory = urlFactory;
    }

    public void setMappedItem(String mappedItemType, String mappedItemIdAsString) {
        this.mappedItemId = URL.encode((String)mappedItemIdAsString);
        this.mappedItemType = mappedItemType;
        this.generateQRCode();
    }

    protected String generateEncodedQRCodeContent() throws QRCodeURLCreationException {
        if (!this.isServerUrlValid()) {
            this.url.setText("");
            throw new QRCodeURLCreationException(this.stringMessages.serverURLInvalid());
        }
        String serverUrl = this.getServerUrlWithoutFinalSlash();
        if (serverUrl.isEmpty()) {
            throw new QRCodeURLCreationException(this.stringMessages.serverURLEmpty());
        }
        if (this.mappedItemId == null) {
            throw new QRCodeURLCreationException(this.stringMessages.pleaseSelectAnItemToMapTo());
        }
        return this.urlFactory.createURL(serverUrl, this.mappedItemType, this.mappedItemId);
    }
}

