/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.adminconsole;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.cellview.client.AbstractCellTable;
import com.google.gwt.user.cellview.client.CellTable;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.ColumnSortEvent;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.HasData;
import com.google.gwt.view.client.ListDataProvider;
import com.google.gwt.view.client.SelectionModel;
import com.sap.sailing.gwt.ui.adminconsole.DeviceConfigurationListComposite;
import com.sap.sailing.gwt.ui.client.SailingServiceWriteAsync;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.shared.DeviceConfigurationWithSecurityDTO;
import com.sap.sse.gwt.adminconsole.AdminConsoleTableResources;
import com.sap.sse.gwt.client.ErrorReporter;
import com.sap.sse.gwt.client.celltable.AbstractSortableTextColumn;
import com.sap.sse.gwt.client.celltable.BaseCelltable;
import com.sap.sse.gwt.client.celltable.EntityIdentityComparator;
import com.sap.sse.gwt.client.celltable.ImagesBarCell;
import com.sap.sse.gwt.client.celltable.RefreshableMultiSelectionModel;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.dto.AccessControlListDTO;
import com.sap.sse.security.shared.dto.SecuredDTO;
import com.sap.sse.security.shared.impl.SecuredSecurityTypes;
import com.sap.sse.security.ui.client.UserManagementWriteServiceAsync;
import com.sap.sse.security.ui.client.UserService;
import com.sap.sse.security.ui.client.component.AccessControlledActionsColumn;
import com.sap.sse.security.ui.client.component.DefaultActionsImagesBarCell;
import com.sap.sse.security.ui.client.component.EditOwnershipDialog;
import com.sap.sse.security.ui.client.component.SecuredDTOOwnerColumn;
import com.sap.sse.security.ui.client.component.editacl.EditACLDialog;
import java.util.List;

public class DeviceConfigurationListComposite
extends Composite {
    protected static AdminConsoleTableResources tableResource = (AdminConsoleTableResources)GWT.create(AdminConsoleTableResources.class);
    private final RefreshableMultiSelectionModel<DeviceConfigurationWithSecurityDTO> refreshableConfigurationSelectionModel;
    private final CellTable<DeviceConfigurationWithSecurityDTO> configurationTable;
    protected ListDataProvider<DeviceConfigurationWithSecurityDTO> configurationsDataProvider;
    private final SimplePanel mainPanel;
    private final VerticalPanel panel;
    private final Label noConfigurationsLabel;
    private final SailingServiceWriteAsync sailingServiceWrite;
    private final ErrorReporter errorReporter;
    protected final StringMessages stringMessages;

    public DeviceConfigurationListComposite(SailingServiceWriteAsync sailingServiceWrite, ErrorReporter errorReporter, StringMessages stringMessages, UserService userService) {
        this.sailingServiceWrite = sailingServiceWrite;
        this.errorReporter = errorReporter;
        this.stringMessages = stringMessages;
        this.mainPanel = new SimplePanel();
        this.panel = new VerticalPanel();
        this.mainPanel.setWidget((Widget)this.panel);
        this.noConfigurationsLabel = new Label(stringMessages.noConfigurations());
        this.noConfigurationsLabel.setWordWrap(false);
        this.panel.add((Widget)this.noConfigurationsLabel);
        this.configurationsDataProvider = new ListDataProvider();
        this.refreshTable();
        this.configurationTable = this.createConfigurationTable(userService);
        this.configurationTable.setVisible(true);
        this.refreshableConfigurationSelectionModel = new RefreshableMultiSelectionModel((EntityIdentityComparator)new /* Unavailable Anonymous Inner Class!! */, this.configurationsDataProvider);
        this.configurationTable.setSelectionModel((SelectionModel)this.refreshableConfigurationSelectionModel);
        this.panel.add((Widget)this.configurationTable);
        this.initWidget((Widget)this.mainPanel);
    }

    public void refreshTable() {
        this.sailingServiceWrite.getDeviceConfigurations((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public RefreshableMultiSelectionModel<DeviceConfigurationWithSecurityDTO> getSelectionModel() {
        return this.refreshableConfigurationSelectionModel;
    }

    private CellTable<DeviceConfigurationWithSecurityDTO> createConfigurationTable(UserService userService) {
        BaseCelltable table = new BaseCelltable(10000, (CellTable.Resources)tableResource);
        this.configurationsDataProvider.addDataDisplay((HasData)table);
        table.ensureDebugId("DeviceConfigurationList");
        table.setWidth("100%");
        ColumnSortEvent.ListHandler columnSortHandler = new ColumnSortEvent.ListHandler(this.configurationsDataProvider.getList());
        table.addColumnSortHandler((ColumnSortEvent.Handler)columnSortHandler);
        3 identifierNameColumn = new /* Unavailable Anonymous Inner Class!! */;
        identifierNameColumn.setSortable(true);
        columnSortHandler.setComparator((Column)identifierNameColumn, (r1, r2) -> r1.name.compareTo(r2.name));
        table.addColumn((Column)identifierNameColumn, this.stringMessages.device());
        AbstractSortableTextColumn deviceConfigurationUUIDColumn = new AbstractSortableTextColumn(config -> config.id == null ? "<null>" : config.id.toString(), columnSortHandler);
        HasPermissions type = SecuredSecurityTypes.USER_GROUP;
        AccessControlledActionsColumn actionColumn = AccessControlledActionsColumn.create((ImagesBarCell)new DefaultActionsImagesBarCell((com.sap.sse.security.ui.client.i18n.StringMessages)this.stringMessages), (UserService)userService);
        actionColumn.addAction(DefaultActionsImagesBarCell.ACTION_DELETE, (HasPermissions.Action)HasPermissions.DefaultActions.DELETE, config -> {
            if (Window.confirm((String)this.stringMessages.doYouReallyWantToRemoveDeviceConfiguration(config.getName()))) {
                this.sailingServiceWrite.removeDeviceConfiguration(config.id, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
            }
        });
        EditOwnershipDialog.DialogConfig configOwnership = EditOwnershipDialog.create((UserManagementWriteServiceAsync)userService.getUserManagementWriteService(), (HasPermissions)type, user -> this.refreshTable(), (com.sap.sse.security.ui.client.i18n.StringMessages)this.stringMessages);
        EditACLDialog.DialogConfig configACL = EditACLDialog.create((UserManagementWriteServiceAsync)userService.getUserManagementWriteService(), (HasPermissions)type, user -> {
            AccessControlListDTO accessControlListDTO = user.getAccessControlList();
        }, (com.sap.sse.security.ui.client.i18n.StringMessages)this.stringMessages);
        actionColumn.addAction(DefaultActionsImagesBarCell.ACTION_CHANGE_OWNERSHIP, (HasPermissions.Action)HasPermissions.DefaultActions.CHANGE_OWNERSHIP, arg_0 -> ((EditOwnershipDialog.DialogConfig)configOwnership).openOwnershipDialog(arg_0));
        actionColumn.addAction(DefaultActionsImagesBarCell.ACTION_CHANGE_ACL, (HasPermissions.Action)HasPermissions.DefaultActions.CHANGE_ACL, u -> configACL.openDialog((SecuredDTO)u));
        SecuredDTOOwnerColumn.configureOwnerColumns((AbstractCellTable)table, (ColumnSortEvent.ListHandler)columnSortHandler, (com.sap.sse.security.ui.client.i18n.StringMessages)this.stringMessages);
        table.addColumn((Column)deviceConfigurationUUIDColumn, this.stringMessages.id());
        table.addColumn((Column)actionColumn, this.stringMessages.actions());
        return table;
    }

    void update(DeviceConfigurationWithSecurityDTO configurationToUpdate) {
        List configList = this.configurationsDataProvider.getList();
        int i = 0;
        while (i < configList.size()) {
            if (((DeviceConfigurationWithSecurityDTO)configList.get((int)i)).id.equals(configurationToUpdate.id)) {
                configList.set(i, configurationToUpdate);
                break;
            }
            ++i;
        }
    }

    static /* synthetic */ CellTable access$0(DeviceConfigurationListComposite deviceConfigurationListComposite) {
        return deviceConfigurationListComposite.configurationTable;
    }

    static /* synthetic */ Label access$1(DeviceConfigurationListComposite deviceConfigurationListComposite) {
        return deviceConfigurationListComposite.noConfigurationsLabel;
    }

    static /* synthetic */ ErrorReporter access$2(DeviceConfigurationListComposite deviceConfigurationListComposite) {
        return deviceConfigurationListComposite.errorReporter;
    }

    static /* synthetic */ RefreshableMultiSelectionModel access$3(DeviceConfigurationListComposite deviceConfigurationListComposite) {
        return deviceConfigurationListComposite.refreshableConfigurationSelectionModel;
    }
}

