/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.adminconsole;

import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.TabPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.gwt.ui.adminconsole.AbstractRegattaWithSeriesAndFleetsDialog;
import com.sap.sailing.gwt.ui.adminconsole.SeriesWithFleetsDefaultListEditor;
import com.sap.sailing.gwt.ui.client.SailingServiceAsync;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.shared.EventAndRegattaDTO;
import com.sap.sailing.gwt.ui.shared.EventDTO;
import com.sap.sailing.gwt.ui.shared.RegattaDTO;
import com.sap.sailing.gwt.ui.shared.SeriesDTO;
import com.sap.sse.gwt.client.ErrorReporter;
import com.sap.sse.gwt.client.IconResources;
import com.sap.sse.gwt.client.controls.listedit.ListEditorComposite;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;
import com.sap.sse.security.ui.client.UserService;
import java.util.List;

public class DefaultRegattaCreateDialog
extends AbstractRegattaWithSeriesAndFleetsDialog<EventAndRegattaDTO> {
    public DefaultRegattaCreateDialog(List<EventDTO> existingEvents, RegattaDTO selectedRegatta, SailingServiceAsync sailingService, UserService userService, ErrorReporter errorReporter, StringMessages stringMessages, DataEntryDialog.DialogCallback<EventAndRegattaDTO> callback) {
        super(sailingService, userService, selectedRegatta, (Iterable)selectedRegatta.series, existingEvents, null, stringMessages.createDefaultSettingsForAllRegattas(), stringMessages.ok(), stringMessages, null, callback);
        if (existingEvents != null && !existingEvents.isEmpty()) {
            this.sailingEventsListBox.addItem(existingEvents.get(0).getName());
        } else {
            this.sailingEventsListBox.addItem(stringMessages.noOverallEventSelected());
        }
        this.sailingEventsListBox.setSelectedIndex(1);
        this.sailingEventsListBox.setEnabled(false);
        this.setCourseAreaSelection();
        int i = 0;
        while (i < this.getRankingMetricListBox().getItemCount()) {
            if (this.getRankingMetricListBox().getValue(i).equals(selectedRegatta.rankingMetricType.name())) {
                this.getRankingMetricListBox().setSelectedIndex(i);
            }
            ++i;
        }
    }

    protected ListEditorComposite<SeriesDTO> createSeriesEditor(Iterable<SeriesDTO> series) {
        return new SeriesWithFleetsDefaultListEditor(series, this.stringMessages, IconResources.INSTANCE.removeIcon(), false);
    }

    protected void setupAdditionalWidgetsOnPanel(VerticalPanel panel, Grid formGrid) {
        this.insertRankingMetricTabPanel(formGrid);
        TabPanel tabPanel = new TabPanel();
        tabPanel.setWidth("100%");
        tabPanel.add((Widget)this.getSeriesEditor(), this.stringMessages.series());
        tabPanel.selectTab(0);
        panel.add((Widget)tabPanel);
    }

    protected EventAndRegattaDTO getResult() {
        RegattaDTO regattaDTO = this.getRegattaDTO("");
        EventAndRegattaDTO eventAndRegatta = new EventAndRegattaDTO(this.getSelectedEvent(), regattaDTO);
        this.setRankingMetrics(regattaDTO);
        return eventAndRegatta;
    }
}

