/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.adminconsole;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.sap.sailing.domain.common.dto.CourseAreaDTO;
import com.sap.sailing.domain.common.dto.RaceColumnDTO;
import com.sap.sailing.domain.common.dto.RegattaCreationParametersDTO;
import com.sap.sailing.domain.common.dto.SeriesCreationParametersDTO;
import com.sap.sailing.gwt.ui.adminconsole.CreateDefaultRegattaLeaderboardDialog;
import com.sap.sailing.gwt.ui.adminconsole.LinkRegattaLeaderboardToLeaderboardGroupOfEventDialog;
import com.sap.sailing.gwt.ui.adminconsole.places.AdminConsoleView;
import com.sap.sailing.gwt.ui.client.SailingServiceAsync;
import com.sap.sailing.gwt.ui.client.SailingServiceWriteAsync;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.shared.EventDTO;
import com.sap.sailing.gwt.ui.shared.RegattaDTO;
import com.sap.sailing.gwt.ui.shared.SeriesDTO;
import com.sap.sailing.gwt.ui.shared.StrippedLeaderboardDTO;
import com.sap.sse.common.Util;
import com.sap.sse.gwt.client.ErrorReporter;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

public class CreateRegattaCallback
implements DataEntryDialog.DialogCallback<RegattaDTO> {
    private final SailingServiceWriteAsync sailingServiceWrite;
    private final ErrorReporter errorReporter;
    private final StringMessages stringMessages;
    private final Iterable<EventDTO> existingEvents;
    private final AdminConsoleView.Presenter presenter;

    public CreateRegattaCallback(StringMessages stringMessages, AdminConsoleView.Presenter presenter, Iterable<EventDTO> existingEvents) {
        this.sailingServiceWrite = presenter.getSailingService();
        this.errorReporter = presenter.getErrorReporter();
        this.presenter = presenter;
        this.stringMessages = stringMessages;
        this.existingEvents = existingEvents;
    }

    public void ok(RegattaDTO newRegatta) {
        this.createNewRegatta(newRegatta, this.existingEvents);
    }

    public void cancel() {
    }

    private void createNewRegatta(RegattaDTO newRegatta, Iterable<EventDTO> existingEvents) {
        LinkedHashMap<String, SeriesCreationParametersDTO> seriesStructure = new LinkedHashMap<String, SeriesCreationParametersDTO>();
        for (SeriesDTO seriesDTO : newRegatta.series) {
            SeriesCreationParametersDTO seriesPair = new SeriesCreationParametersDTO(seriesDTO.getFleets(), seriesDTO.isMedal(), seriesDTO.isFleetsCanRunInParallel(), seriesDTO.isStartsWithZeroScore().booleanValue(), seriesDTO.isFirstColumnIsNonDiscardableCarryForward(), seriesDTO.getDiscardThresholds(), seriesDTO.hasSplitFleetContiguousScoring(), seriesDTO.hasCrossFleetMergedRanking().booleanValue(), seriesDTO.getMaximumNumberOfDiscards(), seriesDTO.isOneAlwaysStaysOne());
            seriesStructure.put(seriesDTO.getName(), seriesPair);
        }
        this.sailingServiceWrite.createRegatta(newRegatta.getName(), newRegatta.boatClass == null ? null : newRegatta.boatClass.getName(), newRegatta.canBoatsOfCompetitorsChangePerRace, newRegatta.competitorRegistrationType, newRegatta.registrationLinkSecret, newRegatta.startDate, newRegatta.endDate, new RegattaCreationParametersDTO(seriesStructure), true, newRegatta.scoringScheme, (List)Util.mapToArrayList((Iterable)newRegatta.courseAreas, CourseAreaDTO::getId), newRegatta.buoyZoneRadiusInHullLengths, newRegatta.useStartTimeInference, newRegatta.controlTrackingFromStartAndFinishTimes, newRegatta.autoRestartTrackingUponCompetitorSetChange, newRegatta.rankingMetricType, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void createDefaultRacesIfDefaultSeriesIsPresent(RegattaDTO newRegatta) {
        for (SeriesDTO series : newRegatta.series) {
            if (!series.getName().equals("Default") || series.getRaceColumns().isEmpty()) continue;
            ArrayList<Util.Pair> raceColumnNamesToAddWithInsertIndex = new ArrayList<Util.Pair>();
            for (RaceColumnDTO newRaceColumn : series.getRaceColumns()) {
                raceColumnNamesToAddWithInsertIndex.add(new Util.Pair((Object)newRaceColumn.getName(), (Object)-1));
            }
            this.sailingServiceWrite.addRaceColumnsToSeries(newRegatta.getRegattaIdentifier(), series.getName(), raceColumnNamesToAddWithInsertIndex, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    private void reloadLeaderboards() {
        if (this.presenter.getLeaderboardsRefresher() != null) {
            this.presenter.getLeaderboardsRefresher().reloadAndCallFillAll();
        }
    }

    private void reloadRegattas() {
        if (this.presenter.getRegattasRefresher() != null) {
            this.presenter.getRegattasRefresher().reloadAndCallFillAll();
        }
    }

    private void fillEvents() {
        if (this.presenter.getEventsRefresher() != null) {
            this.presenter.getEventsRefresher().reloadAndCallFillAll();
        }
    }

    private void openCreateDefaultRegattaLeaderboardDialog(RegattaDTO newRegatta, Iterable<EventDTO> existingEvents) {
        CreateDefaultRegattaLeaderboardDialog dialog = new CreateDefaultRegattaLeaderboardDialog((SailingServiceAsync)this.sailingServiceWrite, this.stringMessages, this.errorReporter, newRegatta, (DataEntryDialog.DialogCallback)new /* Unavailable Anonymous Inner Class!! */);
        dialog.ensureDebugId("CreateDefaultRegattaLeaderboardDialog");
        dialog.show();
    }

    private void openRegattaLeaderboardToLeaderboardGroupOfEventLinkingDialog(StrippedLeaderboardDTO newRegattaLeaderboard, EventDTO eventToLinkRegattaTo) {
        LinkRegattaLeaderboardToLeaderboardGroupOfEventDialog dialog = new LinkRegattaLeaderboardToLeaderboardGroupOfEventDialog((SailingServiceAsync)this.sailingServiceWrite, this.stringMessages, this.errorReporter, newRegattaLeaderboard, eventToLinkRegattaTo, (DataEntryDialog.DialogCallback)new /* Unavailable Anonymous Inner Class!! */);
        dialog.ensureDebugId("LinkRegattaLeaderboardToLeaderboardGroupOfEventDialog");
        dialog.show();
    }

    private EventDTO getEventForCourseArea(Iterable<EventDTO> existingEvents, Iterable<CourseAreaDTO> courseAreas) {
        EventDTO result = null;
        for (EventDTO event : existingEvents) {
            if (event.getVenue() == null || !Util.containsAny((Iterable)event.getVenue().getCourseAreas(), courseAreas)) continue;
            result = event;
            break;
        }
        return result;
    }

    static /* synthetic */ ErrorReporter access$1(CreateRegattaCallback createRegattaCallback) {
        return createRegattaCallback.errorReporter;
    }

    static /* synthetic */ void access$2(CreateRegattaCallback createRegattaCallback, RegattaDTO regattaDTO) {
        createRegattaCallback.createDefaultRacesIfDefaultSeriesIsPresent(regattaDTO);
    }

    static /* synthetic */ void access$3(CreateRegattaCallback createRegattaCallback) {
        createRegattaCallback.reloadRegattas();
    }

    static /* synthetic */ void access$4(CreateRegattaCallback createRegattaCallback) {
        createRegattaCallback.fillEvents();
    }

    static /* synthetic */ void access$5(CreateRegattaCallback createRegattaCallback, RegattaDTO regattaDTO, Iterable iterable) {
        createRegattaCallback.openCreateDefaultRegattaLeaderboardDialog(regattaDTO, iterable);
    }

    static /* synthetic */ SailingServiceWriteAsync access$6(CreateRegattaCallback createRegattaCallback) {
        return createRegattaCallback.sailingServiceWrite;
    }

    static /* synthetic */ EventDTO access$7(CreateRegattaCallback createRegattaCallback, Iterable iterable, Iterable iterable2) {
        return createRegattaCallback.getEventForCourseArea(iterable, iterable2);
    }

    static /* synthetic */ void access$8(CreateRegattaCallback createRegattaCallback, StrippedLeaderboardDTO strippedLeaderboardDTO, EventDTO eventDTO) {
        createRegattaCallback.openRegattaLeaderboardToLeaderboardGroupOfEventLinkingDialog(strippedLeaderboardDTO, eventDTO);
    }

    static /* synthetic */ void access$9(CreateRegattaCallback createRegattaCallback) {
        createRegattaCallback.reloadLeaderboards();
    }

    static /* synthetic */ StringMessages access$10(CreateRegattaCallback createRegattaCallback) {
        return createRegattaCallback.stringMessages;
    }
}

