/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.adminconsole;

import com.google.gwt.core.shared.GWT;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.CaptionPanel;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.SelectionChangeEvent;
import com.google.gwt.view.client.SetSelectionModel;
import com.sap.sailing.domain.common.PassingInstruction;
import com.sap.sailing.domain.common.dto.RaceDTO;
import com.sap.sailing.domain.common.orc.impl.ORCPerformanceCurveLegImpl;
import com.sap.sailing.gwt.ui.adminconsole.ControlPointTableWrapper;
import com.sap.sailing.gwt.ui.adminconsole.CourseManagementWidget;
import com.sap.sailing.gwt.ui.adminconsole.GateCreationDialog;
import com.sap.sailing.gwt.ui.adminconsole.MarkTableWrapper;
import com.sap.sailing.gwt.ui.adminconsole.ORCPerformanceCurveAllLegsDialog;
import com.sap.sailing.gwt.ui.adminconsole.ORCPerformanceCurveLegDialog;
import com.sap.sailing.gwt.ui.adminconsole.TableWrapper;
import com.sap.sailing.gwt.ui.adminconsole.WaypointCreationDialog;
import com.sap.sailing.gwt.ui.adminconsole.WaypointImagesBarCell;
import com.sap.sailing.gwt.ui.adminconsole.WaypointTableWrapper;
import com.sap.sailing.gwt.ui.adminconsole.places.AdminConsoleView;
import com.sap.sailing.gwt.ui.client.SailingServiceWriteAsync;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.shared.ControlPointDTO;
import com.sap.sailing.gwt.ui.shared.GateDTO;
import com.sap.sailing.gwt.ui.shared.MarkDTO;
import com.sap.sailing.gwt.ui.shared.RaceCourseDTO;
import com.sap.sailing.gwt.ui.shared.WaypointDTO;
import com.sap.sse.common.Util;
import com.sap.sse.gwt.adminconsole.AdminConsoleTableResources;
import com.sap.sse.gwt.client.ErrorReporter;
import com.sap.sse.gwt.client.celltable.ImagesBarCell;
import com.sap.sse.gwt.client.celltable.RefreshableMultiSelectionModel;
import com.sap.sse.gwt.client.celltable.RefreshableSingleSelectionModel;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.dto.SecuredDTO;
import com.sap.sse.security.ui.client.UserService;
import com.sap.sse.security.ui.client.component.AccessControlledActionsColumn;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;

public abstract class CourseManagementWidget
implements IsWidget {
    protected final MarkTableWrapper<RefreshableMultiSelectionModel<MarkDTO>> marks;
    protected final ControlPointTableWrapper<RefreshableSingleSelectionModel<ControlPointDTO>> multiMarkControlPoints;
    protected final WaypointTableWrapper<RefreshableSingleSelectionModel<WaypointDTO>> waypoints;
    protected final Grid mainPanel;
    protected final SailingServiceWriteAsync sailingServiceWrite;
    protected final ErrorReporter errorReporter;
    protected final StringMessages stringMessages;
    protected final HorizontalPanel waypointsBtnsPanel;
    protected final HorizontalPanel controlPointsBtnsPanel;
    protected final HorizontalPanel marksBtnsPanel;
    protected final Button insertWaypointBefore;
    protected final Button insertWaypointAfter;
    protected final Button addControlPoint;
    private PassingInstruction lastSingleMarkPassingInstruction = PassingInstruction.Port;
    protected final AdminConsoleTableResources tableRes = (AdminConsoleTableResources)GWT.create(AdminConsoleTableResources.class);
    private final UserService userService;
    private SecuredDTO securedDtoForWaypointsPermissionCheck;
    private final Map<WaypointDTO, ORCPerformanceCurveLegImpl> orcPerformanceCurveLegInfo;

    public Widget asWidget() {
        return this.mainPanel;
    }

    public CourseManagementWidget(AdminConsoleView.Presenter presenter, StringMessages stringMessages, Supplier<Boolean> showOrcPcsLegEditActions) {
        this.sailingServiceWrite = presenter.getSailingService();
        this.errorReporter = presenter.getErrorReporter();
        this.stringMessages = stringMessages;
        this.userService = presenter.getUserService();
        this.orcPerformanceCurveLegInfo = new HashMap();
        this.mainPanel = new Grid(2, 3);
        this.mainPanel.setCellPadding(5);
        this.mainPanel.getRowFormatter().setVerticalAlign(0, HasVerticalAlignment.ALIGN_TOP);
        this.waypoints = new WaypointTableWrapper(false, this.sailingServiceWrite, stringMessages, this.errorReporter);
        this.multiMarkControlPoints = new ControlPointTableWrapper(false, this.sailingServiceWrite, stringMessages, this.errorReporter);
        this.marks = new MarkTableWrapper(true, this.sailingServiceWrite, stringMessages, this.errorReporter);
        ((RefreshableMultiSelectionModel)this.marks.getSelectionModel()).addSelectionChangeHandler((SelectionChangeEvent.Handler)new /* Unavailable Anonymous Inner Class!! */);
        CaptionPanel waypointsPanel = new CaptionPanel(stringMessages.waypoints());
        CaptionPanel controlPointsPanel = new CaptionPanel(stringMessages.twoMarkControlPoint());
        CaptionPanel marksPanel = new CaptionPanel(stringMessages.mark());
        waypointsPanel.add((IsWidget)this.waypoints);
        controlPointsPanel.add((IsWidget)this.multiMarkControlPoints);
        marksPanel.add((IsWidget)this.marks);
        this.mainPanel.setWidget(0, 0, (Widget)waypointsPanel);
        this.mainPanel.setWidget(0, 1, (Widget)controlPointsPanel);
        this.mainPanel.setWidget(0, 2, (Widget)marksPanel);
        this.waypointsBtnsPanel = new HorizontalPanel();
        this.controlPointsBtnsPanel = new HorizontalPanel();
        this.marksBtnsPanel = new HorizontalPanel();
        this.mainPanel.setWidget(1, 0, (Widget)this.waypointsBtnsPanel);
        this.mainPanel.setWidget(1, 1, (Widget)this.controlPointsBtnsPanel);
        this.mainPanel.setWidget(1, 2, (Widget)this.marksBtnsPanel);
        AccessControlledActionsColumn waypointsActionColumn = AccessControlledActionsColumn.create((ImagesBarCell)new WaypointImagesBarCell(stringMessages, this.waypoints.getDataProvider(), showOrcPcsLegEditActions), (UserService)this.userService, s -> this.securedDtoForWaypointsPermissionCheck);
        waypointsActionColumn.addAction(HasPermissions.DefaultActions.DELETE.name(), (HasPermissions.Action)HasPermissions.DefaultActions.UPDATE, waypoint -> this.removeWaypoint(waypoint));
        waypointsActionColumn.addAction("ACTION_DEFINE_LEG", (HasPermissions.Action)HasPermissions.DefaultActions.UPDATE, waypoint -> this.createOrcPcsLegEventForLegEndingAt(waypoint));
        waypointsActionColumn.addAction("ACTION_DEFINE_ALL_LEGS", (HasPermissions.Action)HasPermissions.DefaultActions.UPDATE, waypoint -> this.createOrcPcsLegEventsForAllLegs());
        this.waypoints.addColumn((Column)waypointsActionColumn);
        ((RefreshableSingleSelectionModel)this.waypoints.getSelectionModel()).addSelectionChangeHandler((SelectionChangeEvent.Handler)new /* Unavailable Anonymous Inner Class!! */);
        ((RefreshableSingleSelectionModel)this.multiMarkControlPoints.getSelectionModel()).addSelectionChangeHandler((SelectionChangeEvent.Handler)new /* Unavailable Anonymous Inner Class!! */);
        this.insertWaypointBefore = new Button(stringMessages.insertWaypointBeforeSelected());
        this.insertWaypointBefore.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.insertWaypointBefore.setEnabled(false);
        this.waypointsBtnsPanel.add((Widget)this.insertWaypointBefore);
        this.insertWaypointAfter = new Button(stringMessages.insertWaypointAfterSelected());
        this.insertWaypointAfter.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.insertWaypointAfter.setEnabled(false);
        this.waypointsBtnsPanel.add((Widget)this.insertWaypointAfter);
        this.addControlPoint = new Button(stringMessages.add(stringMessages.twoMarkControlPoint()));
        this.addControlPoint.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.controlPointsBtnsPanel.add((Widget)this.addControlPoint);
    }

    protected abstract LegGeometrySupplier getLegGeometrySupplier();

    protected Map<Integer, ORCPerformanceCurveLegImpl> getORCPerformanceCurveLegInfoByOneBasedWaypointIndex() {
        List waypointList = this.waypoints.getDataProvider().getList();
        HashMap<Integer, ORCPerformanceCurveLegImpl> result = new HashMap<Integer, ORCPerformanceCurveLegImpl>();
        for (Map.Entry e : this.orcPerformanceCurveLegInfo.entrySet()) {
            result.put(waypointList.indexOf(e.getKey()), (ORCPerformanceCurveLegImpl)e.getValue());
        }
        return result;
    }

    private void createOrcPcsLegEventForLegEndingAt(WaypointDTO waypoint) {
        new ORCPerformanceCurveLegDialog(this.stringMessages, waypoint, this.waypoints.getDataProvider(), (ORCPerformanceCurveLegImpl)this.orcPerformanceCurveLegInfo.get(waypoint), this.getLegGeometrySupplier(), (DataEntryDialog.Validator)new SingleLegValidator(this.stringMessages), (DataEntryDialog.DialogCallback)new /* Unavailable Anonymous Inner Class!! */).show();
    }

    private void createOrcPcsLegEventsForAllLegs() {
        new ORCPerformanceCurveAllLegsDialog(this.stringMessages, this.waypoints.getDataProvider(), this.getExplicitOrcPerformanceCurveLegInfos(), this.getLegGeometrySupplier(), (DataEntryDialog.Validator)new /* Unavailable Anonymous Inner Class!! */, (DataEntryDialog.DialogCallback)new /* Unavailable Anonymous Inner Class!! */).show();
    }

    private ORCPerformanceCurveLegImpl[] getExplicitOrcPerformanceCurveLegInfos() {
        ORCPerformanceCurveLegImpl[] result = new ORCPerformanceCurveLegImpl[this.waypoints.getDataProvider().getList().size() - 1];
        int i = 0;
        while (i < result.length) {
            result[i] = (ORCPerformanceCurveLegImpl)this.orcPerformanceCurveLegInfo.get(this.waypoints.getDataProvider().getList().get(i + 1));
            ++i;
        }
        return result;
    }

    protected void markSelectionChanged() {
    }

    private void removeWaypoint(WaypointDTO waypoint) {
        this.waypoints.getDataProvider().getList().remove(waypoint);
    }

    private void selectControlPoints(WaypointDTO waypoint) {
        for (ControlPointDTO controlPoint : this.multiMarkControlPoints.getDataProvider().getList()) {
            ((RefreshableSingleSelectionModel)this.multiMarkControlPoints.getSelectionModel()).setSelected((Object)controlPoint, waypoint.controlPoint == controlPoint);
        }
    }

    private void selectMarks(Iterable<MarkDTO> newMarks) {
        ((RefreshableMultiSelectionModel)this.marks.getSelectionModel()).clear();
        for (MarkDTO toSelect : newMarks) {
            ((RefreshableMultiSelectionModel)this.marks.getSelectionModel()).setSelected((Object)toSelect, true);
        }
    }

    protected void save() {
    }

    private <T> T getFirstSelected(SetSelectionModel<T> selectionModel) {
        if (selectionModel.getSelectedSet().isEmpty()) {
            return null;
        }
        return (T)selectionModel.getSelectedSet().iterator().next();
    }

    private <T> void insert(TableWrapper<T, ? extends SetSelectionModel<T>> tableWrapper, T toInsert, boolean beforeSelection) {
        int index = this.getInsertIndex(tableWrapper, beforeSelection);
        if (index != -1) {
            tableWrapper.getDataProvider().getList().add(index, toInsert);
        }
    }

    private <T> int getInsertIndex(TableWrapper<T, ? extends SetSelectionModel<T>> tableWrapper, boolean beforeSelection) {
        Object selected = this.getFirstSelected((SetSelectionModel)tableWrapper.getSelectionModel());
        int index = -1;
        if (tableWrapper.getDataProvider().getList().isEmpty()) {
            index = 0;
        } else if (selected != null) {
            index = tableWrapper.getDataProvider().getList().indexOf(selected) + (beforeSelection ? 0 : 1);
        }
        return index;
    }

    private void addMultiMarkControlPoint() {
        new GateCreationDialog(this.sailingServiceWrite, this.errorReporter, this.stringMessages, this.tableRes, this.marks.getDataProvider().getList(), (DataEntryDialog.DialogCallback)new /* Unavailable Anonymous Inner Class!! */).show();
    }

    private void insertWaypoint(boolean beforeSelection) {
        ArrayList allControlPoints = new ArrayList();
        allControlPoints.addAll(this.multiMarkControlPoints.getDataProvider().getList());
        allControlPoints.addAll(this.marks.getDataProvider().getList());
        int insertIndex = this.getInsertIndex((TableWrapper)this.waypoints, beforeSelection);
        new WaypointCreationDialog(this.sailingServiceWrite, this.errorReporter, this.stringMessages, this.tableRes, allControlPoints, (WaypointCreationDialog.DefaultPassingInstructionProvider)new /* Unavailable Anonymous Inner Class!! */, (DataEntryDialog.DialogCallback)new /* Unavailable Anonymous Inner Class!! */).show();
    }

    public abstract void refresh();

    protected void updateWaypointsAndControlPoints(RaceCourseDTO raceCourseDTO, String leaderboardName) {
        this.sailingServiceWrite.getLeaderboardWithSecurity(leaderboardName, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected void updateWaypointsAndControlPoints(RaceCourseDTO raceCourseDTO, RaceDTO raceDTO) {
        this.updateWaypointsAndControlPointsForSecuredObject(raceCourseDTO, (SecuredDTO)raceDTO);
    }

    private void updateWaypointsAndControlPointsForSecuredObject(RaceCourseDTO raceCourseDTO, SecuredDTO securedDTO) {
        this.securedDtoForWaypointsPermissionCheck = securedDTO;
        this.waypoints.getDataProvider().getList().clear();
        this.multiMarkControlPoints.getDataProvider().getList().clear();
        this.waypoints.getDataProvider().getList().addAll(raceCourseDTO.waypoints);
        HashMap<String, ControlPointDTO> noDuplicateCPs = new HashMap<String, ControlPointDTO>();
        for (ControlPointDTO controlPoint : raceCourseDTO.getControlPoints()) {
            if (!(controlPoint instanceof GateDTO)) continue;
            noDuplicateCPs.put(controlPoint.getIdAsString(), controlPoint);
        }
        this.multiMarkControlPoints.getDataProvider().getList().addAll(noDuplicateCPs.values());
        this.updateWaypointButtons();
        boolean hasUpdatePermission = this.userService.hasPermission(securedDTO, (HasPermissions.Action)HasPermissions.DefaultActions.UPDATE);
        this.insertWaypointAfter.setVisible(hasUpdatePermission);
        this.insertWaypointBefore.setVisible(hasUpdatePermission);
        this.addControlPoint.setVisible(hasUpdatePermission);
    }

    protected List<Util.Pair<ControlPointDTO, PassingInstruction>> createWaypointPairs() {
        ArrayList<Util.Pair<ControlPointDTO, PassingInstruction>> result = new ArrayList<Util.Pair<ControlPointDTO, PassingInstruction>>();
        for (WaypointDTO waypoint : this.waypoints.getDataProvider().getList()) {
            result.add((Util.Pair<ControlPointDTO, PassingInstruction>)new Util.Pair((Object)waypoint.controlPoint, (Object)waypoint.passingInstructions));
        }
        return result;
    }

    protected void updateWaypointButtons() {
        if (this.waypoints.getDataProvider().getList().isEmpty() || ((RefreshableSingleSelectionModel)this.waypoints.getSelectionModel()).getSelectedObject() != null) {
            this.insertWaypointAfter.setEnabled(true);
            this.insertWaypointBefore.setEnabled(true);
        } else {
            this.insertWaypointBefore.setEnabled(false);
            this.insertWaypointAfter.setEnabled(false);
        }
    }

    protected void refreshORCPerformanceCurveLegs(Map<Integer, ORCPerformanceCurveLegImpl> oneBasedLegIndexAndFixedLegData) {
        this.orcPerformanceCurveLegInfo.clear();
        List waypointList = this.waypoints.getDataProvider().getList();
        for (Map.Entry<Integer, ORCPerformanceCurveLegImpl> e : oneBasedLegIndexAndFixedLegData.entrySet()) {
            this.orcPerformanceCurveLegInfo.put((WaypointDTO)waypointList.get(e.getKey()), e.getValue());
        }
    }

    static /* synthetic */ void access$0(CourseManagementWidget courseManagementWidget, WaypointDTO waypointDTO) {
        courseManagementWidget.selectControlPoints(waypointDTO);
    }

    static /* synthetic */ void access$1(CourseManagementWidget courseManagementWidget, Iterable iterable) {
        courseManagementWidget.selectMarks(iterable);
    }

    static /* synthetic */ void access$2(CourseManagementWidget courseManagementWidget, boolean bl) {
        courseManagementWidget.insertWaypoint(bl);
    }

    static /* synthetic */ void access$3(CourseManagementWidget courseManagementWidget) {
        courseManagementWidget.addMultiMarkControlPoint();
    }

    static /* synthetic */ Map access$4(CourseManagementWidget courseManagementWidget) {
        return courseManagementWidget.orcPerformanceCurveLegInfo;
    }

    static /* synthetic */ PassingInstruction access$5(CourseManagementWidget courseManagementWidget) {
        return courseManagementWidget.lastSingleMarkPassingInstruction;
    }

    static /* synthetic */ void access$6(CourseManagementWidget courseManagementWidget, TableWrapper tableWrapper, Object object, boolean bl) {
        courseManagementWidget.insert(tableWrapper, object, bl);
    }

    static /* synthetic */ void access$7(CourseManagementWidget courseManagementWidget, PassingInstruction passingInstruction) {
        courseManagementWidget.lastSingleMarkPassingInstruction = passingInstruction;
    }

    static /* synthetic */ void access$8(CourseManagementWidget courseManagementWidget, RaceCourseDTO raceCourseDTO, SecuredDTO securedDTO) {
        courseManagementWidget.updateWaypointsAndControlPointsForSecuredObject(raceCourseDTO, securedDTO);
    }
}

