/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.adminconsole;

import com.google.gwt.user.client.ui.CaptionPanel;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.domain.common.dto.CourseAreaDTO;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public class CourseAreaSelection
extends CaptionPanel {
    private final VerticalPanel checkboxPanel = new VerticalPanel();
    private final Map<CourseAreaDTO, CheckBox> checkboxes = new HashMap();
    private final Set<CourseAreaDTO> selectedSet = new HashSet();
    private final Function<String, CheckBox> checkboxConstructor;

    public CourseAreaSelection(StringMessages stringMessages) {
        this(Collections.emptySet(), stringMessages, CheckBox::new);
    }

    public CourseAreaSelection(StringMessages stringMessages, DataEntryDialog<?> dialog) {
        this(Collections.emptySet(), stringMessages, arg_0 -> dialog.createCheckbox(arg_0));
    }

    public CourseAreaSelection(Iterable<CourseAreaDTO> courseAreas, StringMessages stringMessages, Function<String, CheckBox> checkboxConstructor) {
        super(stringMessages.selectCourseArea());
        this.checkboxConstructor = checkboxConstructor;
        this.add((Widget)this.checkboxPanel);
        for (CourseAreaDTO courseArea : courseAreas) {
            this.addCourseArea(courseArea);
        }
    }

    public void addCourseArea(CourseAreaDTO courseArea) {
        CheckBox checkbox = (CheckBox)this.checkboxConstructor.apply(courseArea.getName());
        this.checkboxes.put(courseArea, checkbox);
        checkbox.addValueChangeHandler(e -> this.setSelected(courseArea, ((Boolean)e.getValue()).booleanValue()));
        this.checkboxPanel.add((Widget)checkbox);
    }

    public void setSelected(CourseAreaDTO courseArea, boolean selected) {
        CheckBox checkbox = (CheckBox)this.checkboxes.get(courseArea);
        if (checkbox != null) {
            if (selected) {
                this.selectedSet.add(courseArea);
            } else {
                this.selectedSet.remove(courseArea);
            }
            checkbox.setValue(Boolean.valueOf(selected));
        }
    }

    public Iterable<CourseAreaDTO> getSelectedCourseAreas() {
        return this.selectedSet;
    }

    public void setEnabled(boolean b) {
        for (CheckBox checkbox : this.checkboxes.values()) {
            checkbox.setEnabled(b);
        }
    }

    public void removeAll() {
        for (CourseAreaDTO courseArea : new ArrayList(this.checkboxes.keySet())) {
            CheckBox checkbox = (CheckBox)this.checkboxes.remove(courseArea);
            this.checkboxPanel.remove((Widget)checkbox);
        }
        this.selectedSet.clear();
    }

    public void setSelectedSet(Iterable<CourseAreaDTO> selectedCourseAreas) {
        this.selectedSet.clear();
        for (CourseAreaDTO selected : selectedCourseAreas) {
            this.setSelected(selected, true);
        }
    }
}

