/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.adminconsole;

import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.domain.common.dto.BoatDTO;
import com.sap.sailing.domain.common.dto.CompetitorDTO;
import com.sap.sailing.domain.common.dto.RaceColumnDTO;
import com.sap.sailing.gwt.ui.adminconsole.AbstractLeaderboardDialog;
import com.sap.sailing.gwt.ui.adminconsole.CopyPairingListDialog;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.shared.RaceWithCompetitorsAndBoatsDTO;
import com.sap.sailing.gwt.ui.shared.RegattaDTO;
import com.sap.sailing.gwt.ui.shared.SeriesDTO;
import com.sap.sailing.gwt.ui.shared.StrippedLeaderboardDTO;
import com.sap.sse.common.Util;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CopyPairingListDialog
extends DataEntryDialog<Result> {
    private final StringMessages stringMessages;
    private final ListBox sourceLeaderboardListBox;
    private final Map<String, RegattaDTO> regattasByName = new HashMap();
    private final Collection<StrippedLeaderboardDTO> otherLeaderboards;
    private List<RaceColumnDTO> raceColumnsOfSourceRegatta;
    private final ListBox fromRaceColumnListBox;
    private final ListBox toRaceColumnInclusiveListBox;

    public CopyPairingListDialog(Collection<StrippedLeaderboardDTO> availableLeaderboards, Collection<RegattaDTO> availableRegattas, StrippedLeaderboardDTO targetLeaderboardDTO, StringMessages stringMessages, DataEntryDialog.DialogCallback<Result> dialogCallback) {
        super(stringMessages.copyPairingListFromOtherLeaderboard(), null, stringMessages.ok(), stringMessages.cancel(), (DataEntryDialog.Validator)new Validator(stringMessages), dialogCallback);
        availableRegattas.forEach(r -> {
            RegattaDTO regattaDTO = this.regattasByName.put(r.getName(), r);
        });
        RegattaDTO targetRegatta = (RegattaDTO)this.regattasByName.get(targetLeaderboardDTO.regattaName);
        this.otherLeaderboards = Util.asList((Iterable)Util.filter(availableLeaderboards, l -> l != targetLeaderboardDTO && l.canBoatsOfCompetitorsChangePerRace && l.type.isRegattaLeaderboard() && this.regattasByName.containsKey(l.regattaName) && this.doCompetitorsAndBoatsMatch((RegattaDTO)this.regattasByName.get(l.regattaName), targetRegatta)));
        this.sourceLeaderboardListBox = AbstractLeaderboardDialog.createSortedRegattaLeaderboardsListBox((Collection)this.otherLeaderboards, null, (StringMessages)stringMessages, (DataEntryDialog)this);
        this.sourceLeaderboardListBox.addChangeHandler(arg_0 -> this.onOtherLeaderboardSelected(arg_0));
        this.fromRaceColumnListBox = this.createListBox(false);
        this.fromRaceColumnListBox.addChangeHandler(e -> this.updateToRaceColumnListBox(this.fromRaceColumnListBox.getSelectedValue()));
        this.toRaceColumnInclusiveListBox = this.createListBox(false);
        this.stringMessages = stringMessages;
    }

    private void updateToRaceColumnListBox(String selectedFromRaceColumnName) {
        String previouslySelectedToRaceColumnName = this.toRaceColumnInclusiveListBox.getSelectedValue();
        this.toRaceColumnInclusiveListBox.clear();
        boolean foundSelected = false;
        int i = 0;
        for (RaceColumnDTO raceColumn : this.raceColumnsOfSourceRegatta) {
            boolean bl = foundSelected = foundSelected || Util.equalsWithNull((Object)selectedFromRaceColumnName, (Object)raceColumn.getName());
            if (!foundSelected) continue;
            this.toRaceColumnInclusiveListBox.addItem(raceColumn.getName(), raceColumn.getName());
            if (Util.equalsWithNull((Object)raceColumn.getName(), (Object)previouslySelectedToRaceColumnName)) {
                this.toRaceColumnInclusiveListBox.setSelectedIndex(i);
            }
            ++i;
        }
    }

    private void onOtherLeaderboardSelected(ChangeEvent e) {
        RegattaDTO sourceRegatta = (RegattaDTO)this.regattasByName.get(this.sourceLeaderboardListBox.getSelectedValue());
        if (sourceRegatta == null) {
            this.fromRaceColumnListBox.clear();
            this.toRaceColumnInclusiveListBox.clear();
            this.raceColumnsOfSourceRegatta = Collections.emptyList();
        } else {
            this.raceColumnsOfSourceRegatta = this.getRaceColumns(sourceRegatta);
            this.fromRaceColumnListBox.clear();
            this.toRaceColumnInclusiveListBox.clear();
            for (RaceColumnDTO raceColumn : this.raceColumnsOfSourceRegatta) {
                this.fromRaceColumnListBox.addItem(raceColumn.getName(), raceColumn.getName());
                this.toRaceColumnInclusiveListBox.addItem(raceColumn.getName(), raceColumn.getName());
            }
        }
    }

    private List<RaceColumnDTO> getRaceColumns(RegattaDTO regatta) {
        ArrayList<RaceColumnDTO> raceColumns = new ArrayList<RaceColumnDTO>();
        if (regatta != null) {
            for (SeriesDTO series : regatta.series) {
                for (RaceColumnDTO raceColumn : series.getRaceColumns()) {
                    raceColumns.add(raceColumn);
                }
            }
        }
        return raceColumns;
    }

    private boolean doCompetitorsAndBoatsMatch(RegattaDTO regatta, RegattaDTO targetRegatta) {
        return !(!Util.isEmpty((Iterable)this.getBoats(targetRegatta)) && !this.getBoats(regatta).equals(this.getBoats(targetRegatta)) || !Util.isEmpty((Iterable)this.getCompetitors(targetRegatta)) && !this.getCompetitors(regatta).equals(this.getCompetitors(targetRegatta)));
    }

    private Set<CompetitorDTO> getCompetitors(RegattaDTO regatta) {
        HashSet<CompetitorDTO> result = new HashSet<CompetitorDTO>();
        for (RaceWithCompetitorsAndBoatsDTO r : regatta.races) {
            r.getCompetitors().forEach(result::add);
        }
        return result;
    }

    private Set<BoatDTO> getBoats(RegattaDTO regatta) {
        HashSet<BoatDTO> result = new HashSet<BoatDTO>();
        for (RaceWithCompetitorsAndBoatsDTO r : regatta.races) {
            r.getBoats().forEach(result::add);
        }
        return result;
    }

    protected Widget getAdditionalWidget() {
        Grid result = new Grid(2, 2);
        int row = 0;
        result.setWidget(row, 0, (Widget)new Label(this.stringMessages.selectALeaderboard()));
        result.setWidget(row++, 1, (Widget)this.sourceLeaderboardListBox);
        result.setWidget(row, 0, (Widget)new Label(this.stringMessages.selectRaceColumnsWhosePairingsToCopy()));
        HorizontalPanel hp = new HorizontalPanel();
        result.setWidget(row++, 1, (Widget)hp);
        hp.add((Widget)new Label(this.stringMessages.from()));
        hp.add((Widget)this.fromRaceColumnListBox);
        hp.add((Widget)new Label(this.stringMessages.to()));
        hp.add((Widget)this.toRaceColumnInclusiveListBox);
        this.validateAndUpdate();
        return result;
    }

    protected Result getResult() {
        String selectedLeaderboardName = this.sourceLeaderboardListBox.getSelectedIndex() == 0 ? null : this.sourceLeaderboardListBox.getSelectedValue();
        return new Result(selectedLeaderboardName, this.fromRaceColumnListBox.getSelectedValue(), this.toRaceColumnInclusiveListBox.getSelectedValue());
    }
}

