/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.adminconsole;

import com.google.gwt.i18n.client.LocaleInfo;
import com.sap.sailing.domain.common.dto.CompetitorDTO;
import com.sap.sailing.gwt.ui.adminconsole.SelectEventAndHostnameDialog;
import com.sap.sailing.gwt.ui.client.SailingServiceAsync;
import com.sap.sailing.gwt.ui.client.SailingServiceWriteAsync;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sse.gwt.client.ErrorReporter;
import com.sap.sse.gwt.client.Notification;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;
import java.util.Set;

public class CompetitorInvitationHelper {
    private StringMessages stringMessages;
    private SailingServiceWriteAsync sailingServiceWrite;
    private ErrorReporter errorReporter;

    public CompetitorInvitationHelper(SailingServiceWriteAsync sailingServiceWrite, StringMessages stringMessages, ErrorReporter errorReporter) {
        this.stringMessages = stringMessages;
        this.sailingServiceWrite = sailingServiceWrite;
        this.errorReporter = errorReporter;
    }

    public void inviteCompetitors(Set<CompetitorDTO> competitors, String leaderboardName) {
        if (competitors.size() == 0) {
            Notification.notify((String)this.stringMessages.selectAtLeastOneCompetitorForInvitation(), (Notification.NotificationType)Notification.NotificationType.ERROR);
        } else {
            boolean emailProvidedForAll = this.isEmailProvidedForAll(competitors);
            if (emailProvidedForAll) {
                this.openChooseEventDialogAndSendMails(competitors, leaderboardName);
            } else {
                Notification.notify((String)this.stringMessages.notAllCompetitorsProvideEmail(), (Notification.NotificationType)Notification.NotificationType.ERROR);
            }
        }
    }

    private boolean isEmailProvidedForAll(Iterable<CompetitorDTO> allCompetitors) {
        for (CompetitorDTO competitor : allCompetitors) {
            if (competitor.hasEmail()) continue;
            return false;
        }
        return true;
    }

    private void openChooseEventDialogAndSendMails(Set<CompetitorDTO> competitors, String leaderboardName) {
        new SelectEventAndHostnameDialog((SailingServiceAsync)this.sailingServiceWrite, this.stringMessages, this.errorReporter, leaderboardName, (DataEntryDialog.DialogCallback)new /* Unavailable Anonymous Inner Class!! */).show();
    }

    private String getLocaleInfo() {
        return LocaleInfo.getCurrentLocale().getLocaleName();
    }

    static /* synthetic */ SailingServiceWriteAsync access$0(CompetitorInvitationHelper competitorInvitationHelper) {
        return competitorInvitationHelper.sailingServiceWrite;
    }

    static /* synthetic */ StringMessages access$1(CompetitorInvitationHelper competitorInvitationHelper) {
        return competitorInvitationHelper.stringMessages;
    }

    static /* synthetic */ String access$2(CompetitorInvitationHelper competitorInvitationHelper) {
        return competitorInvitationHelper.getLocaleInfo();
    }
}

