/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.adminconsole;

import com.google.gwt.dom.client.Style;
import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Focusable;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.domain.common.DetailType;
import com.sap.sailing.domain.common.dto.CompetitorDTO;
import com.sap.sailing.domain.common.dto.CompetitorWithBoatDTOImpl;
import com.sap.sailing.gwt.ui.adminconsole.CompetitorEditDialog;
import com.sap.sailing.gwt.ui.client.DetailTypeFormatter;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sse.common.Duration;
import com.sap.sse.common.impl.MillisecondsDurationImpl;
import com.sap.sse.gwt.adminconsole.URLFieldWithFileUpload;
import com.sap.sse.gwt.client.ColorTextBox;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;
import com.sap.sse.gwt.client.dialog.DialogUtils;
import com.sap.sse.gwt.client.dialog.DoubleBox;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class CompetitorEditDialog<CompetitorType extends CompetitorDTO>
extends DataEntryDialog<CompetitorType> {
    private static final double YARDSTICK_100 = 100.0;
    private static final double YARDSTICK_1000 = 1000.0;
    private final CompetitorType competitorToEdit;
    private final TextBox name;
    private final TextBox shortName;
    private final ColorTextBox displayColorTextBox;
    private final ListBox threeLetterIocCountryCode;
    private final TextBox email;
    private final TextBox searchTag;
    private final StringMessages stringMessages;
    private final URLFieldWithFileUpload flagImageURL;
    private final URLFieldWithFileUpload imageUrlAndUploadComposite;
    private final Label yardstickLabel;
    private final FlowPanel yardstickPanel;
    private final DoubleBox yardstickNumber;
    private double yardstickScale = 100.0;
    private boolean enableYardstickScaleDetection = true;
    private boolean yardstickLastModified = true;
    private final DoubleBox timeOnTimeFactor;
    private final DoubleBox timeOnDistanceAllowanceInSecondsPerNauticalMile;

    public static CompetitorEditDialog<CompetitorDTO> create(StringMessages stringMessages, CompetitorDTO competitorToEdit, DataEntryDialog.DialogCallback<CompetitorDTO> callback) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    protected CompetitorEditDialog(String dialogTitle, StringMessages stringMessages, CompetitorType competitorToEdit, DataEntryDialog.Validator<CompetitorType> validator, DataEntryDialog.DialogCallback<CompetitorType> callback) {
        super(dialogTitle, null, stringMessages.ok(), stringMessages.cancel(), validator, true, callback);
        this.ensureDebugId("CompetitorEditDialog");
        this.stringMessages = stringMessages;
        this.competitorToEdit = competitorToEdit;
        this.name = this.createTextBox(competitorToEdit.getName());
        this.name.ensureDebugId("NameTextBox");
        this.shortName = this.createTextBox(competitorToEdit.getShortName());
        this.shortName.ensureDebugId("ShortNameTextBox");
        this.email = this.createTextBox(competitorToEdit.getEmail());
        this.searchTag = this.createTextBox(competitorToEdit.getSearchTag());
        this.displayColorTextBox = this.createColorTextBox(competitorToEdit.getColor());
        this.threeLetterIocCountryCode = this.createListBox(false);
        DialogUtils.makeCountrySelection((ListBox)this.threeLetterIocCountryCode, (String)competitorToEdit.getThreeLetterIocCountryCode());
        this.flagImageURL = new URLFieldWithFileUpload((com.sap.sse.gwt.adminconsole.StringMessages)stringMessages, "image/*");
        this.flagImageURL.setUri(competitorToEdit.getFlagImageURL());
        this.imageUrlAndUploadComposite = new URLFieldWithFileUpload((com.sap.sse.gwt.adminconsole.StringMessages)stringMessages, "image/*");
        this.imageUrlAndUploadComposite.setUri(competitorToEdit.getImageURL());
        this.getCancelButton().addClickHandler(clickEvent -> {
            this.flagImageURL.deleteCurrentFile();
            this.imageUrlAndUploadComposite.deleteCurrentFile();
        });
        this.yardstickLabel = new Label(stringMessages.yardstickNumber(this.yardstickScale));
        this.yardstickNumber = this.createDoubleBox(competitorToEdit.getTimeOnTimeFactor() == null ? null : Double.valueOf(CompetitorEditDialog.convertYardstickTimeOnTime((double)competitorToEdit.getTimeOnTimeFactor(), (double)this.yardstickScale)), 10);
        Button yardstickScaleButton = new Button(SafeHtmlUtils.fromSafeConstant((String)stringMessages.changeScale()));
        yardstickScaleButton.getElement().getStyle().setMarginLeft(3.0, Style.Unit.PX);
        this.yardstickPanel = new FlowPanel();
        this.yardstickPanel.add((Widget)this.yardstickNumber);
        this.yardstickPanel.add((Widget)yardstickScaleButton);
        this.timeOnTimeFactor = this.createDoubleBox(competitorToEdit.getTimeOnTimeFactor(), 10);
        this.yardstickNumber.addChangeHandler(event -> {
            if (this.yardstickNumber.getValue() == null) {
                this.enableYardstickScaleDetection = true;
            }
            this.detectAndSetYardstickScale();
            this.convertYardstickToToT();
            this.yardstickLastModified = true;
        });
        this.timeOnTimeFactor.addChangeHandler(event -> {
            if (this.timeOnTimeFactor.getValue() != null) {
                this.yardstickNumber.setValue((Object)CompetitorEditDialog.convertYardstickTimeOnTime((double)((Double)this.timeOnTimeFactor.getValue()), (double)this.yardstickScale), false);
            }
            this.yardstickLastModified = false;
        });
        yardstickScaleButton.addClickHandler(event -> {
            this.enableYardstickScaleDetection = false;
            this.setYardstickScale(this.yardstickScale == 1000.0 ? 100.0 : 1000.0, !this.yardstickLastModified);
            this.convertYardstickToToT();
        });
        this.timeOnDistanceAllowanceInSecondsPerNauticalMile = this.createDoubleBox(competitorToEdit.getTimeOnDistanceAllowancePerNauticalMile() == null ? null : Double.valueOf(competitorToEdit.getTimeOnDistanceAllowancePerNauticalMile().asSeconds()), 10);
    }

    private void convertYardstickToToT() {
        if (this.yardstickNumber.getValue() != null) {
            this.timeOnTimeFactor.setValue((Object)CompetitorEditDialog.convertYardstickTimeOnTime((double)((Double)this.yardstickNumber.getValue()), (double)this.yardstickScale), false);
        }
    }

    protected Focusable getInitialFocusWidget() {
        return this.name;
    }

    protected abstract CompetitorType getResult();

    protected CompetitorDTO getBaseResult() {
        Object color = this.displayColorTextBox.isValid() ? this.displayColorTextBox.getColor() : new InvalidColor((Exception)new IllegalArgumentException(this.displayColorTextBox.getValue()), this.stringMessages);
        CompetitorWithBoatDTOImpl result = new CompetitorWithBoatDTOImpl(this.name.getText(), this.shortName.getText().trim().isEmpty() ? null : this.shortName.getText(), color, this.email.getText().trim().isEmpty() ? null : this.email.getText(), null, this.threeLetterIocCountryCode.getValue(this.threeLetterIocCountryCode.getSelectedIndex()), null, this.competitorToEdit.getIdAsString(), this.imageUrlAndUploadComposite.getUri(), this.flagImageURL.getUri(), (Double)this.timeOnTimeFactor.getValue(), (Duration)(this.timeOnDistanceAllowanceInSecondsPerNauticalMile.getValue() == null ? null : new MillisecondsDurationImpl((long)((Double)this.timeOnDistanceAllowanceInSecondsPerNauticalMile.getValue() * 1000.0))), this.searchTag.getValue(), null);
        return result;
    }

    protected void setYardstickScale(double scale, boolean convertYardstickNumber) {
        if (convertYardstickNumber && this.yardstickNumber.getValue() != null) {
            double norm = (Double)this.yardstickNumber.getValue() / this.yardstickScale;
            this.yardstickNumber.setValue((Object)(norm * scale), false);
        }
        this.yardstickScale = scale;
        this.yardstickLabel.setText(this.stringMessages.yardstickNumber(this.yardstickScale));
    }

    private void detectAndSetYardstickScale() {
        Double number;
        if (this.enableYardstickScaleDetection && (number = (Double)this.yardstickNumber.getValue()) != null) {
            if (number < 550.0) {
                this.setYardstickScale(100.0, false);
            } else {
                this.setYardstickScale(1000.0, false);
            }
        }
    }

    private static double convertYardstickTimeOnTime(double yardstickOrTimeOnTime, double scale) {
        return scale / yardstickOrTimeOnTime;
    }

    protected Widget getAdditionalWidget() {
        Grid result = new Grid(11, 2);
        result.setWidget(0, 0, (Widget)new Label(this.stringMessages.name()));
        result.setWidget(0, 1, (Widget)this.name);
        result.setWidget(1, 0, (Widget)new Label(this.stringMessages.shortName()));
        result.setWidget(1, 1, (Widget)this.shortName);
        result.setWidget(2, 0, (Widget)new Label(this.stringMessages.nationality()));
        result.setWidget(2, 1, (Widget)this.threeLetterIocCountryCode);
        result.setWidget(3, 0, (Widget)new Label(this.stringMessages.color()));
        result.setWidget(3, 1, (Widget)this.displayColorTextBox);
        result.setWidget(4, 0, (Widget)new Label(this.stringMessages.email()));
        result.setWidget(4, 1, (Widget)this.email);
        result.setWidget(5, 0, (Widget)new Label(this.stringMessages.searchTag()));
        result.setWidget(5, 1, (Widget)this.searchTag);
        result.setWidget(6, 0, (Widget)new Label(this.stringMessages.flagImageURL()));
        result.setWidget(6, 1, (Widget)this.flagImageURL);
        result.setWidget(7, 0, (Widget)new Label(this.stringMessages.imageURL()));
        result.setWidget(7, 1, (Widget)this.imageUrlAndUploadComposite);
        result.setWidget(8, 0, (Widget)this.yardstickLabel);
        result.setWidget(8, 1, (Widget)this.yardstickPanel);
        result.setWidget(9, 0, (Widget)new Label(this.stringMessages.timeOnTimeFactor()));
        result.setWidget(9, 1, (Widget)this.timeOnTimeFactor);
        result.setWidget(10, 0, (Widget)new Label(String.valueOf(this.stringMessages.timeOnDistanceAllowanceInSecondsPerNauticalMile()) + " [" + DetailTypeFormatter.getUnit((DetailType)DetailType.OVERALL_TIME_ON_DISTANCE_ALLOWANCE_IN_SECONDS_PER_NAUTICAL_MILE) + "]"));
        result.setWidget(10, 1, (Widget)this.timeOnDistanceAllowanceInSecondsPerNauticalMile);
        return result;
    }

    protected CompetitorType getCompetitorToEdit() {
        return (CompetitorType)this.competitorToEdit;
    }

    protected StringMessages getStringMessages() {
        return this.stringMessages;
    }
}

