/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.adminconsole;

import com.google.gwt.core.client.Callback;
import com.google.gwt.user.cellview.client.AbstractCellTable;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.ColumnSortEvent;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.domain.common.dto.BoatDTO;
import com.sap.sailing.domain.common.dto.CompetitorDTO;
import com.sap.sailing.domain.common.security.SecuredDomainType;
import com.sap.sailing.gwt.ui.adminconsole.BoatConfigImagesBarCell;
import com.sap.sailing.gwt.ui.adminconsole.BoatEditDialog;
import com.sap.sailing.gwt.ui.adminconsole.BoatTableWrapper;
import com.sap.sailing.gwt.ui.adminconsole.ColorColumn;
import com.sap.sailing.gwt.ui.adminconsole.TableWrapper;
import com.sap.sailing.gwt.ui.client.Refresher;
import com.sap.sailing.gwt.ui.client.SailingServiceWriteAsync;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sse.common.Util;
import com.sap.sse.gwt.client.ErrorReporter;
import com.sap.sse.gwt.client.celltable.EntityIdentityComparator;
import com.sap.sse.gwt.client.celltable.FlushableCellTable;
import com.sap.sse.gwt.client.celltable.ImagesBarCell;
import com.sap.sse.gwt.client.celltable.RefreshableSelectionModel;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;
import com.sap.sse.gwt.client.panels.LabeledAbstractFilterablePanel;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.dto.SecuredDTO;
import com.sap.sse.security.ui.client.UserManagementWriteServiceAsync;
import com.sap.sse.security.ui.client.UserService;
import com.sap.sse.security.ui.client.component.AccessControlledActionsColumn;
import com.sap.sse.security.ui.client.component.EditOwnershipDialog;
import com.sap.sse.security.ui.client.component.SecuredDTOOwnerColumn;
import com.sap.sse.security.ui.client.component.editacl.EditACLDialog;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class BoatTableWrapper<S extends RefreshableSelectionModel<BoatDTO>>
extends TableWrapper<BoatDTO, S> {
    private final LabeledAbstractFilterablePanel<BoatDTO> filterField;
    private final SailingServiceWriteAsync sailingServiceWrite;
    private final Refresher<BoatDTO> boatsRefresher;
    private final Refresher<CompetitorDTO> competitorsRefresher;

    public BoatTableWrapper(SailingServiceWriteAsync sailingServiceWrite, UserService userService, Refresher<BoatDTO> boatsRefresher, Refresher<CompetitorDTO> competitorsRefresher, StringMessages stringMessages, ErrorReporter errorReporter, boolean multiSelection, boolean enablePager, boolean allowActions) {
        this(sailingServiceWrite, userService, boatsRefresher, competitorsRefresher, stringMessages, errorReporter, multiSelection, enablePager, 100, allowActions);
    }

    public BoatTableWrapper(SailingServiceWriteAsync sailingServiceWrite, UserService userService, Refresher<BoatDTO> boatsRefresher, Refresher<CompetitorDTO> competitorsRefresher, StringMessages stringMessages, ErrorReporter errorReporter, boolean multiSelection, boolean enablePager, int pagingSize, boolean allowActions) {
        super(sailingServiceWrite, stringMessages, errorReporter, multiSelection, enablePager, pagingSize, (EntityIdentityComparator)new /* Unavailable Anonymous Inner Class!! */);
        this.boatsRefresher = boatsRefresher;
        this.competitorsRefresher = competitorsRefresher;
        this.sailingServiceWrite = sailingServiceWrite;
        ColumnSortEvent.ListHandler boatColumnListHandler = this.getColumnSortHandler();
        2 boatNameColumn = new /* Unavailable Anonymous Inner Class!! */;
        boatNameColumn.setSortable(true);
        boatColumnListHandler.setComparator((Column)boatNameColumn, (Comparator)new /* Unavailable Anonymous Inner Class!! */);
        4 boatClassColumn = new /* Unavailable Anonymous Inner Class!! */;
        boatClassColumn.setSortable(true);
        boatColumnListHandler.setComparator((Column)boatClassColumn, (Comparator)new /* Unavailable Anonymous Inner Class!! */);
        6 sailIdColumn = new /* Unavailable Anonymous Inner Class!! */;
        sailIdColumn.setSortable(true);
        boatColumnListHandler.setComparator((Column)sailIdColumn, (Comparator)new /* Unavailable Anonymous Inner Class!! */);
        ColorColumn boatColorColumn = new ColorColumn((ColorColumn.ColorRetriever)new /* Unavailable Anonymous Inner Class!! */);
        boatColorColumn.setSortable(true);
        boatColumnListHandler.setComparator((Column)boatColorColumn, (Comparator)new /* Unavailable Anonymous Inner Class!! */);
        10 boatIdColumn = new /* Unavailable Anonymous Inner Class!! */;
        boatIdColumn.setSortable(true);
        boatColumnListHandler.setComparator((Column)boatIdColumn, (Comparator)new /* Unavailable Anonymous Inner Class!! */);
        this.filterField = new /* Unavailable Anonymous Inner Class!! */;
        this.filterField.setUpdatePermissionFilterForCheckbox(boat -> {
            if (boat != null && boat.getIdAsString() != null && userService.hasPermission((SecuredDTO)boat, (HasPermissions.Action)HasPermissions.DefaultActions.UPDATE)) {
                return true;
            }
            return false;
        });
        this.registerSelectionModelOnNewDataProvider(this.filterField.getAllListDataProvider());
        HasPermissions type = SecuredDomainType.BOAT;
        AccessControlledActionsColumn boatActionColumn = AccessControlledActionsColumn.create((ImagesBarCell)new BoatConfigImagesBarCell((StringMessages)this.getStringMessages()), (UserService)userService);
        boatActionColumn.addAction(BoatConfigImagesBarCell.ACTION_UPDATE, (HasPermissions.Action)HasPermissions.DefaultActions.UPDATE, arg_0 -> this.openEditBoatDialog(arg_0));
        boatActionColumn.addAction("ACTION_REFRESH", arg_0 -> this.allowUpdate(arg_0));
        EditOwnershipDialog.DialogConfig editOwnerShipDialog = EditOwnershipDialog.create((UserManagementWriteServiceAsync)userService.getUserManagementWriteService(), (HasPermissions)SecuredDomainType.BOAT, boatDTO -> this.getFilterField().filter(), (com.sap.sse.security.ui.client.i18n.StringMessages)stringMessages);
        boatActionColumn.addAction(BoatConfigImagesBarCell.ACTION_CHANGE_OWNERSHIP, (HasPermissions.Action)HasPermissions.DefaultActions.CHANGE_OWNERSHIP, arg_0 -> ((EditOwnershipDialog.DialogConfig)editOwnerShipDialog).openOwnershipDialog(arg_0));
        EditACLDialog.DialogConfig configACL = EditACLDialog.create((UserManagementWriteServiceAsync)userService.getUserManagementWriteService(), (HasPermissions)type, null, (com.sap.sse.security.ui.client.i18n.StringMessages)stringMessages);
        boatActionColumn.addAction(BoatConfigImagesBarCell.ACTION_CHANGE_ACL, (HasPermissions.Action)HasPermissions.DefaultActions.CHANGE_ACL, arg_0 -> ((EditACLDialog.DialogConfig)configACL).openDialog(arg_0));
        this.mainPanel.insert((Widget)this.filterField, 0);
        this.table.addColumnSortHandler((ColumnSortEvent.Handler)boatColumnListHandler);
        this.table.addColumn((Column)boatNameColumn, stringMessages.name());
        this.table.addColumn((Column)sailIdColumn, stringMessages.sailNumber());
        this.table.addColumn((Column)boatClassColumn, stringMessages.boatClass());
        this.table.addColumn((Column)boatColorColumn, stringMessages.color());
        this.table.addColumn((Column)boatIdColumn, stringMessages.id());
        SecuredDTOOwnerColumn.configureOwnerColumns((AbstractCellTable)this.table, (ColumnSortEvent.ListHandler)this.getColumnSortHandler(), (com.sap.sse.security.ui.client.i18n.StringMessages)stringMessages);
        if (allowActions) {
            this.table.addColumn((Column)boatActionColumn, stringMessages.actions());
        }
        this.table.ensureDebugId("BoatsTable");
    }

    public Iterable<BoatDTO> getAllBoats() {
        return this.filterField.getAll();
    }

    public LabeledAbstractFilterablePanel<BoatDTO> getFilterField() {
        return this.filterField;
    }

    public void filterBoats(Iterable<BoatDTO> boats) {
        this.filterField.updateAll(boats);
    }

    public void refreshBoatList(boolean loadOnlyStandaloneBoats, Callback<Iterable<BoatDTO>, Throwable> callback) {
        if (loadOnlyStandaloneBoats) {
            this.sailingServiceWrite.getStandaloneBoats((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        } else if (this.boatsRefresher != null) {
            this.boatsRefresher.callFillAndReloadInitially(boats -> {
                this.filterBoats(boats);
                if (callback != null) {
                    callback.onSuccess((Object)boats);
                }
            });
        } else {
            this.sailingServiceWrite.getAllBoats((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    void openEditBoatDialog(BoatDTO originalBoat, String boatClassName) {
        BoatEditDialog dialog = new BoatEditDialog((StringMessages)this.getStringMessages(), originalBoat, boatClassName, (DataEntryDialog.DialogCallback)new /* Unavailable Anonymous Inner Class!! */);
        dialog.ensureDebugId("BoatEditDialog");
        dialog.show();
    }

    void openEditBoatDialog(BoatDTO originalBoat) {
        this.openEditBoatDialog(originalBoat, null);
    }

    public void allowUpdate(Iterable<BoatDTO> boats) {
        ArrayList serializableSingletonList = new ArrayList();
        Util.addAll(boats, serializableSingletonList);
        this.sailingServiceWrite.allowBoatResetToDefaults(serializableSingletonList, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void allowUpdate(BoatDTO boat) {
        this.allowUpdate(Collections.singleton(boat));
    }

    static /* synthetic */ FlushableCellTable access$0(BoatTableWrapper boatTableWrapper) {
        return boatTableWrapper.table;
    }

    static /* synthetic */ ErrorReporter access$1(BoatTableWrapper boatTableWrapper) {
        return boatTableWrapper.errorReporter;
    }

    static /* synthetic */ SailingServiceWriteAsync access$2(BoatTableWrapper boatTableWrapper) {
        return boatTableWrapper.sailingServiceWrite;
    }

    static /* synthetic */ Refresher access$3(BoatTableWrapper boatTableWrapper) {
        return boatTableWrapper.boatsRefresher;
    }

    static /* synthetic */ Refresher access$4(BoatTableWrapper boatTableWrapper) {
        return boatTableWrapper.competitorsRefresher;
    }

    static /* synthetic */ com.sap.sse.gwt.client.StringMessages access$5(BoatTableWrapper boatTableWrapper) {
        return boatTableWrapper.getStringMessages();
    }
}

