/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.adminconsole;

import com.google.gwt.user.client.ui.Focusable;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.SuggestBox;
import com.google.gwt.user.client.ui.SuggestOracle;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.domain.common.dto.BoatClassDTO;
import com.sap.sailing.domain.common.dto.BoatDTO;
import com.sap.sailing.gwt.common.client.suggestion.BoatClassMasterdataSuggestOracle;
import com.sap.sailing.gwt.ui.adminconsole.BoatEditDialog;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sse.common.Distance;
import com.sap.sse.gwt.client.ColorTextBox;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;

public class BoatEditDialog
extends DataEntryDialog<BoatDTO> {
    private final BoatDTO boatToEdit;
    private final TextBox nameTextBox;
    private final SuggestBox boatClassNameBox;
    private final ColorTextBox displayColorTextBox;
    private final TextBox sailIdTextBox;
    private final StringMessages stringMessages;

    public BoatEditDialog(StringMessages stringMessages, BoatDTO boatToEdit, DataEntryDialog.DialogCallback<BoatDTO> callback) {
        this(stringMessages, boatToEdit, null, callback);
    }

    public BoatEditDialog(StringMessages stringMessages, BoatDTO boatToEdit, String boatClassName, DataEntryDialog.DialogCallback<BoatDTO> callback) {
        super(String.valueOf(stringMessages.edit()) + " " + stringMessages.boat(), null, stringMessages.ok(), stringMessages.cancel(), (DataEntryDialog.Validator)new /* Unavailable Anonymous Inner Class!! */, true, callback);
        this.ensureDebugId("BoatEditDialog");
        this.stringMessages = stringMessages;
        this.boatToEdit = boatToEdit;
        this.boatClassNameBox = this.createSuggestBox((SuggestOracle)new BoatClassMasterdataSuggestOracle());
        this.boatClassNameBox.ensureDebugId("BoatClassNameSuggestBox");
        if (boatToEdit.getBoatClass() != null) {
            this.boatClassNameBox.setValue(boatToEdit.getBoatClass().getName());
            this.boatClassNameBox.setEnabled(false);
        } else {
            this.boatClassNameBox.setValue(boatClassName);
        }
        this.nameTextBox = this.createTextBox(boatToEdit.getName());
        this.nameTextBox.ensureDebugId("NameTextBox");
        this.displayColorTextBox = this.createColorTextBox(boatToEdit.getColor());
        this.sailIdTextBox = this.createTextBox(boatToEdit.getSailId());
        this.sailIdTextBox.ensureDebugId("SailIdTextBox");
    }

    protected Focusable getInitialFocusWidget() {
        return this.nameTextBox;
    }

    protected BoatDTO getResult() {
        Object color = this.displayColorTextBox.isValid() ? this.displayColorTextBox.getColor() : new InvalidColor(this, (Exception)new IllegalArgumentException(this.displayColorTextBox.getValue()));
        BoatClassDTO boatClass = new BoatClassDTO(this.boatClassNameBox.getValue(), (Distance)Distance.NULL, (Distance)Distance.NULL);
        BoatDTO boat = new BoatDTO(this.boatToEdit.getIdAsString(), this.nameTextBox.getValue(), boatClass, this.sailIdTextBox.getValue(), color);
        return boat;
    }

    protected Widget getAdditionalWidget() {
        Grid result = new Grid(4, 2);
        result.setWidget(0, 0, (Widget)new Label(this.stringMessages.name()));
        result.setWidget(0, 1, (Widget)this.nameTextBox);
        result.setWidget(1, 0, (Widget)new Label(this.stringMessages.sailNumber()));
        result.setWidget(1, 1, (Widget)this.sailIdTextBox);
        result.setWidget(2, 0, (Widget)new Label(this.stringMessages.color()));
        result.setWidget(2, 1, (Widget)this.displayColorTextBox);
        result.setWidget(3, 0, (Widget)new Label(this.stringMessages.boatClass()));
        result.setWidget(3, 1, (Widget)this.boatClassNameBox);
        return result;
    }

    static /* synthetic */ StringMessages access$1(BoatEditDialog boatEditDialog) {
        return boatEditDialog.stringMessages;
    }
}

