/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.adminconsole;

import com.google.gwt.dom.client.NodeList;
import com.google.gwt.dom.client.OptionElement;
import com.google.gwt.dom.client.SelectElement;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.CaptionPanel;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.domain.common.CompetitorRegistrationType;
import com.sap.sailing.domain.common.RankingMetrics;
import com.sap.sailing.domain.common.ScoringSchemeType;
import com.sap.sailing.domain.common.dto.CourseAreaDTO;
import com.sap.sailing.domain.common.i18n.CommonStringMessages;
import com.sap.sailing.gwt.ui.adminconsole.CourseAreaSelection;
import com.sap.sailing.gwt.ui.adminconsole.RegistrationLinkWithQRCode;
import com.sap.sailing.gwt.ui.client.DataEntryDialogWithDateTimeBox;
import com.sap.sailing.gwt.ui.client.SailingServiceAsync;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.common.client.RandomString;
import com.sap.sailing.gwt.ui.leaderboard.RankingMetricTypeFormatter;
import com.sap.sailing.gwt.ui.leaderboard.ScoringSchemeTypeFormatter;
import com.sap.sailing.gwt.ui.shared.EventDTO;
import com.sap.sailing.gwt.ui.shared.RegattaDTO;
import com.sap.sailing.gwt.ui.shared.SeriesDTO;
import com.sap.sse.common.Util;
import com.sap.sse.gwt.client.DateAndTimeFormatterUtil;
import com.sap.sse.gwt.client.controls.datetime.DateAndTimeInput;
import com.sap.sse.gwt.client.controls.datetime.DateTimeInput;
import com.sap.sse.gwt.client.controls.listedit.ListEditorComposite;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;
import com.sap.sse.gwt.client.dialog.DoubleBox;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.dto.SecuredDTO;
import com.sap.sse.security.ui.client.UserService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;

public abstract class AbstractRegattaWithSeriesAndFleetsDialog<T>
extends DataEntryDialogWithDateTimeBox<T> {
    protected final SailingServiceAsync sailingService;
    protected StringMessages stringMessages;
    private final RegattaDTO regatta;
    protected final DateAndTimeInput startDateBox;
    protected final DateAndTimeInput endDateBox;
    protected final ListBox scoringSchemeListBox;
    protected final CourseAreaSelection courseAreaSelection;
    protected final ListBox sailingEventsListBox;
    protected final CheckBox useStartTimeInferenceCheckBox;
    protected final CheckBox controlTrackingFromStartAndFinishTimesCheckBox;
    protected final CheckBox autoRestartTrackingUponCompetitorSetChangeCheckBox;
    protected final DoubleBox buoyZoneRadiusInHullLengthsDoubleBox;
    protected final ListEditorComposite<SeriesDTO> seriesEditor;
    private final ListBox rankingMetricListBox;
    protected final ListBox competitorRegistrationTypeListBox;
    protected final Iterable<EventDTO> existingEvents;
    private EventDTO defaultEvent;
    private RegistrationLinkWithQRCode registrationLinkWithQRCode;
    protected final CaptionPanel secretPanel;
    private final UserService userService;

    public AbstractRegattaWithSeriesAndFleetsDialog(SailingServiceAsync sailingService, UserService userService, RegattaDTO regatta, Iterable<SeriesDTO> series, Iterable<EventDTO> existingEvents, EventDTO correspondingEvent, String title, String okButton, StringMessages stringMessages, DataEntryDialog.Validator<T> validator, DataEntryDialog.DialogCallback<T> callback) {
        super(title, null, okButton, stringMessages.cancel(), validator, callback);
        this.sailingService = sailingService;
        this.userService = userService;
        this.stringMessages = stringMessages;
        this.regatta = regatta;
        this.defaultEvent = correspondingEvent;
        this.existingEvents = existingEvents;
        this.rankingMetricListBox = this.createListBox(false);
        RankingMetrics[] rankingMetricsArray = RankingMetrics.values();
        int n = rankingMetricsArray.length;
        int n2 = 0;
        while (n2 < n) {
            RankingMetrics rankingMetricType = rankingMetricsArray[n2];
            this.rankingMetricListBox.addItem(RankingMetricTypeFormatter.format((RankingMetrics)rankingMetricType, (StringMessages)stringMessages), rankingMetricType.name());
            SelectElement selectElement = (SelectElement)this.rankingMetricListBox.getElement().cast();
            NodeList options = selectElement.getOptions();
            ((OptionElement)options.getItem(options.getLength() - 1)).setTitle(RankingMetricTypeFormatter.getDescription((RankingMetrics)rankingMetricType, (StringMessages)stringMessages));
            ++n2;
        }
        this.startDateBox = this.createDateTimeBox(regatta.startDate, DateTimeInput.Accuracy.MINUTES);
        this.startDateBox.ensureDebugId("StartDateTimeBox");
        this.endDateBox = this.createDateTimeBox(regatta.endDate, DateTimeInput.Accuracy.MINUTES);
        this.endDateBox.ensureDebugId("EndDateTimeBox");
        this.scoringSchemeListBox = this.createListBox(false);
        this.scoringSchemeListBox.ensureDebugId("ScoringSchemeListBox");
        rankingMetricsArray = ScoringSchemeType.values();
        n = rankingMetricsArray.length;
        n2 = 0;
        while (n2 < n) {
            RankingMetrics scoringSchemeType = rankingMetricsArray[n2];
            this.scoringSchemeListBox.addItem(ScoringSchemeTypeFormatter.format((ScoringSchemeType)scoringSchemeType, (StringMessages)stringMessages), String.valueOf(scoringSchemeType.ordinal()));
            if (scoringSchemeType == regatta.scoringScheme) {
                this.scoringSchemeListBox.setSelectedIndex(this.scoringSchemeListBox.getItemCount() - 1);
            }
            ++n2;
        }
        this.sailingEventsListBox = this.createListBox(false);
        this.sailingEventsListBox.ensureDebugId("EventListBox");
        this.useStartTimeInferenceCheckBox = this.createCheckbox(stringMessages.useStartTimeInference());
        this.useStartTimeInferenceCheckBox.ensureDebugId("UseStartTimeInferenceCheckBox");
        this.useStartTimeInferenceCheckBox.setValue(Boolean.valueOf(regatta.useStartTimeInference));
        this.controlTrackingFromStartAndFinishTimesCheckBox = this.createCheckbox(stringMessages.controlTrackingFromStartAndFinishTimes());
        this.controlTrackingFromStartAndFinishTimesCheckBox.ensureDebugId("ControlTrackingFromStartAndFinishTimesCheckBox");
        this.controlTrackingFromStartAndFinishTimesCheckBox.setValue(Boolean.valueOf(regatta.controlTrackingFromStartAndFinishTimes));
        this.autoRestartTrackingUponCompetitorSetChangeCheckBox = this.createCheckbox(stringMessages.autoRestartTrackingUponCompetitorSetChange());
        this.autoRestartTrackingUponCompetitorSetChangeCheckBox.ensureDebugId("AutoRestartTrackingUponCompetitorSetChangeCheckBox");
        this.autoRestartTrackingUponCompetitorSetChangeCheckBox.setValue(Boolean.valueOf(regatta.autoRestartTrackingUponCompetitorSetChange));
        this.buoyZoneRadiusInHullLengthsDoubleBox = this.createDoubleBox(regatta.buoyZoneRadiusInHullLengths, 10);
        this.buoyZoneRadiusInHullLengthsDoubleBox.ensureDebugId("BuoyZoneRadiusInHullLengthsDoubleBox");
        this.courseAreaSelection = new CourseAreaSelection(stringMessages, (DataEntryDialog)this);
        this.courseAreaSelection.ensureDebugId("CourseAreaListBox");
        this.courseAreaSelection.setEnabled(false);
        this.seriesEditor = this.createSeriesEditor(series);
        this.setupEventAndCourseAreaListBoxes(stringMessages);
        this.competitorRegistrationTypeListBox = this.createListBox(false);
        this.competitorRegistrationTypeListBox.ensureDebugId("CompetitorRegistrationTypeListBox");
        EnumSet.allOf(CompetitorRegistrationType.class).forEach(t -> this.competitorRegistrationTypeListBox.addItem(t.getLabel((CommonStringMessages)stringMessages), t.name()));
        this.competitorRegistrationTypeListBox.setSelectedIndex(regatta.competitorRegistrationType.ordinal());
        this.registrationLinkWithQRCode = new RegistrationLinkWithQRCode();
        if (regatta.registrationLinkSecret == null) {
            String secret = RandomString.createRandomSecret((int)20);
            this.registrationLinkWithQRCode.setSecret(secret);
            regatta.registrationLinkSecret = secret;
        } else {
            this.registrationLinkWithQRCode.setSecret(regatta.registrationLinkSecret);
        }
        TextBox secretTextBox = this.createTextBox(regatta.registrationLinkSecret, 30);
        this.secretPanel = new CaptionPanel(stringMessages.registrationLinkSecret());
        this.createSecretPanel(stringMessages, this.secretPanel, secretTextBox);
    }

    private void createSecretPanel(StringMessages stringMessages, CaptionPanel secretPanel, TextBox secretTextBox) {
        VerticalPanel secretPanelContent = new VerticalPanel();
        secretPanel.add((Widget)secretPanelContent);
        Label secretExplainLabel = new Label(stringMessages.registrationLinkSecretExplain());
        secretPanelContent.add((Widget)secretExplainLabel);
        secretExplainLabel.setWordWrap(true);
        Label secretLabel = new Label(String.valueOf(stringMessages.registrationLinkSecret()) + ":");
        secretTextBox.ensureDebugId("SecretTextBox");
        secretTextBox.addChangeHandler(e -> this.validateSecret(stringMessages, secretTextBox));
        Button generateSecretButton = new Button(stringMessages.registrationLinkSecretGenerate(), (ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        generateSecretButton.ensureDebugId("GenerateSecretButton");
        Grid secretPanelFormGrid = new Grid(1, 3);
        secretPanelFormGrid.setWidget(0, 0, (Widget)secretLabel);
        secretPanelFormGrid.setWidget(0, 1, (Widget)secretTextBox);
        secretPanelFormGrid.setWidget(0, 2, (Widget)generateSecretButton);
        secretPanelContent.add((Widget)secretPanelFormGrid);
    }

    private void validateSecret(StringMessages stringMessages, TextBox secretTextBox) {
        if (secretTextBox.getText() == null || secretTextBox.getText().equals("")) {
            this.getStatusLabel().setText(stringMessages.invalidSecret());
            this.getStatusLabel().setStyleName("errorLabel");
            this.getOkButton().setEnabled(false);
        } else {
            this.getOkButton().setEnabled(true);
        }
        this.registrationLinkWithQRCode.setSecret(secretTextBox.getText());
    }

    protected void insertRankingMetricTabPanel(Grid formGrid) {
        int gridRow = formGrid.insertRow(formGrid.getRowCount());
        formGrid.setWidget(gridRow, 0, (Widget)new Label(this.stringMessages.rankingMetric()));
        formGrid.setWidget(gridRow, 1, (Widget)this.rankingMetricListBox);
    }

    protected void setRankingMetrics(RegattaDTO dto) {
        dto.rankingMetricType = RankingMetrics.valueOf((String)this.getRankingMetricListBox().getValue(this.getRankingMetricListBox().getSelectedIndex()));
    }

    protected ListBox getRankingMetricListBox() {
        return this.rankingMetricListBox;
    }

    protected abstract void setupAdditionalWidgetsOnPanel(VerticalPanel var1, Grid var2);

    protected abstract ListEditorComposite<SeriesDTO> createSeriesEditor(Iterable<SeriesDTO> var1);

    protected ListEditorComposite<SeriesDTO> getSeriesEditor() {
        return this.seriesEditor;
    }

    protected Widget getAdditionalWidget() {
        VerticalPanel panel = new VerticalPanel();
        Widget additionalWidget = super.getAdditionalWidget();
        if (additionalWidget != null) {
            panel.add(additionalWidget);
        }
        Grid formGrid = new Grid(12, 2);
        panel.add((Widget)formGrid);
        formGrid.setWidget(0, 0, (Widget)new Label(String.valueOf(this.stringMessages.timeZone()) + ":"));
        formGrid.setWidget(0, 1, (Widget)new Label(DateAndTimeFormatterUtil.getClientTimeZoneAsGMTString()));
        formGrid.setWidget(1, 0, (Widget)new Label(String.valueOf(this.stringMessages.startDate()) + ":"));
        formGrid.setWidget(1, 1, (Widget)this.startDateBox);
        formGrid.setWidget(2, 0, (Widget)new Label(String.valueOf(this.stringMessages.endDate()) + ":"));
        formGrid.setWidget(2, 1, (Widget)this.endDateBox);
        formGrid.setWidget(3, 0, (Widget)new Label(String.valueOf(this.stringMessages.scoringSystem()) + ":"));
        formGrid.setWidget(3, 1, (Widget)this.scoringSchemeListBox);
        formGrid.setWidget(4, 0, (Widget)new Label(String.valueOf(this.stringMessages.event()) + ":"));
        formGrid.setWidget(4, 1, (Widget)this.sailingEventsListBox);
        formGrid.setWidget(5, 0, (Widget)new Label(String.valueOf(this.stringMessages.courseArea()) + ":"));
        formGrid.setWidget(5, 1, (Widget)this.courseAreaSelection);
        formGrid.setWidget(6, 0, (Widget)new Label(String.valueOf(this.stringMessages.useStartTimeInference()) + ":"));
        formGrid.setWidget(6, 1, (Widget)this.useStartTimeInferenceCheckBox);
        formGrid.setWidget(7, 0, (Widget)new Label(String.valueOf(this.stringMessages.controlTrackingFromStartAndFinishTimes()) + ":"));
        formGrid.setWidget(7, 1, (Widget)this.controlTrackingFromStartAndFinishTimesCheckBox);
        formGrid.setWidget(8, 0, (Widget)new Label(String.valueOf(this.stringMessages.autoRestartTrackingUponCompetitorSetChange()) + ":"));
        formGrid.setWidget(8, 1, (Widget)this.autoRestartTrackingUponCompetitorSetChangeCheckBox);
        formGrid.setWidget(9, 0, (Widget)new Label(String.valueOf(this.stringMessages.buoyZoneRadiusInHullLengths()) + ":"));
        formGrid.setWidget(9, 1, (Widget)this.buoyZoneRadiusInHullLengthsDoubleBox);
        formGrid.setWidget(10, 0, (Widget)new Label(String.valueOf(this.stringMessages.competitorRegistrationType()) + ":"));
        formGrid.setWidget(10, 1, (Widget)this.competitorRegistrationTypeListBox);
        panel.add((Widget)this.secretPanel);
        this.setupAdditionalWidgetsOnPanel(panel, formGrid);
        return panel;
    }

    protected void setCourseAreaInRegatta(RegattaDTO regatta) {
        regatta.courseAreas = new ArrayList();
        Util.addAll((Iterable)this.getSelectedCourseAreas(), (Collection)regatta.courseAreas);
    }

    public ScoringSchemeType getSelectedScoringSchemeType() {
        int index = this.scoringSchemeListBox.getSelectedIndex();
        if (index >= 0) {
            return ScoringSchemeType.values()[Integer.valueOf(this.scoringSchemeListBox.getValue(index))];
        }
        return null;
    }

    private boolean isAnyOfTheCourseAreasInEvent(EventDTO event, Iterable<CourseAreaDTO> courseAreas) {
        boolean result = event.getVenue() == null ? false : Util.containsAny((Iterable)event.getVenue().getCourseAreas(), courseAreas);
        return result;
    }

    private void setupEventAndCourseAreaListBoxes(StringMessages stringMessages) {
        this.sailingEventsListBox.addItem(stringMessages.selectSailingEvent(), stringMessages.selectSailingEvent());
        Iterable eventsSortedByName = Util.stream((Iterable)this.existingEvents).filter(event -> this.userService.hasPermission((SecuredDTO)event, (HasPermissions.Action)HasPermissions.DefaultActions.UPDATE)).sorted(Util.naturalNamedComparator((boolean)true))::iterator;
        for (EventDTO event2 : eventsSortedByName) {
            this.sailingEventsListBox.addItem(event2.getName(), event2.getId().toString());
            if (this.defaultEvent != null) {
                if (!this.defaultEvent.getId().equals(event2.getId())) continue;
                this.sailingEventsListBox.setSelectedIndex(this.sailingEventsListBox.getItemCount() - 1);
                this.fillCourseAreaListBox(event2);
                if (event2.getVenue().getCourseAreas().size() != 1) continue;
                this.courseAreaSelection.setSelected((CourseAreaDTO)event2.getVenue().getCourseAreas().iterator().next(), true);
                continue;
            }
            if (!this.isAnyOfTheCourseAreasInEvent(event2, (Iterable)this.regatta.courseAreas)) continue;
            this.sailingEventsListBox.setSelectedIndex(this.sailingEventsListBox.getItemCount() - 1);
            this.fillCourseAreaListBox(event2);
        }
        this.sailingEventsListBox.addChangeHandler((ChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected void onEventSelectionChanged() {
        this.setCourseAreaSelection();
    }

    protected void setCourseAreaSelection() {
        EventDTO selectedEvent = this.getSelectedEvent();
        this.courseAreaSelection.removeAll();
        this.courseAreaSelection.setEnabled(false);
        if (selectedEvent != null) {
            this.fillCourseAreaListBox(selectedEvent);
        }
    }

    protected void fillCourseAreaListBox(EventDTO selectedEvent) {
        for (CourseAreaDTO courseAreaInEvent : selectedEvent.getVenue().getCourseAreas()) {
            this.courseAreaSelection.addCourseArea(courseAreaInEvent);
        }
        for (CourseAreaDTO courseAreaForRegatta : this.regatta.courseAreas) {
            this.courseAreaSelection.setSelected(courseAreaForRegatta, true);
        }
        this.courseAreaSelection.setEnabled(true);
    }

    public EventDTO getSelectedEvent() {
        EventDTO result = null;
        int selIndex = this.sailingEventsListBox.getSelectedIndex();
        if (selIndex > 0) {
            String itemValue = this.sailingEventsListBox.getValue(selIndex);
            for (EventDTO eventDTO : this.existingEvents) {
                if (!eventDTO.getId().toString().equals(itemValue)) continue;
                result = eventDTO;
                break;
            }
        }
        return result;
    }

    public Iterable<CourseAreaDTO> getSelectedCourseAreas() {
        return this.courseAreaSelection.getSelectedCourseAreas();
    }

    public RegattaDTO getRegattaDTO(String name) {
        RegattaDTO result = new RegattaDTO(name, this.getSelectedScoringSchemeType());
        result.startDate = this.startDateBox.getValue();
        result.endDate = this.endDateBox.getValue();
        result.useStartTimeInference = this.useStartTimeInferenceCheckBox.getValue();
        result.controlTrackingFromStartAndFinishTimes = this.controlTrackingFromStartAndFinishTimesCheckBox.getValue();
        result.autoRestartTrackingUponCompetitorSetChange = this.autoRestartTrackingUponCompetitorSetChangeCheckBox.getValue();
        result.buoyZoneRadiusInHullLengths = (Double)this.buoyZoneRadiusInHullLengthsDoubleBox.getValue();
        this.setCourseAreaInRegatta(result);
        result.series = this.getSeriesEditor().getValue();
        result.competitorRegistrationType = CompetitorRegistrationType.valueOf((String)this.competitorRegistrationTypeListBox.getSelectedValue());
        result.registrationLinkSecret = this.registrationLinkWithQRCode.getSecret();
        return result;
    }

    static /* synthetic */ RegistrationLinkWithQRCode access$0(AbstractRegattaWithSeriesAndFleetsDialog abstractRegattaWithSeriesAndFleetsDialog) {
        return abstractRegattaWithSeriesAndFleetsDialog.registrationLinkWithQRCode;
    }

    static /* synthetic */ void access$1(AbstractRegattaWithSeriesAndFleetsDialog abstractRegattaWithSeriesAndFleetsDialog, StringMessages stringMessages, TextBox textBox) {
        abstractRegattaWithSeriesAndFleetsDialog.validateSecret(stringMessages, textBox);
    }
}

