/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.adminconsole;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.event.dom.client.HasAllKeyHandlers;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONParser;
import com.google.gwt.json.client.JSONString;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.CaptionPanel;
import com.google.gwt.user.client.ui.FileUpload;
import com.google.gwt.user.client.ui.FormPanel;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.Hidden;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.SelectionChangeEvent;
import com.sap.sailing.domain.common.dto.BoatDTO;
import com.sap.sailing.domain.common.orc.ORCCertificate;
import com.sap.sailing.domain.common.security.SecuredDomainType;
import com.sap.sailing.gwt.common.client.help.HelpButton;
import com.sap.sailing.gwt.common.client.help.HelpButtonResources;
import com.sap.sailing.gwt.ui.adminconsole.AbstractBoatCertificatesPanel;
import com.sap.sailing.gwt.ui.adminconsole.BoatWithCertificateTableWrapper;
import com.sap.sailing.gwt.ui.adminconsole.CertificatesTableWrapper;
import com.sap.sailing.gwt.ui.client.SailingServiceAsync;
import com.sap.sailing.gwt.ui.client.SailingServiceWriteAsync;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sse.common.Util;
import com.sap.sse.common.fileupload.FileUploadUtil;
import com.sap.sse.gwt.client.ErrorReporter;
import com.sap.sse.gwt.client.IconResources;
import com.sap.sse.gwt.client.Notification;
import com.sap.sse.gwt.client.celltable.RefreshableMultiSelectionModel;
import com.sap.sse.gwt.client.celltable.RefreshableSingleSelectionModel;
import com.sap.sse.gwt.client.controls.IntegerBox;
import com.sap.sse.gwt.client.controls.busyindicator.BusyIndicator;
import com.sap.sse.gwt.client.controls.busyindicator.SimpleBusyIndicator;
import com.sap.sse.gwt.client.controls.listedit.StringListEditorComposite;
import com.sap.sse.gwt.client.dialog.DialogUtils;
import com.sap.sse.security.shared.dto.SecuredDTO;
import com.sap.sse.security.ui.client.UserService;
import com.sap.sse.security.ui.client.component.AccessControlledButtonPanel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;

public abstract class AbstractBoatCertificatesPanel
extends SimplePanel {
    private final BoatWithCertificateTableWrapper<RefreshableMultiSelectionModel<BoatDTO>> boatTable;
    private final Map<String, BoatDTO> boatsByIdAsString;
    private final CertificatesTableWrapper<RefreshableSingleSelectionModel<ORCCertificate>> certificateTable;
    private final BusyIndicator busyIndicator;
    private final SailingServiceWriteAsync sailingServiceWrite;
    private final ErrorReporter errorReporter;
    private final StringListEditorComposite urls;
    private final FileUpload fileUpload;
    private final List<Hidden> hiddenCertificateUrlsFields;
    private final Map<BoatDTO, ORCCertificate> certificateAssignments;
    private final FormPanel form;
    private final VerticalPanel mainPanel;
    private final StringMessages stringMessages;
    private final SelectionChangeEvent.Handler certificateTableSelectionHandler;
    private HandlerRegistration certificateTableSelectionHandlerRegistration;
    private final Supplier<Boolean> contextUpdatePermissionCheck;
    private final String errorContext;

    public AbstractBoatCertificatesPanel(SailingServiceWriteAsync sailingServiceWrite, UserService userService, SecuredDTO objectToCheckUpdatePermissionFor, StringMessages stringMessages, ErrorReporter errorReporter, Supplier<Boolean> contextUpdatePermissionCheck, String errorContext) {
        this.sailingServiceWrite = sailingServiceWrite;
        this.errorReporter = errorReporter;
        this.stringMessages = stringMessages;
        this.certificateTableSelectionHandler = this.createCertificateTableSelectionHandler();
        this.errorContext = errorContext;
        this.boatsByIdAsString = new HashMap();
        this.fileUpload = new FileUpload();
        this.fileUpload.getElement().setAttribute("multiple", "multiple");
        this.fileUpload.setName("certificates");
        this.certificateAssignments = new HashMap();
        this.urls = new StringListEditorComposite(Collections.emptySet(), (com.sap.sse.gwt.client.StringMessages)stringMessages, stringMessages.courseAreas(), IconResources.INSTANCE.removeIcon(), Collections.emptySet(), stringMessages.enterURLsForCertificateDownload());
        this.hiddenCertificateUrlsFields = new ArrayList();
        this.boatTable = new BoatWithCertificateTableWrapper(sailingServiceWrite, userService, stringMessages, errorReporter, true, true, 100, true, boat -> this.unlink(boat), objectToCheckUpdatePermissionFor, boat -> this.certificateAssignments.containsKey(boat));
        this.certificateTable = new CertificatesTableWrapper(sailingServiceWrite, userService, stringMessages, errorReporter, false, true, 100);
        this.busyIndicator = new SimpleBusyIndicator(false, 0.8f);
        this.form = new FormPanel();
        this.form.setAction(Window.Location.createUrlBuilder().setPath("/sailingserver/orc-certificate-import").buildString());
        this.form.setMethod("post");
        this.form.setEncoding("multipart/form-data");
        this.form.addSubmitHandler(e -> this.busyIndicator.setBusy(true));
        this.form.addSubmitCompleteHandler(e -> this.formSubmitComplete(e));
        this.mainPanel = new VerticalPanel();
        this.form.setWidget((Widget)this.mainPanel);
        this.setWidget((Widget)this.form);
        this.mainPanel.add((Widget)this.busyIndicator);
        Grid tablesPanel = new Grid(1, 2);
        tablesPanel.setWidth("100%");
        AccessControlledButtonPanel topButtonPanel = new AccessControlledButtonPanel(userService, SecuredDomainType.COMPETITOR);
        this.mainPanel.add((Widget)topButtonPanel);
        HorizontalPanel urlsPanel = new HorizontalPanel();
        this.mainPanel.add((Widget)urlsPanel);
        urlsPanel.add((Widget)new Label(stringMessages.certificateURLs()));
        urlsPanel.add((Widget)this.urls);
        this.mainPanel.add((Widget)this.fileUpload);
        this.mainPanel.add(this.createSearchPanel(stringMessages));
        this.mainPanel.add((Widget)tablesPanel);
        Button refreshButton = topButtonPanel.addUnsecuredAction(stringMessages.refresh(), () -> this.refresh());
        refreshButton.ensureDebugId("RefreshButton");
        this.contextUpdatePermissionCheck = contextUpdatePermissionCheck;
        Button importCertificatesButton = topButtonPanel.addAction(stringMessages.importCertificates(), contextUpdatePermissionCheck, () -> this.importCertificates());
        importCertificatesButton.ensureDebugId("ImportCertificatesButton");
        Button suggestCertificatesButton = topButtonPanel.addAction(stringMessages.suggestCertificatesForSelectedBoats(), contextUpdatePermissionCheck, () -> this.suggestCertificates());
        suggestCertificatesButton.ensureDebugId("SuggestCertificatesButton");
        topButtonPanel.addUnsecuredWidget((Widget)new HelpButton(HelpButtonResources.INSTANCE, stringMessages.orcExplanation(), "https://wiki.sapsailing.com/wiki/howto/setup-orc-regatta#setting-up-an-orc-regatta-with-performance-curve-scoring-pcs"));
        CaptionPanel boatCaptionPanel = new CaptionPanel(stringMessages.boats());
        boatCaptionPanel.add((IsWidget)this.boatTable);
        tablesPanel.setWidget(0, 0, (Widget)boatCaptionPanel);
        CaptionPanel certificatesCaptionPanel = new CaptionPanel(stringMessages.certificates());
        certificatesCaptionPanel.add((IsWidget)this.certificateTable);
        this.wireSelectionModels();
        tablesPanel.setWidget(0, 1, (Widget)certificatesCaptionPanel);
    }

    private Widget createSearchPanel(StringMessages stringMessages) {
        Button searchButton = new Button(stringMessages.search());
        CaptionPanel searchPanel = new CaptionPanel(stringMessages.search());
        VerticalPanel vp = new VerticalPanel();
        searchPanel.add((Widget)vp);
        vp.add((Widget)new Label(stringMessages.searchForCertificatesExplanation()));
        Grid searchGrid = new Grid(2, 7);
        vp.add((Widget)searchGrid);
        searchGrid.setWidget(0, 0, (Widget)searchButton);
        searchGrid.setWidget(0, 1, (Widget)new Label(stringMessages.issuingCountry()));
        ListBox issuingCountryListBox = new ListBox();
        DialogUtils.makeCountrySelection((ListBox)issuingCountryListBox, null);
        DialogUtils.linkEnterToButton((Button)searchButton, (HasAllKeyHandlers[])new HasAllKeyHandlers[]{issuingCountryListBox});
        searchGrid.setWidget(0, 2, (Widget)issuingCountryListBox);
        searchGrid.setWidget(0, 3, (Widget)new Label(stringMessages.yearOfIssuance()));
        IntegerBox yearOfIssuanceBox = new IntegerBox();
        DialogUtils.linkEnterToButton((Button)searchButton, (HasAllKeyHandlers[])new HasAllKeyHandlers[]{yearOfIssuanceBox});
        searchGrid.setWidget(0, 4, (Widget)yearOfIssuanceBox);
        searchGrid.setWidget(0, 5, (Widget)new Label(stringMessages.referenceNumber()));
        TextBox referenceNumberTextBox = new TextBox();
        DialogUtils.linkEnterToButton((Button)searchButton, (HasAllKeyHandlers[])new HasAllKeyHandlers[]{referenceNumberTextBox});
        searchGrid.setWidget(0, 6, (Widget)referenceNumberTextBox);
        searchGrid.setWidget(1, 1, (Widget)new Label(stringMessages.yachtName()));
        TextBox yachtNameTextBox = new TextBox();
        DialogUtils.linkEnterToButton((Button)searchButton, (HasAllKeyHandlers[])new HasAllKeyHandlers[]{yachtNameTextBox});
        searchGrid.setWidget(1, 2, (Widget)yachtNameTextBox);
        searchGrid.setWidget(1, 3, (Widget)new Label(stringMessages.sailNumber()));
        TextBox sailNumberTextBox = new TextBox();
        DialogUtils.linkEnterToButton((Button)searchButton, (HasAllKeyHandlers[])new HasAllKeyHandlers[]{sailNumberTextBox});
        searchGrid.setWidget(1, 4, (Widget)sailNumberTextBox);
        searchGrid.setWidget(1, 5, (Widget)new Label(stringMessages.boatClass()));
        TextBox boatClassNameTextBox = new TextBox();
        DialogUtils.linkEnterToButton((Button)searchButton, (HasAllKeyHandlers[])new HasAllKeyHandlers[]{boatClassNameTextBox});
        searchGrid.setWidget(1, 6, (Widget)boatClassNameTextBox);
        searchButton.addClickHandler(e -> {
            this.busyIndicator.setBusy(true);
            this.sailingServiceWrite.searchORCBoatCertificates(DialogUtils.getSelectedCountry((ListBox)issuingCountryListBox), (Integer)yearOfIssuanceBox.getValue(), referenceNumberTextBox.getValue().trim().isEmpty() ? null : referenceNumberTextBox.getValue(), yachtNameTextBox.getValue() == null ? null : yachtNameTextBox.getValue(), sailNumberTextBox.getValue() == null ? null : sailNumberTextBox.getValue(), boatClassNameTextBox.getValue() == null ? null : boatClassNameTextBox.getValue(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        });
        return searchPanel;
    }

    private void formSubmitComplete(FormPanel.SubmitCompleteEvent e) {
        try {
            JSONObject json = (JSONObject)JSONParser.parseStrict((String)FileUploadUtil.getApplicationJsonContentFromHtml((String)e.getResults()));
            if (json.get("certificates") != null) {
                this.sailingServiceWrite.getORCCertificates(json.toString(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
            } else {
                Notification.notify((String)this.stringMessages.errorObtainingCertificates(((JSONString)json.get("message")).stringValue()), (Notification.NotificationType)Notification.NotificationType.ERROR);
                this.busyIndicator.setBusy(false);
            }
        }
        catch (Exception ex) {
            Notification.notify((String)this.stringMessages.errorAssigningCertificatesToBoats(ex.getMessage()), (Notification.NotificationType)Notification.NotificationType.ERROR);
            this.busyIndicator.setBusy(false);
        }
    }

    public void unlink(BoatDTO boat) {
        ORCCertificate associatedCertificate = (ORCCertificate)this.certificateAssignments.remove(boat);
        if (associatedCertificate != null && ((RefreshableSingleSelectionModel)this.certificateTable.getSelectionModel()).isSelected((Object)associatedCertificate)) {
            this.temporarilyDeregisterCertificateTableSelectionHandler();
            ((RefreshableSingleSelectionModel)this.certificateTable.getSelectionModel()).setSelected((Object)associatedCertificate, false);
        }
        this.boatTable.refresh();
    }

    private SelectionChangeEvent.Handler createCertificateTableSelectionHandler() {
        return e -> {
            Set selectedBoats = ((RefreshableMultiSelectionModel)this.boatTable.getSelectionModel()).getSelectedSet();
            ORCCertificate selectedCertificate = (ORCCertificate)((RefreshableSingleSelectionModel)this.certificateTable.getSelectionModel()).getSelectedObject();
            if (selectedBoats != null && !selectedBoats.isEmpty()) {
                for (BoatDTO boat : selectedBoats) {
                    ORCCertificate assignedCertificate = (ORCCertificate)this.certificateAssignments.get(boat);
                    if (((Boolean)this.contextUpdatePermissionCheck.get()).booleanValue()) {
                        if (selectedCertificate != null) {
                            if (assignedCertificate == null || assignedCertificate == selectedCertificate || Window.confirm((String)this.stringMessages.reallyChangeAssignedCertificateForBoat(boat.toString()))) {
                                this.assign(boat, selectedCertificate);
                                continue;
                            }
                            if (assignedCertificate == null) continue;
                            this.temporarilyDeregisterCertificateTableSelectionHandler();
                            ((RefreshableSingleSelectionModel)this.certificateTable.getSelectionModel()).setSelected((Object)assignedCertificate, true);
                            continue;
                        }
                        if (assignedCertificate == null) continue;
                        this.unlink(boat);
                        continue;
                    }
                    this.temporarilyDeregisterCertificateTableSelectionHandler();
                    if (assignedCertificate == null) {
                        if (selectedCertificate == null) continue;
                        ((RefreshableSingleSelectionModel)this.certificateTable.getSelectionModel()).setSelected((Object)selectedCertificate, false);
                        continue;
                    }
                    ((RefreshableSingleSelectionModel)this.certificateTable.getSelectionModel()).setSelected((Object)assignedCertificate, true);
                }
            }
        };
    }

    private void setCertificateSelectionWithoutEventHandling(ORCCertificate assignedCertificate) {
        this.temporarilyDeregisterCertificateTableSelectionHandler();
        ((RefreshableSingleSelectionModel)this.certificateTable.getSelectionModel()).setSelected((Object)assignedCertificate, true);
    }

    private void wireSelectionModels() {
        ((RefreshableMultiSelectionModel)this.boatTable.getSelectionModel()).addSelectionChangeHandler(e -> {
            ORCCertificate selectedCertificate = (ORCCertificate)((RefreshableSingleSelectionModel)this.certificateTable.getSelectionModel()).getSelectedObject();
            Set selectedBoats = ((RefreshableMultiSelectionModel)this.boatTable.getSelectionModel()).getSelectedSet();
            if (selectedBoats != null && selectedBoats.size() == 1) {
                BoatDTO selectedBoat = (BoatDTO)selectedBoats.iterator().next();
                ORCCertificate assignedCertificate = (ORCCertificate)this.certificateAssignments.get(selectedBoat);
                if (assignedCertificate == null) {
                    if (selectedCertificate != null) {
                        this.temporarilyDeregisterCertificateTableSelectionHandler();
                        ((RefreshableSingleSelectionModel)this.certificateTable.getSelectionModel()).setSelected((Object)selectedCertificate, false);
                    }
                } else {
                    this.setCertificateSelectionWithoutEventHandling(assignedCertificate);
                }
            } else {
                this.temporarilyDeregisterCertificateTableSelectionHandler();
                ((RefreshableSingleSelectionModel)this.certificateTable.getSelectionModel()).setSelected((Object)selectedCertificate, false);
            }
        });
        this.certificateTableSelectionHandlerRegistration = ((RefreshableSingleSelectionModel)this.certificateTable.getSelectionModel()).addSelectionChangeHandler(this.certificateTableSelectionHandler);
        this.urls.addValueChangeHandler(valueChangeEvent -> {
            Iterable certificateUrls = (Iterable)valueChangeEvent.getValue();
            this.updateHiddenCertificateUrlsField(certificateUrls);
        });
    }

    private void temporarilyDeregisterCertificateTableSelectionHandler() {
        if (this.certificateTableSelectionHandlerRegistration != null) {
            this.certificateTableSelectionHandlerRegistration.removeHandler();
            this.certificateTableSelectionHandlerRegistration = null;
            Scheduler.get().scheduleDeferred(() -> {
                HandlerRegistration handlerRegistration = this.certificateTableSelectionHandlerRegistration = ((RefreshableSingleSelectionModel)this.certificateTable.getSelectionModel()).addSelectionChangeHandler(this.certificateTableSelectionHandler);
            });
        }
    }

    private void assign(BoatDTO boat, ORCCertificate selectedCertificate) {
        this.certificateAssignments.put(boat, selectedCertificate);
        this.boatTable.getDataProvider().getList().set(this.boatTable.getDataProvider().getList().indexOf(boat), boat);
        this.boatTable.refresh();
    }

    private void updateHiddenCertificateUrlsField(Iterable<String> certificateUrls) {
        for (Hidden existingHiddenCertificateUrlField : this.hiddenCertificateUrlsFields) {
            this.mainPanel.remove((Widget)existingHiddenCertificateUrlField);
        }
        this.hiddenCertificateUrlsFields.clear();
        for (String certificateUrl : certificateUrls) {
            Hidden hiddenCertificateUrlField = new Hidden("certificate_url[]", certificateUrl);
            this.mainPanel.add((Widget)hiddenCertificateUrlField);
            this.hiddenCertificateUrlsFields.add(hiddenCertificateUrlField);
        }
    }

    private void importCertificates() {
        this.form.submit();
    }

    private void suggestCertificates() {
        Set selectedBoats = ((RefreshableMultiSelectionModel)this.boatTable.getSelectionModel()).getSelectedSet();
        if (selectedBoats != null && !selectedBoats.isEmpty()) {
            this.busyIndicator.setBusy(true);
            this.sailingServiceWrite.getSuggestedORCBoatCertificates(new ArrayList(selectedBoats), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    public void assignCertificates() {
        HashMap<String, ORCCertificate> certificatesByBoatIdAsString = new HashMap<String, ORCCertificate>();
        for (Map.Entry e : this.certificateAssignments.entrySet()) {
            certificatesByBoatIdAsString.put(((BoatDTO)e.getKey()).getIdAsString(), (ORCCertificate)e.getValue());
        }
        4 callback = new /* Unavailable Anonymous Inner Class!! */;
        this.assignCertificates(this.sailingServiceWrite, certificatesByBoatIdAsString, (AsyncCallback)callback);
    }

    protected abstract void assignCertificates(SailingServiceWriteAsync var1, Map<String, ORCCertificate> var2, AsyncCallback<Util.Triple<Integer, Integer, Integer>> var3);

    protected void refresh() {
        5 callbackForGetBoats = new /* Unavailable Anonymous Inner Class!! */;
        this.getBoats((SailingServiceAsync)this.sailingServiceWrite, (AsyncCallback)callbackForGetBoats);
    }

    protected abstract void getBoats(SailingServiceAsync var1, AsyncCallback<Collection<BoatDTO>> var2);

    protected abstract void getORCCertificateAssignemtnsByBoatIdAsString(SailingServiceAsync var1, AsyncCallback<Map<String, ORCCertificate>> var2);

    static /* synthetic */ BusyIndicator access$0(AbstractBoatCertificatesPanel abstractBoatCertificatesPanel) {
        return abstractBoatCertificatesPanel.busyIndicator;
    }

    static /* synthetic */ ErrorReporter access$1(AbstractBoatCertificatesPanel abstractBoatCertificatesPanel) {
        return abstractBoatCertificatesPanel.errorReporter;
    }

    static /* synthetic */ CertificatesTableWrapper access$2(AbstractBoatCertificatesPanel abstractBoatCertificatesPanel) {
        return abstractBoatCertificatesPanel.certificateTable;
    }

    static /* synthetic */ StringMessages access$3(AbstractBoatCertificatesPanel abstractBoatCertificatesPanel) {
        return abstractBoatCertificatesPanel.stringMessages;
    }

    static /* synthetic */ void access$4(AbstractBoatCertificatesPanel abstractBoatCertificatesPanel) {
        abstractBoatCertificatesPanel.temporarilyDeregisterCertificateTableSelectionHandler();
    }

    static /* synthetic */ Map access$5(AbstractBoatCertificatesPanel abstractBoatCertificatesPanel) {
        return abstractBoatCertificatesPanel.certificateAssignments;
    }

    static /* synthetic */ String access$6(AbstractBoatCertificatesPanel abstractBoatCertificatesPanel) {
        return abstractBoatCertificatesPanel.errorContext;
    }

    static /* synthetic */ Map access$7(AbstractBoatCertificatesPanel abstractBoatCertificatesPanel) {
        return abstractBoatCertificatesPanel.boatsByIdAsString;
    }

    static /* synthetic */ BoatWithCertificateTableWrapper access$8(AbstractBoatCertificatesPanel abstractBoatCertificatesPanel) {
        return abstractBoatCertificatesPanel.boatTable;
    }

    static /* synthetic */ SailingServiceWriteAsync access$9(AbstractBoatCertificatesPanel abstractBoatCertificatesPanel) {
        return abstractBoatCertificatesPanel.sailingServiceWrite;
    }
}

