/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.settings.client.leaderboard;

import com.google.gwt.user.client.ui.FocusWidget;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.domain.common.DetailType;
import com.sap.sailing.gwt.settings.client.leaderboard.MultiCompetitorLeaderboardChartSettings;
import com.sap.sailing.gwt.ui.client.DetailTypeFormatter;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;
import com.sap.sse.gwt.client.shared.components.SettingsDialogComponent;
import java.util.ArrayList;
import java.util.List;

public class MultiCompetitorLeaderboardChartSettingsDialogComponent
implements SettingsDialogComponent<MultiCompetitorLeaderboardChartSettings> {
    private ListBox chartTypeSelectionListBox;
    private final DetailType initialDetailType;
    private final List<DetailType> availableDetailsTypes;
    private final boolean isOverall;

    public MultiCompetitorLeaderboardChartSettingsDialogComponent(MultiCompetitorLeaderboardChartSettings settings, boolean isOverall) {
        this.isOverall = isOverall;
        this.initialDetailType = settings.getDetailType();
        this.availableDetailsTypes = new ArrayList();
        this.availableDetailsTypes.add(MultiCompetitorLeaderboardChartSettings.getDefaultDetailType((boolean)isOverall));
        this.availableDetailsTypes.add(DetailType.REGATTA_NET_POINTS_SUM);
    }

    public DataEntryDialog.Validator<MultiCompetitorLeaderboardChartSettings> getValidator() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public Widget getAdditionalWidget(DataEntryDialog<?> dialog) {
        VerticalPanel mainPanel = new VerticalPanel();
        mainPanel.setSpacing(5);
        Label chartSelectionLabel = new Label(StringMessages.INSTANCE.chooseChart());
        mainPanel.add((Widget)chartSelectionLabel);
        this.chartTypeSelectionListBox = dialog.createListBox(false);
        this.chartTypeSelectionListBox.ensureDebugId("ChartTypeListBox");
        int i = 0;
        for (DetailType detailType : this.availableDetailsTypes) {
            this.chartTypeSelectionListBox.addItem(DetailTypeFormatter.format((DetailType)detailType), detailType.name());
            if (detailType == this.initialDetailType) {
                this.chartTypeSelectionListBox.setSelectedIndex(i);
            }
            ++i;
        }
        mainPanel.add((Widget)this.chartTypeSelectionListBox);
        return mainPanel;
    }

    public MultiCompetitorLeaderboardChartSettings getResult() {
        DetailType newDetailType = null;
        int selectedIndex = this.chartTypeSelectionListBox.getSelectedIndex();
        String selectedDetailType = this.chartTypeSelectionListBox.getValue(selectedIndex);
        for (DetailType detailType : this.availableDetailsTypes) {
            if (!detailType.name().equals(selectedDetailType)) continue;
            newDetailType = detailType;
            break;
        }
        return MultiCompetitorLeaderboardChartSettings.createWithDefaultDetailType((boolean)this.isOverall, newDetailType);
    }

    public FocusWidget getFocusWidget() {
        return this.chartTypeSelectionListBox;
    }
}

