/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.settings.client.leaderboard;

import com.google.gwt.dom.client.Style;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.FocusWidget;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.LongBox;
import com.google.gwt.user.client.ui.RadioButton;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.domain.common.DetailType;
import com.sap.sailing.domain.common.dto.AbstractLeaderboardDTO;
import com.sap.sailing.gwt.common.client.premium.SailingPremiumCheckBox;
import com.sap.sailing.gwt.settings.client.leaderboard.LeaderboardSettings;
import com.sap.sailing.gwt.ui.client.DebugIdHelper;
import com.sap.sailing.gwt.ui.client.DetailTypeFormatter;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.leaderboard.ManeuverCountRaceColumn;
import com.sap.sse.common.Util;
import com.sap.sse.gwt.client.controls.IntegerBox;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;
import com.sap.sse.gwt.client.shared.components.SettingsDialogComponent;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.dto.SecuredDTO;
import com.sap.sse.security.ui.client.premium.PaywallResolver;
import com.sap.sse.security.ui.client.premium.PremiumCheckBox;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class LeaderboardSettingsDialogComponent<T extends LeaderboardSettings>
implements SettingsDialogComponent<T> {
    public static final String CHECK_BOX_DEBUGID_CONSTANT = "CheckBox";
    protected final Map<DetailType, CheckBox> maneuverDetailCheckboxes;
    protected final Map<DetailType, CheckBox> legDetailCheckboxes;
    protected final Map<DetailType, CheckBox> raceDetailCheckboxes;
    protected final Map<DetailType, CheckBox> overallDetailCheckboxes;
    protected final StringMessages stringMessages;
    protected LongBox refreshIntervalInSecondsBox;
    protected final boolean canBoatInfoBeShownAsOverallDetail;
    protected RadioButton explicitRaceColumnSelectionRadioBtn;
    protected RadioButton lastNRacesColumnSelectionRadioBtn;
    protected IntegerBox numberOfLastRacesToShowBox;
    protected CheckBox showAddedScoresCheckBox;
    protected CheckBox showCompetitorShortNameColumnCheckBox;
    protected CheckBox showCompetitorFullNameColumnCheckBox;
    protected CheckBox showCompetitorBoatInfoColumnCheckBox;
    protected CheckBox isCompetitorNationalityColumnVisible;
    protected T initialSettings;
    protected Iterable<DetailType> availableDetailTypes;
    protected final PaywallResolver paywallResolver;
    protected final AbstractLeaderboardDTO leaderboardDTO;

    protected LeaderboardSettingsDialogComponent(T initialSettings, StringMessages stringMessages, Iterable<DetailType> availableDetailTypes, boolean canBoatInfoBeShownAsOverallDetail, PaywallResolver paywallResolver, AbstractLeaderboardDTO leaderboardDTO) {
        this.initialSettings = initialSettings;
        this.stringMessages = stringMessages;
        this.canBoatInfoBeShownAsOverallDetail = canBoatInfoBeShownAsOverallDetail;
        this.maneuverDetailCheckboxes = new LinkedHashMap();
        this.legDetailCheckboxes = new LinkedHashMap();
        this.raceDetailCheckboxes = new LinkedHashMap();
        this.overallDetailCheckboxes = new LinkedHashMap();
        this.availableDetailTypes = availableDetailTypes;
        this.paywallResolver = paywallResolver;
        this.leaderboardDTO = leaderboardDTO;
    }

    protected FlowPanel createManeuverDetailsPanel(DataEntryDialog<?> dialog) {
        FlowPanel meneuverPanel = new FlowPanel();
        meneuverPanel.ensureDebugId("ManeuverSettingsPanel");
        meneuverPanel.add((Widget)dialog.createHeadline(this.stringMessages.maneuverTypes(), true));
        meneuverPanel.addStyleName("SettingsDialogComponent");
        FlowPanel meneuverContent = new FlowPanel();
        meneuverContent.addStyleName("dialogInnerContent");
        Collection currentMeneuverDetailSelection = this.initialSettings.getManeuverDetailsToShow();
        for (DetailType detailType : Util.retainCopy((Iterable)ManeuverCountRaceColumn.getAvailableManeuverDetailColumnTypes(), (Iterable)this.availableDetailTypes)) {
            Object checkbox = detailType.getPremiumAction() != null ? this.createAndRegisterPremiumCheckbox(dialog, detailType, currentMeneuverDetailSelection.contains(detailType), this.maneuverDetailCheckboxes) : this.createAndRegisterCheckbox(dialog, detailType, currentMeneuverDetailSelection.contains(detailType), this.maneuverDetailCheckboxes);
            meneuverContent.add((Widget)checkbox);
        }
        meneuverPanel.add((Widget)meneuverContent);
        return meneuverPanel;
    }

    protected FlowPanel createTimingDetailsPanel(DataEntryDialog<?> dialog) {
        FlowPanel timingPanel = new FlowPanel();
        timingPanel.ensureDebugId("TimingSettingsPanel");
        this.refreshIntervalInSecondsBox = dialog.createLongBox((this.initialSettings.getDelayBetweenAutoAdvancesInMilliseconds() == null ? 3000L : this.initialSettings.getDelayBetweenAutoAdvancesInMilliseconds()) / 1000L, 4);
        this.refreshIntervalInSecondsBox.ensureDebugId("RefreshIntervalLongBox");
        timingPanel.add((Widget)dialog.createHeadline(this.stringMessages.timing(), true));
        timingPanel.addStyleName("SettingsDialogComponent");
        FlowPanel timingContent = new FlowPanel();
        timingPanel.add((Widget)timingContent);
        timingContent.addStyleName("dialogInnerContent");
        Label refreshIntervalLabel = new Label(String.valueOf(this.stringMessages.refreshInterval()) + ":");
        refreshIntervalLabel.getElement().getStyle().setPaddingRight(5.0, Style.Unit.PX);
        refreshIntervalLabel.getElement().getStyle().setPaddingLeft(5.0, Style.Unit.PX);
        refreshIntervalLabel.getElement().getStyle().setFloat(Style.Float.LEFT);
        timingContent.add((Widget)refreshIntervalLabel);
        timingContent.add((Widget)this.refreshIntervalInSecondsBox);
        return timingPanel;
    }

    protected FlowPanel createRaceDetailPanel(DataEntryDialog<?> dialog) {
        FlowPanel raceDetailDialog = new FlowPanel();
        raceDetailDialog.ensureDebugId("RaceDetailsSettingsPanel");
        raceDetailDialog.add((Widget)dialog.createHeadline(this.stringMessages.raceDetailsToShow(), true));
        raceDetailDialog.addStyleName("SettingsDialogComponent");
        int detailCountInCurrentFlowPanel = 0;
        Collection currentRaceDetailSelection = this.initialSettings.getRaceDetailsToShow();
        FlowPanel raceDetailDialogContent = null;
        for (DetailType type : Util.retainCopy((Iterable)DetailType.getAllRaceDetailTypes(), (Iterable)this.availableDetailTypes)) {
            if (type == DetailType.RACE_DISPLAY_BOATS && this.canBoatInfoBeShownAsOverallDetail) continue;
            if (detailCountInCurrentFlowPanel % 7 == 0) {
                raceDetailDialogContent = new FlowPanel();
                raceDetailDialogContent.addStyleName("dialogInnerContent");
                raceDetailDialog.add((Widget)raceDetailDialogContent);
            }
            Object checkbox = type.getPremiumAction() != null ? this.createAndRegisterPremiumCheckbox(dialog, type, currentRaceDetailSelection.contains(type), this.raceDetailCheckboxes) : this.createAndRegisterCheckbox(dialog, type, currentRaceDetailSelection.contains(type), this.raceDetailCheckboxes);
            raceDetailDialogContent.add((Widget)checkbox);
            ++detailCountInCurrentFlowPanel;
        }
        FlowPanel addedScoresFlowPanel = new FlowPanel();
        addedScoresFlowPanel.addStyleName("dialogInnerContent");
        this.showAddedScoresCheckBox = dialog.createCheckbox(this.stringMessages.showAddedScores());
        dialog.addTooltip((IsWidget)this.showAddedScoresCheckBox, this.stringMessages.showAddedScores());
        this.showAddedScoresCheckBox.setValue(Boolean.valueOf(this.initialSettings.isShowAddedScores()));
        addedScoresFlowPanel.add((Widget)this.showAddedScoresCheckBox);
        raceDetailDialog.add((Widget)addedScoresFlowPanel);
        return raceDetailDialog;
    }

    protected FlowPanel createRaceStartAnalysisPanel(DataEntryDialog<?> dialog) {
        FlowPanel raceStartAnalysisDialog = new FlowPanel();
        raceStartAnalysisDialog.ensureDebugId("RaceStartAnalysisDialog");
        raceStartAnalysisDialog.add((Widget)dialog.createHeadline(this.stringMessages.raceStartAnalysis(), true));
        raceStartAnalysisDialog.addStyleName("SettingsDialogComponent");
        int detailCountInCurrentFlowPanel = 0;
        Collection currentRaceDetailSelection = this.initialSettings.getRaceDetailsToShow();
        FlowPanel raceStartAnalysisDialogContent = null;
        for (DetailType type : Util.retainCopy((Iterable)DetailType.getRaceStartAnalysisColumnTypes(), (Iterable)this.availableDetailTypes)) {
            if (detailCountInCurrentFlowPanel % 6 == 0) {
                raceStartAnalysisDialogContent = new FlowPanel();
                raceStartAnalysisDialogContent.addStyleName("dialogInnerContent");
                raceStartAnalysisDialog.add((Widget)raceStartAnalysisDialogContent);
            }
            Object checkbox = type.getPremiumAction() != null ? this.createAndRegisterPremiumCheckbox(dialog, type, currentRaceDetailSelection.contains(type), this.raceDetailCheckboxes) : this.createAndRegisterCheckbox(dialog, type, currentRaceDetailSelection.contains(type), this.raceDetailCheckboxes);
            raceStartAnalysisDialogContent.add((Widget)checkbox);
            ++detailCountInCurrentFlowPanel;
        }
        return raceStartAnalysisDialog;
    }

    protected FlowPanel createOverallDetailPanel(DataEntryDialog<?> dialog) {
        FlowPanel overallDetailDialog = new FlowPanel();
        overallDetailDialog.ensureDebugId("OverallDetailsSettingsPanel");
        overallDetailDialog.add((Widget)dialog.createHeadline(this.stringMessages.overallDetailsToShow(), true));
        overallDetailDialog.addStyleName("SettingsDialogComponent overallDetailSettings");
        FlowPanel overallDetailDialogContent = new FlowPanel();
        overallDetailDialogContent.addStyleName("dialogInnerContent");
        Collection currentOverallDetailSelection = this.initialSettings.getOverallDetailsToShow();
        for (DetailType type : Util.retainCopy((Iterable)DetailType.getAvailableOverallDetailColumnTypes(), (Iterable)this.availableDetailTypes)) {
            Object checkbox = type.getPremiumAction() != null ? this.createAndRegisterPremiumCheckbox(dialog, type, currentOverallDetailSelection.contains(type), this.overallDetailCheckboxes) : this.createAndRegisterCheckbox(dialog, type, currentOverallDetailSelection.contains(type), this.overallDetailCheckboxes);
            overallDetailDialogContent.add((Widget)checkbox);
        }
        FlowPanel overallDetailDialogContentSecondLine = new FlowPanel();
        overallDetailDialogContentSecondLine.addStyleName("dialogInnerContent");
        this.showCompetitorShortNameColumnCheckBox = dialog.createCheckbox(this.stringMessages.showCompetitorShortNameColumn());
        this.showCompetitorShortNameColumnCheckBox.setTitle(this.stringMessages.showCompetitorShortNameColumnTooltip(this.stringMessages.showCompetitorNationalityColumn()));
        this.showCompetitorShortNameColumnCheckBox.setValue(Boolean.valueOf(this.initialSettings.isShowCompetitorShortNameColumn()));
        overallDetailDialogContentSecondLine.add((Widget)this.showCompetitorShortNameColumnCheckBox);
        this.showCompetitorFullNameColumnCheckBox = dialog.createCheckbox(this.stringMessages.showCompetitorFullNameColumn());
        this.showCompetitorFullNameColumnCheckBox.setValue(Boolean.valueOf(this.initialSettings.isShowCompetitorFullNameColumn()));
        overallDetailDialogContentSecondLine.add((Widget)this.showCompetitorFullNameColumnCheckBox);
        this.showCompetitorBoatInfoColumnCheckBox = dialog.createCheckbox(this.stringMessages.showCompetitorBoatColumn());
        this.showCompetitorBoatInfoColumnCheckBox.setValue(Boolean.valueOf(this.initialSettings.isShowCompetitorBoatInfoColumn()));
        overallDetailDialogContentSecondLine.add((Widget)this.showCompetitorBoatInfoColumnCheckBox);
        this.showCompetitorBoatInfoColumnCheckBox.setVisible(this.canBoatInfoBeShownAsOverallDetail);
        this.isCompetitorNationalityColumnVisible = dialog.createCheckbox(this.stringMessages.showCompetitorNationalityColumn());
        this.isCompetitorNationalityColumnVisible.setTitle(this.stringMessages.showCompetitorNationalityColumnTooltip());
        this.isCompetitorNationalityColumnVisible.setValue(Boolean.valueOf(this.initialSettings.isShowCompetitorNationality()));
        overallDetailDialogContentSecondLine.add((Widget)this.isCompetitorNationalityColumnVisible);
        overallDetailDialog.add((Widget)overallDetailDialogContent);
        overallDetailDialog.add((Widget)overallDetailDialogContentSecondLine);
        return overallDetailDialog;
    }

    protected FlowPanel createLegDetailsPanel(DataEntryDialog<?> dialog) {
        FlowPanel legDetailsToShow = new FlowPanel();
        legDetailsToShow.ensureDebugId("LegDetailsSettingsPanel");
        legDetailsToShow.add((Widget)dialog.createHeadline(this.stringMessages.legDetailsToShow(), true));
        legDetailsToShow.addStyleName("SettingsDialogComponent");
        FlowPanel legDetailsContent = null;
        Collection currentLegDetailSelection = this.initialSettings.getLegDetailsToShow();
        int detailCountInCurrentFlowPanel = 0;
        for (DetailType type : Util.retainCopy((Iterable)DetailType.getAllLegDetailColumnTypes(), (Iterable)this.availableDetailTypes)) {
            if (detailCountInCurrentFlowPanel % 7 == 0) {
                legDetailsContent = new FlowPanel();
                legDetailsContent.addStyleName("dialogInnerContent");
                legDetailsToShow.add((Widget)legDetailsContent);
            }
            Object checkbox = type.getPremiumAction() != null ? this.createAndRegisterPremiumCheckbox(dialog, type, currentLegDetailSelection.contains(type), this.legDetailCheckboxes) : this.createAndRegisterCheckbox(dialog, type, currentLegDetailSelection.contains(type), this.legDetailCheckboxes);
            legDetailsContent.add((Widget)checkbox);
            ++detailCountInCurrentFlowPanel;
        }
        return legDetailsToShow;
    }

    private CheckBox createAndRegisterCheckbox(DataEntryDialog<?> dialog, DetailType detailType, boolean selected, Map<DetailType, CheckBox> registry) {
        CheckBox checkbox = this.createCheckbox(dialog, detailType, selected);
        registry.put(detailType, checkbox);
        return checkbox;
    }

    private PremiumCheckBox createAndRegisterPremiumCheckbox(DataEntryDialog<?> dialog, DetailType detailType, boolean selected, Map<DetailType, CheckBox> registry) {
        PremiumCheckBox premiumCheckbox = this.createPremiumCheckbox(dialog, detailType, selected);
        registry.put(detailType, premiumCheckbox.getCheckBox());
        return premiumCheckbox;
    }

    private CheckBox createCheckbox(DataEntryDialog<?> dialog, DetailType detailType, boolean selected) {
        CheckBox checkbox = this.createCheckbox(dialog, DetailTypeFormatter.format((DetailType)detailType), selected, DetailTypeFormatter.getTooltip((DetailType)detailType));
        checkbox.ensureDebugId(String.valueOf(DebugIdHelper.createDebugId((Enum)detailType)) + CHECK_BOX_DEBUGID_CONSTANT);
        return checkbox;
    }

    private PremiumCheckBox createPremiumCheckbox(DataEntryDialog<?> dialog, DetailType detailType, boolean selected) {
        String tooltip = DetailTypeFormatter.getTooltip((DetailType)detailType);
        String premiumTooltip = this.stringMessages.premiumFeature();
        if (tooltip != null && !tooltip.isEmpty()) {
            premiumTooltip = String.valueOf(premiumTooltip) + ": " + tooltip;
        }
        PremiumCheckBox premiumCheckBox = this.createPremiumCheckbox(dialog, DetailTypeFormatter.format((DetailType)detailType), selected, premiumTooltip, detailType.getPremiumAction());
        premiumCheckBox.ensureDebugId(String.valueOf(DebugIdHelper.createDebugId((Enum)detailType)) + CHECK_BOX_DEBUGID_CONSTANT);
        return premiumCheckBox;
    }

    protected CheckBox createCheckbox(DataEntryDialog<?> dialog, String label, boolean selected, String tooltip) {
        CheckBox checkbox = dialog.createCheckbox(label);
        checkbox.ensureDebugId(String.valueOf(DebugIdHelper.createDebugId((String)label)) + CHECK_BOX_DEBUGID_CONSTANT);
        checkbox.setValue(Boolean.valueOf(selected));
        dialog.addTooltip((IsWidget)checkbox, tooltip);
        return checkbox;
    }

    protected PremiumCheckBox createPremiumCheckbox(DataEntryDialog<?> dialog, String label, boolean selected, String tooltip, HasPermissions.Action premiumAction) {
        SailingPremiumCheckBox premiumCheckBox = new SailingPremiumCheckBox(label, premiumAction, this.paywallResolver, (SecuredDTO)this.leaderboardDTO, selected);
        dialog.registerCheckbox(premiumCheckBox.getCheckBox());
        premiumCheckBox.ensureDebugId(String.valueOf(DebugIdHelper.createDebugId((String)label)) + CHECK_BOX_DEBUGID_CONSTANT);
        dialog.addTooltip((IsWidget)premiumCheckBox, tooltip);
        return premiumCheckBox;
    }

    public FocusWidget getFocusWidget() {
        Object result = this.raceDetailCheckboxes.isEmpty() ? (this.legDetailCheckboxes.isEmpty() ? (this.maneuverDetailCheckboxes.isEmpty() ? (this.overallDetailCheckboxes.isEmpty() ? this.refreshIntervalInSecondsBox : (FocusWidget)this.overallDetailCheckboxes.values().iterator().next()) : (FocusWidget)this.maneuverDetailCheckboxes.values().iterator().next()) : (FocusWidget)this.legDetailCheckboxes.values().iterator().next()) : (FocusWidget)this.raceDetailCheckboxes.values().iterator().next();
        return result;
    }

    protected List<DetailType> getSelected(Map<DetailType, CheckBox> checkBoxes, Collection<DetailType> initialValues) {
        ArrayList<DetailType> selectedDetails = new ArrayList<DetailType>(initialValues);
        for (Map.Entry<DetailType, CheckBox> entry : checkBoxes.entrySet()) {
            if (entry.getValue().getValue().booleanValue()) {
                selectedDetails.add(entry.getKey());
                continue;
            }
            selectedDetails.remove(entry.getKey());
        }
        return selectedDetails;
    }
}

