/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.home.shared.app;

import com.google.gwt.dom.client.AnchorElement;
import com.google.gwt.dom.client.Element;
import com.google.gwt.http.client.UrlBuilder;
import com.google.gwt.place.shared.Place;
import com.google.gwt.place.shared.PlaceHistoryMapper;
import com.google.gwt.safehtml.shared.SafeUri;
import com.google.gwt.safehtml.shared.UriUtils;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.EventListener;
import com.google.gwt.user.client.Window;
import com.sap.sailing.gwt.home.shared.app.PlaceNavigator;
import com.sap.sse.gwt.settings.UrlBuilderUtil;

public class PlaceNavigation<T extends Place> {
    private final PlaceNavigator placeNavigator;
    private final PlaceHistoryMapper mapper;
    private final T destinationPlace;
    private final String baseUrl;
    private final boolean isDestinationOnRemoteServer;

    public PlaceNavigation(T destinationPlace, PlaceNavigator placeNavigator, PlaceHistoryMapper mapper) {
        this.placeNavigator = placeNavigator;
        this.destinationPlace = destinationPlace;
        this.mapper = mapper;
        String locationURL = this.getLocationURL();
        this.isDestinationOnRemoteServer = !placeNavigator.isStandaloneServer() && !this.isLocationOnLocalhost(locationURL) && !this.isLocationOnDefaultSapSailingServer(locationURL);
        this.baseUrl = this.isDestinationOnRemoteServer ? "http://www.sapsailing.com" : locationURL;
    }

    public PlaceNavigation(String baseUrl, T destinationPlace, boolean isDestinationOnRemoteServer, PlaceNavigator placeNavigator, PlaceHistoryMapper mapper) {
        this.mapper = mapper;
        this.destinationPlace = destinationPlace;
        this.isDestinationOnRemoteServer = isDestinationOnRemoteServer;
        this.placeNavigator = placeNavigator;
        this.baseUrl = isDestinationOnRemoteServer ? baseUrl : this.getLocationURL();
    }

    public String getTargetUrl() {
        return this.buildPlaceUrl();
    }

    public SafeUri getSafeTargetUrl() {
        return UriUtils.fromString((String)this.getTargetUrl());
    }

    public String getHistoryUrl() {
        String placeUrl = this.buildPlaceUrl();
        if (placeUrl.startsWith("#")) {
            placeUrl = placeUrl.substring(1, placeUrl.length());
        }
        return placeUrl;
    }

    public Place getPlace() {
        return this.destinationPlace;
    }

    private String buildPlaceUrl() {
        if (this.isRemotePlace()) {
            UrlBuilder urlBuilder = UrlBuilderUtil.createUrlBuilderFromBaseURLAndPathWithCleanParameters((String)this.baseUrl, (String)"/gwt/Home.html");
            urlBuilder.setHash(this.getPlaceToken());
            return urlBuilder.buildString();
        }
        return this.getPlaceTokenWithHash();
    }

    public boolean isRemotePlace() {
        return this.isDestinationOnRemoteServer;
    }

    private String getPlaceTokenWithHash() {
        return "#" + this.getPlaceToken();
    }

    private String getPlaceToken() {
        return this.mapper.getToken(this.destinationPlace);
    }

    private boolean isLocationOnDefaultSapSailingServer(String urlToCheck) {
        return urlToCheck.contains("www.sapsailing.com");
    }

    private boolean isLocationOnLocalhost(String urlToCheck) {
        return urlToCheck.contains("localhost") || urlToCheck.contains("127.0.0.1");
    }

    private String getLocationURL() {
        return String.valueOf(Window.Location.getProtocol()) + "//" + Window.Location.getHostName() + ":" + Window.Location.getPort();
    }

    public void goToPlace() {
        this.placeNavigator.goToPlace(this);
    }

    public void configureAnchorElement(AnchorElement e) {
        DOM.sinkEvents((Element)e, (int)1);
        e.setHref(this.getTargetUrl());
        Event.setEventListener((Element)e, (EventListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    public String getFullQualifiedUrl() {
        return Window.Location.createUrlBuilder().setHash(this.getTargetUrl()).buildString();
    }
}

