/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.home.server.servlets;

import com.sap.sailing.domain.common.sharding.ShardingType;
import com.sap.sailing.domain.sharding.ShardingContext;
import com.sap.sailing.domain.windfinder.WindFinderTrackerFactory;
import com.sap.sailing.gwt.home.communication.SailingDispatchContext;
import com.sap.sailing.gwt.home.server.SailingDispatchContextImpl;
import com.sap.sailing.gwt.ui.server.Activator;
import com.sap.sailing.news.EventNewsService;
import com.sap.sailing.server.interfaces.RacingEventService;
import com.sap.sailing.server.statistics.TrackedRaceStatisticsCache;
import com.sap.sse.gwt.dispatch.client.transport.gwtrpc.RequestWrapper;
import com.sap.sse.gwt.dispatch.servlets.AbstractDispatchServlet;
import com.sap.sse.gwt.dispatch.shared.commands.Action;
import com.sap.sse.gwt.dispatch.shared.commands.Result;
import com.sap.sse.replication.FullyInitializedReplicableTracker;
import com.sap.sse.security.SecurityService;
import com.sap.sse.util.ServiceTrackerFactory;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public class SailingDispatchServlet
extends AbstractDispatchServlet<SailingDispatchContext> {
    private static final long serialVersionUID = -245230476512348999L;
    private final FullyInitializedReplicableTracker<RacingEventService> racingEventServiceTracker;
    private final ServiceTracker<WindFinderTrackerFactory, WindFinderTrackerFactory> windFinderTrackerFactory;
    private final ServiceTracker<EventNewsService, EventNewsService> eventNewsServiceTracker;
    private final FullyInitializedReplicableTracker<SecurityService> securityServiceTracker;
    private final ServiceTracker<TrackedRaceStatisticsCache, TrackedRaceStatisticsCache> trackedRaceStatisticsCacheTracker;

    public SailingDispatchServlet() {
        BundleContext context = Activator.getDefault();
        this.racingEventServiceTracker = FullyInitializedReplicableTracker.createAndOpen((BundleContext)context, RacingEventService.class);
        this.windFinderTrackerFactory = ServiceTrackerFactory.createAndOpen((BundleContext)context, WindFinderTrackerFactory.class);
        this.eventNewsServiceTracker = ServiceTrackerFactory.createAndOpen((BundleContext)context, EventNewsService.class);
        this.securityServiceTracker = FullyInitializedReplicableTracker.createAndOpen((BundleContext)context, SecurityService.class);
        this.trackedRaceStatisticsCacheTracker = ServiceTrackerFactory.createAndOpen((BundleContext)context, TrackedRaceStatisticsCache.class);
    }

    protected <R extends Result, A extends Action<R, SailingDispatchContext>> SailingDispatchContext createDispatchContextFor(RequestWrapper<R, A, SailingDispatchContext> request) {
        try {
            return new SailingDispatchContextImpl(request.getCurrentClientTime(), (RacingEventService)this.racingEventServiceTracker.getInitializedService(0L), (WindFinderTrackerFactory)this.windFinderTrackerFactory.getService(), (EventNewsService)this.eventNewsServiceTracker.getService(), (SecurityService)this.securityServiceTracker.getInitializedService(0L), (TrackedRaceStatisticsCache)this.trackedRaceStatisticsCacheTracker.getService(), request.getClientLocaleName(), this.getThreadLocalRequest());
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
        ShardingType identifiedShardingType = null;
        try {
            if (req instanceof HttpServletRequest) {
                identifiedShardingType = ShardingContext.identifyAndSetShardingConstraint((String)((HttpServletRequest)req).getPathInfo());
            }
            super.service(req, res);
        }
        catch (Throwable throwable) {
            if (identifiedShardingType != null) {
                ShardingContext.clearShardingConstraint(identifiedShardingType);
            }
            throw throwable;
        }
        if (identifiedShardingType != null) {
            ShardingContext.clearShardingConstraint((ShardingType)identifiedShardingType);
        }
    }
}

