/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.home.server;

import com.google.gwt.core.shared.GwtIncompatible;
import com.sap.sailing.gwt.home.communication.race.SimpleRaceMetadataDTO;
import com.sap.sailing.gwt.home.server.EventActionUtil;
import com.sap.sailing.gwt.home.server.RaceContext;
import com.sap.sse.common.Duration;
import com.sap.sse.common.TimePoint;
import java.util.Arrays;
import java.util.Collections;

@GwtIncompatible
public final class RaceRefreshCalculator
implements EventActionUtil.RaceCallback {
    private Duration ttl = Duration.ONE_MINUTE.times(3L);

    public void doForRace(RaceContext rc) {
        SimpleRaceMetadataDTO.RaceViewState state = rc.getLiveRaceViewState();
        if (state == SimpleRaceMetadataDTO.RaceViewState.RUNNING) {
            this.ttl = Collections.min(Arrays.asList(this.ttl, Duration.ONE_SECOND.times(30L)));
        } else if (state == SimpleRaceMetadataDTO.RaceViewState.SCHEDULED) {
            Duration timeTillRace = TimePoint.now().until(rc.getStartTime());
            this.ttl = Collections.min(Arrays.asList(this.ttl, Duration.ONE_MINUTE, timeTillRace));
        } else if (state == SimpleRaceMetadataDTO.RaceViewState.POSTPONED || state == SimpleRaceMetadataDTO.RaceViewState.ABANDONED) {
            this.ttl = Collections.min(Arrays.asList(this.ttl, Duration.ONE_MINUTE));
        }
    }

    public Duration getTTL() {
        return this.ttl;
    }
}

