/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.home.mobile.places.event;

import com.google.gwt.core.client.GWT;
import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import com.google.gwt.user.client.ui.AcceptsOneWidget;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.domain.common.windfinder.SpotDTO;
import com.sap.sailing.gwt.home.communication.event.EventAndLeaderboardReferenceWithStateDTO;
import com.sap.sailing.gwt.home.communication.eventview.RegattaMetadataDTO;
import com.sap.sailing.gwt.home.mobile.partials.quickfinder.Quickfinder;
import com.sap.sailing.gwt.home.mobile.partials.section.MobileSection;
import com.sap.sailing.gwt.home.mobile.partials.sectionHeader.SectionHeaderContent;
import com.sap.sailing.gwt.home.mobile.places.QuickfinderPresenter;
import com.sap.sailing.gwt.home.mobile.places.RegattaLeaderboardNavigationProvider;
import com.sap.sailing.gwt.home.mobile.places.SeriesLeaderboardNavigationProvider;
import com.sap.sailing.gwt.home.mobile.places.event.AbstractEventView;
import com.sap.sailing.gwt.home.mobile.places.event.EventViewBase;
import com.sap.sailing.gwt.home.shared.app.PlaceNavigation;
import com.sap.sailing.gwt.home.shared.refresh.RefreshManager;
import com.sap.sailing.gwt.home.shared.refresh.RefreshManagerWithErrorAndBusy;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sse.gwt.client.media.TakedownNoticeService;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public abstract class AbstractEventView<P extends EventViewBase.Presenter>
extends Composite
implements EventViewBase {
    private static AbstractEventViewUiBinder uiBinder = (AbstractEventViewUiBinder)GWT.create(AbstractEventViewUiBinder.class);
    protected final P currentPresenter;
    protected final RefreshManager refreshManager;
    private final AbstractEventViewLayout layout;
    private final SimplePanel contentRoot = new SimplePanel();

    public AbstractEventView(P presenter, boolean showRegattaName, boolean enableLogoNavigation) {
        this(presenter, showRegattaName, enableLogoNavigation, true);
    }

    public AbstractEventView(P presenter, boolean showRegattaName, boolean enableLogoNavigation, boolean supportsRefresh) {
        this.currentPresenter = presenter;
        String regattaName = showRegattaName ? this.currentPresenter.getRegatta().getDisplayName() : null;
        PlaceNavigation logoNavigation = enableLogoNavigation ? this.currentPresenter.getEventNavigation() : null;
        this.layout = new AbstractEventViewLayout(this.currentPresenter.getCtx(), this.currentPresenter.getEventDTO(), regattaName, logoNavigation, (TakedownNoticeService)this.currentPresenter.getUserService(), null);
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this.layout));
        if (supportsRefresh) {
            this.refreshManager = new RefreshManagerWithErrorAndBusy((Widget)this.contentRoot, (AcceptsOneWidget)this.layout.viewContentUi, this.currentPresenter.getDispatch(), this.currentPresenter.getErrorAndBusyClientFactory());
        } else {
            this.refreshManager = null;
            this.layout.viewContentUi.setWidget((Widget)this.contentRoot);
        }
    }

    protected void setViewContent(Widget contentWidget) {
        this.contentRoot.setWidget(contentWidget);
    }

    protected UUID getEventId() {
        return this.currentPresenter.getEventDTO().getId();
    }

    protected String getRegattaId() {
        return this.currentPresenter.getRegattaId();
    }

    protected boolean isMultiRegattaEvent() {
        return this.currentPresenter.isMultiRegattaEvent();
    }

    protected void setQuickFinderValues(Quickfinder quickfinder, Map<String, Set<RegattaMetadataDTO>> regattasByLeaderboardGroupName) {
        QuickfinderPresenter.getForRegattaLeaderboards((Quickfinder)quickfinder, (RegattaLeaderboardNavigationProvider)this.currentPresenter, regattasByLeaderboardGroupName);
    }

    protected void setQuickFinderValues(Quickfinder quickfinder, String seriesName, Collection<EventAndLeaderboardReferenceWithStateDTO> eventsOfSeries) {
        QuickfinderPresenter.getForSeriesLeaderboards((Quickfinder)quickfinder, (String)seriesName, (SeriesLeaderboardNavigationProvider)this.currentPresenter, eventsOfSeries);
    }

    protected void initRacesNavigation(Panel container) {
        MobileSection mobileSection = new MobileSection();
        SectionHeaderContent header = new SectionHeaderContent();
        RegattaMetadataDTO regatta = this.currentPresenter.getRegatta();
        header.setSectionTitle(StringMessages.INSTANCE.racesCount(regatta == null ? 0 : regatta.getRaceCount()));
        header.setInfoText(StringMessages.INSTANCE.showAll());
        header.setClickAction(this.currentPresenter.getRegattaRacesNavigation(this.getRegattaId()));
        mobileSection.addHeader((Widget)header);
        mobileSection.setEdgeToEdgeContent(true);
        container.add((Widget)mobileSection);
    }

    public void setQuickFinderValues(Map<String, Set<RegattaMetadataDTO>> regattasByLeaderboardGroupName) {
        this.setQuickFinderValues(this.layout.quickFinderUi, regattasByLeaderboardGroupName);
    }

    public final void setQuickFinderValues(String seriesName, Collection<EventAndLeaderboardReferenceWithStateDTO> eventsOfSeries) {
        this.setQuickFinderValues(this.layout.quickFinderUi, seriesName, eventsOfSeries);
    }

    public final void hideQuickfinder() {
        this.layout.quickFinderUi.removeFromParent();
    }

    public void setSailorInfos(String description, String buttonLabel, String url) {
        this.layout.sailorInfoUi.setDescription(SafeHtmlUtils.fromString((String)description.replace("\n", " ")));
        this.layout.sailorInfoUi.setAction(buttonLabel, url);
    }

    public void setWindfinderNavigations(Iterable<SpotDTO> spotData) {
        this.layout.windfinderWrapperUi.getStyle().clearDisplay();
        this.layout.windfinderUi.setSpotData(spotData);
    }

    public void setSeriesNavigation(String buttonLabel, PlaceNavigation<?> placeNavigation) {
        this.layout.seriesNavigationoUi.setAction(buttonLabel, placeNavigation);
    }
}

