/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.home.mobile.partials.recents;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.DivElement;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.SpanElement;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTMLPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.gwt.home.communication.event.EventMetadataDTO;
import com.sap.sailing.gwt.home.communication.eventlist.EventListEventDTO;
import com.sap.sailing.gwt.home.communication.eventlist.EventListEventSeriesDTO;
import com.sap.sailing.gwt.home.communication.eventlist.EventListYearDTO;
import com.sap.sailing.gwt.home.mobile.app.MobilePlacesNavigator;
import com.sap.sailing.gwt.home.mobile.partials.recents.EventsOverviewRecentResources;
import com.sap.sailing.gwt.home.mobile.partials.recents.EventsOverviewRecentYear;
import com.sap.sailing.gwt.home.mobile.partials.recents.EventsOverviewRecentYearEvent;
import com.sap.sailing.gwt.home.mobile.partials.stage.Stage;
import com.sap.sailing.gwt.home.mobile.partials.statisticsBox.MobileStatisticsBoxView;
import com.sap.sailing.gwt.home.shared.app.PlaceNavigation;
import com.sap.sailing.gwt.home.shared.partials.statistics.StatisticsBoxView;
import com.sap.sailing.gwt.home.shared.partials.statistics.YearStatisticsBox;
import com.sap.sailing.gwt.home.shared.places.fakeseries.SeriesContext;
import com.sap.sailing.gwt.home.shared.utils.CollapseAnimation;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sse.gwt.client.media.TakedownNoticeService;
import java.util.List;
import java.util.UUID;

public class EventsOverviewRecentYear
extends Composite {
    private static EventsOverviewUiBinder uiBinder = (EventsOverviewUiBinder)GWT.create(EventsOverviewUiBinder.class);
    @UiField
    SpanElement year;
    @UiField
    SpanElement eventsCount;
    @UiField
    FlowPanel recentEventsTeaserPanel;
    @UiField(provided=true)
    Stage eventStage;
    @UiField
    DivElement contentDiv;
    @UiField
    HTMLPanel headerDiv;
    @UiField
    StringMessages i18n;
    private boolean isContentVisible;
    private boolean isStageInitialized;
    private final CollapseAnimation animation;
    private final List<EventListEventDTO> events;
    private final TakedownNoticeService takedownNoticeService;

    public EventsOverviewRecentYear(EventListYearDTO yearDTO, MobilePlacesNavigator navigator, boolean showInitial, TakedownNoticeService takedownNoticeService) {
        this.isContentVisible = showInitial;
        this.takedownNoticeService = takedownNoticeService;
        this.events = yearDTO.getEvents();
        this.eventStage = new Stage(navigator, false);
        EventsOverviewRecentResources.INSTANCE.css().ensureInjected();
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.year.setInnerText(String.valueOf(yearDTO.getYear()));
        this.eventsCount.setInnerText(this.i18n.eventsCount(yearDTO.getEventCount()));
        boolean first = true;
        for (EventListEventDTO eventDTO : this.events) {
            PlaceNavigation eventNavigation = navigator.getEventNavigation(eventDTO.getId().toString(), eventDTO.getBaseURL(), eventDTO.isOnRemoteServer());
            EventsOverviewRecentYearEvent recentEvent = new EventsOverviewRecentYearEvent(eventNavigation, (EventMetadataDTO)eventDTO, eventDTO.getState().getListStateMarker(), first || eventDTO.isRunning());
            EventListEventSeriesDTO eventSeries = eventDTO.getEventSeries();
            if (eventSeries != null) {
                String baseUrl = eventDTO.getBaseURL();
                SeriesContext ctx = SeriesContext.createWithLeaderboardGroupId((UUID)eventSeries.getSeriesLeaderboardGroupId());
                PlaceNavigation seriesNavigation = navigator.getEventSeriesNavigation(ctx, baseUrl, eventDTO.isOnRemoteServer());
                recentEvent.setSeriesInformation(seriesNavigation, eventDTO.getEventSeries());
            }
            this.recentEventsTeaserPanel.add((Widget)recentEvent);
            if (!first) continue;
            first = false;
        }
        YearStatisticsBox statisticsBox = new YearStatisticsBox((StatisticsBoxView)new MobileStatisticsBoxView(StringMessages.INSTANCE.statisticsFor(Integer.toString(yearDTO.getYear()))), yearDTO);
        statisticsBox.getElement().getStyle().setPaddingLeft(1.0, Style.Unit.EM);
        statisticsBox.getElement().getStyle().setPaddingRight(1.0, Style.Unit.EM);
        this.recentEventsTeaserPanel.add((Widget)statisticsBox);
        this.initStageContents();
        this.headerDiv.addDomHandler((EventHandler)new /* Unavailable Anonymous Inner Class!! */, ClickEvent.getType());
        this.animation = new CollapseAnimation((Element)this.contentDiv, showInitial);
        this.updateAccordionState();
    }

    private void initStageContents() {
        if (this.isContentVisible && !this.isStageInitialized) {
            this.eventStage.setFeaturedEvents(this.events, this.takedownNoticeService);
            this.isStageInitialized = true;
        }
    }

    private void onHeaderClicked() {
        this.isContentVisible = !this.isContentVisible;
        this.updateContentVisibility();
    }

    private void updateContentVisibility() {
        this.animation.animate(this.isContentVisible);
        this.initStageContents();
        this.updateAccordionState();
    }

    private void updateAccordionState() {
        if (this.isContentVisible) {
            this.getElement().removeClassName(EventsOverviewRecentResources.INSTANCE.css().accordioncollapsed());
        } else {
            this.getElement().addClassName(EventsOverviewRecentResources.INSTANCE.css().accordioncollapsed());
        }
    }

    static /* synthetic */ void access$0(EventsOverviewRecentYear eventsOverviewRecentYear) {
        eventsOverviewRecentYear.onHeaderClicked();
    }
}

