/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.home.mobile.partials.minileaderboard;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.gwt.home.communication.event.LabelType;
import com.sap.sailing.gwt.home.communication.event.minileaderboard.GetMiniLeaderboardDTO;
import com.sap.sailing.gwt.home.communication.event.minileaderboard.MiniLeaderboardItemDTO;
import com.sap.sailing.gwt.home.mobile.partials.minileaderboard.MinileaderboardBox;
import com.sap.sailing.gwt.home.mobile.partials.minileaderboard.MinileaderboardBoxItem;
import com.sap.sailing.gwt.home.mobile.partials.minileaderboard.MinileaderboardBoxItemLegend;
import com.sap.sailing.gwt.home.mobile.partials.section.MobileSection;
import com.sap.sailing.gwt.home.mobile.partials.sectionHeader.SectionHeaderContent;
import com.sap.sailing.gwt.home.mobile.partials.toggleButton.BigButton;
import com.sap.sailing.gwt.home.shared.app.PlaceNavigation;
import com.sap.sailing.gwt.home.shared.refresh.RefreshableWidget;
import com.sap.sailing.gwt.ui.client.FlagImageResolver;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sse.gwt.client.DateAndTimeFormatterUtil;
import java.util.Date;

public class MinileaderboardBox
extends Composite
implements RefreshableWidget<GetMiniLeaderboardDTO> {
    private static MyUiBinder uiBinder = (MyUiBinder)GWT.create(MyUiBinder.class);
    private final StringMessages I18N = StringMessages.INSTANCE;
    @UiField
    MobileSection itemContainerUi;
    @UiField
    SectionHeaderContent headerUi;
    @UiField
    BigButton showLeaderboardButtonUi;
    private PlaceNavigation<?> placeNavigation = null;
    private boolean isOverall;
    private final FlagImageResolver flagImageResolver;

    public MinileaderboardBox(boolean isOverall, FlagImageResolver flagImageResolver) {
        this.isOverall = isOverall;
        this.flagImageResolver = flagImageResolver;
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
    }

    @UiHandler(value={"showLeaderboardButtonUi"})
    void onShowLeaderboardClick(ClickEvent event) {
        if (this.placeNavigation != null) {
            this.placeNavigation.goToPlace();
        }
    }

    public void setAction(String infoText, PlaceNavigation<?> placeNavigation) {
        this.headerUi.setInfoText(infoText);
        this.headerUi.setClickAction(placeNavigation);
        this.placeNavigation = placeNavigation;
    }

    public void setData(GetMiniLeaderboardDTO data) {
        String headerText = this.isOverall ? this.I18N.overallStandings() : this.I18N.results();
        int itemCount = data.getItems().size();
        boolean showLeaderboardButton = false;
        if (itemCount > 0 && data.getTotalCompetitorCount() > itemCount) {
            headerText = String.valueOf(headerText) + " (" + StringMessages.INSTANCE.topN(itemCount) + ")";
            showLeaderboardButton = true;
        }
        this.headerUi.setSectionTitle(headerText);
        this.itemContainerUi.clearContent();
        if (data.getItems().isEmpty()) {
            this.itemContainerUi.addContent(this.getNoResultsInfoWidget());
            return;
        }
        this.headerUi.setLabelType(data.isLive() ? LabelType.LIVE : LabelType.NONE);
        if (data.getScoreCorrectionText() != null || data.getLastScoreUpdate() != null) {
            this.itemContainerUi.addContent(this.getScoreInformation(data));
        }
        boolean showRaceCounts = data.hasDifferentRaceCounts();
        for (MiniLeaderboardItemDTO item : data.getItems()) {
            this.itemContainerUi.addContent((Widget)new MinileaderboardBoxItem(item, showRaceCounts, this.flagImageResolver));
        }
        if (showRaceCounts) {
            this.itemContainerUi.addContent((Widget)new MinileaderboardBoxItemLegend());
        }
        this.showLeaderboardButtonUi.setVisible(showLeaderboardButton);
    }

    private Widget getNoResultsInfoWidget() {
        Label label = new Label(StringMessages.INSTANCE.noResults());
        label.getElement().getStyle().setPadding(1.0, Style.Unit.EM);
        label.getElement().getStyle().setFontWeight(Style.FontWeight.BOLD);
        label.getElement().getStyle().setFontStyle(Style.FontStyle.ITALIC);
        return label;
    }

    private Widget getScoreInformation(GetMiniLeaderboardDTO data) {
        FlowPanel scoreInformation = new FlowPanel();
        if (data.getScoreCorrectionText() != null) {
            scoreInformation.add((Widget)new Label(data.getScoreCorrectionText()));
        }
        if (data.getLastScoreUpdate() != null) {
            String lastUpdate = DateAndTimeFormatterUtil.formatLongDateAndTimeGMT((Date)data.getLastScoreUpdate());
            scoreInformation.add((Widget)new Label(String.valueOf(StringMessages.INSTANCE.lastScoreUpdate()) + ": " + lastUpdate));
        }
        scoreInformation.getElement().getStyle().setBackgroundColor("#f2f2f2");
        scoreInformation.getElement().getStyle().setProperty("borderTop", "1px solid #ccc");
        scoreInformation.getElement().getStyle().setFontSize(0.866666666666667, Style.Unit.EM);
        scoreInformation.getElement().getStyle().setPadding(1.0, Style.Unit.EM);
        if (data.isLive()) {
            scoreInformation.getElement().getStyle().setColor("#ff0000");
        }
        return scoreInformation;
    }
}

