/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.home.mobile.partials.eventsteps;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.AnchorElement;
import com.google.gwt.dom.client.DivElement;
import com.google.gwt.dom.client.ImageElement;
import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.Style;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.gwt.home.communication.race.FleetMetadataDTO;
import com.sap.sailing.gwt.home.communication.regatta.RegattaProgressFleetDTO;
import com.sap.sailing.gwt.home.communication.regatta.RegattaProgressSeriesDTO;
import com.sap.sailing.gwt.home.mobile.partials.eventsteps.EventStepsPhase;
import com.sap.sailing.gwt.home.mobile.partials.eventsteps.EventStepsPhaseFleet;
import com.sap.sailing.gwt.home.mobile.partials.eventsteps.EventStepsResources;
import com.sap.sailing.gwt.home.shared.app.PlaceNavigation;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sse.gwt.client.LinkUtil;
import java.util.Map;

public class EventStepsPhase
extends Composite {
    private static final StringMessages I18N = StringMessages.INSTANCE;
    private static EventStepsPhaseUiBinder uiBinder = (EventStepsPhaseUiBinder)GWT.create(EventStepsPhaseUiBinder.class);
    @UiField
    AnchorElement anchorUi;
    @UiField
    DivElement nameUi;
    @UiField
    ImageElement checkUi;
    @UiField
    DivElement progressUi;
    @UiField
    DivElement fleetsContainerUi;

    EventStepsPhase(RegattaProgressSeriesDTO seriesProgress, PlaceNavigation<?> placeNavigation, boolean showName) {
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        LinkUtil.configureForAction((AnchorElement)this.anchorUi, () -> placeNavigation.goToPlace());
        if (showName) {
            this.nameUi.setInnerText(seriesProgress.getName());
        } else {
            this.nameUi.removeFromParent();
        }
        if (seriesProgress.isCompleted()) {
            this.progressUi.setInnerText(I18N.racesCount(seriesProgress.getTotalRaceCount()));
        } else {
            this.checkUi.getStyle().setDisplay(Style.Display.NONE);
            int current = seriesProgress.getProgressRaceCount();
            int total = seriesProgress.getTotalRaceCount();
            this.progressUi.setInnerText(I18N.currentOfTotalRaces(current, total));
        }
        if (seriesProgress.getProgressRaceCount() == 0) {
            this.addStyleName(EventStepsResources.INSTANCE.css().eventsteps_phases_phaseinactive());
        }
        this.addFleetProgresses(seriesProgress.getFleetState(), seriesProgress.getMaxRacesPerFleet());
    }

    private void addFleetProgresses(Map<FleetMetadataDTO, RegattaProgressFleetDTO> fleetStates, int totalRaceCount) {
        double height = fleetStates.isEmpty() ? 100.0 : 100.0 / (double)fleetStates.size();
        for (Map.Entry<FleetMetadataDTO, RegattaProgressFleetDTO> fleetState : fleetStates.entrySet()) {
            double finishedWidth = (double)fleetState.getValue().getFinishedRaceCount() * 100.0 / (double)totalRaceCount;
            double liveWidth = (double)fleetState.getValue().getFinishedAndLiveRaceCount() * 100.0 / (double)totalRaceCount;
            String fleetColor = fleetState.getKey().getFleetColor();
            EventStepsPhaseFleet fleet = new EventStepsPhaseFleet(finishedWidth, liveWidth, height, fleetColor);
            this.fleetsContainerUi.appendChild((Node)fleet.getElement());
        }
    }
}

