/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.home.desktop.places.user.profile;

import com.google.gwt.activity.shared.AbstractActivity;
import com.google.gwt.core.shared.GWT;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.place.shared.Place;
import com.google.gwt.safehtml.shared.SafeUri;
import com.google.gwt.safehtml.shared.UriUtils;
import com.google.gwt.user.client.ui.AcceptsOneWidget;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.web.bindery.event.shared.Event;
import com.sap.sailing.gwt.common.client.controls.tabbar.TabView;
import com.sap.sailing.gwt.home.desktop.app.DesktopPlacesNavigator;
import com.sap.sailing.gwt.home.desktop.places.user.profile.TabletAndDesktopUserProfileView;
import com.sap.sailing.gwt.home.desktop.places.user.profile.UserProfileClientFactory;
import com.sap.sailing.gwt.home.desktop.places.user.profile.UserProfileView;
import com.sap.sailing.gwt.home.shared.app.ApplicationHistoryMapper;
import com.sap.sailing.gwt.home.shared.app.NavigationPathDisplay;
import com.sap.sailing.gwt.home.shared.app.PlaceNavigation;
import com.sap.sailing.gwt.home.shared.places.fakeseries.AbstractSeriesPlace;
import com.sap.sailing.gwt.home.shared.places.start.StartPlace;
import com.sap.sailing.gwt.home.shared.places.user.profile.AbstractUserProfilePlace;
import com.sap.sailing.gwt.ui.client.FlagImageResolver;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sse.security.ui.authentication.AuthenticationContextEvent;
import com.sap.sse.security.ui.authentication.AuthenticationPlaces;
import com.sap.sse.security.ui.authentication.AuthenticationRequestEvent;

public class UserProfileActivity
extends AbstractActivity
implements UserProfileView.Presenter {
    private static final ApplicationHistoryMapper historyMapper = (ApplicationHistoryMapper)GWT.create(ApplicationHistoryMapper.class);
    protected final AbstractUserProfilePlace currentPlace;
    protected final UserProfileClientFactory clientFactory;
    protected final DesktopPlacesNavigator homePlacesNavigator;
    private final com.sap.sse.security.ui.client.i18n.StringMessages i18n_sec = com.sap.sse.security.ui.client.i18n.StringMessages.INSTANCE;
    private final UserProfileView<AbstractUserProfilePlace, UserProfileView.Presenter> currentView;

    public UserProfileActivity(AbstractUserProfilePlace place, UserProfileClientFactory clientFactory, DesktopPlacesNavigator homePlacesNavigator, NavigationPathDisplay navigationPathDisplay, FlagImageResolver flagImageResolver) {
        this.currentPlace = place;
        this.clientFactory = clientFactory;
        this.homePlacesNavigator = homePlacesNavigator;
        this.currentView = new TabletAndDesktopUserProfileView(homePlacesNavigator, flagImageResolver);
        this.initNavigationPath(navigationPathDisplay);
    }

    private void initNavigationPath(NavigationPathDisplay navigationPathDisplay) {
        StringMessages i18n = StringMessages.INSTANCE;
        navigationPathDisplay.showNavigationPath(new NavigationPathDisplay.NavigationItem[]{new NavigationPathDisplay.NavigationItem(i18n.home(), this.getHomeNavigation()), new NavigationPathDisplay.NavigationItem(this.i18n_sec.userDetails(), this.getUserProfileNavigation())});
    }

    public void start(AcceptsOneWidget panel, EventBus eventBus) {
        this.currentView.registerPresenter((UserProfileView.Presenter)this);
        panel.setWidget((IsWidget)this.currentView);
        this.currentView.navigateTabsTo(this.currentPlace);
        this.currentView.setAuthenticationContext(this.clientFactory.getAuthenticationManager().getAuthenticationContext());
        eventBus.addHandler(AuthenticationContextEvent.TYPE, (EventHandler)((AuthenticationContextEvent.Handler)event -> this.currentView.setAuthenticationContext(event.getCtx())));
    }

    public void handleTabPlaceSelection(TabView<?, ? extends UserProfileView.Presenter> selectedActivity) {
        Place tabPlaceToGo = selectedActivity.placeToFire();
        this.clientFactory.getPlaceController().goTo(tabPlaceToGo);
    }

    public void navigateTo(Place place) {
        this.clientFactory.getPlaceController().goTo(place);
    }

    public SafeUri getUrl(AbstractSeriesPlace place) {
        String token = historyMapper.getToken((Place)place);
        return UriUtils.fromString((String)("#" + token));
    }

    public PlaceNavigation<StartPlace> getHomeNavigation() {
        return this.homePlacesNavigator.getHomeNavigation();
    }

    public PlaceNavigation<? extends AbstractUserProfilePlace> getUserProfileNavigation() {
        return this.homePlacesNavigator.getUserProfileNavigation();
    }

    public void doTriggerLoginForm() {
        this.clientFactory.getEventBus().fireEvent((Event)new AuthenticationRequestEvent(AuthenticationPlaces.SIGN_IN));
    }

    public UserProfileClientFactory getClientFactory() {
        return this.clientFactory;
    }

    public String getMailVerifiedUrl() {
        return this.homePlacesNavigator.getMailVerifiedConfirmationNavigation().getTargetUrl();
    }
}

