/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.home.desktop.places.fakeseries;

import com.google.gwt.activity.shared.AbstractActivity;
import com.google.gwt.core.shared.GWT;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.place.shared.Place;
import com.google.gwt.safehtml.shared.SafeUri;
import com.google.gwt.safehtml.shared.UriUtils;
import com.google.gwt.user.client.ui.AcceptsOneWidget;
import com.google.gwt.user.client.ui.IsWidget;
import com.sap.sailing.gwt.common.client.controls.tabbar.TabView;
import com.sap.sailing.gwt.home.client.place.event.legacy.SeriesClientFactory;
import com.sap.sailing.gwt.home.communication.fakeseries.EventSeriesViewDTO;
import com.sap.sailing.gwt.home.desktop.app.DesktopPlacesNavigator;
import com.sap.sailing.gwt.home.desktop.places.event.regatta.overviewtab.RegattaOverviewPlace;
import com.sap.sailing.gwt.home.desktop.places.fakeseries.AbstractSeriesTabPlace;
import com.sap.sailing.gwt.home.desktop.places.fakeseries.EventSeriesAnalyticsDataManager;
import com.sap.sailing.gwt.home.desktop.places.fakeseries.SeriesView;
import com.sap.sailing.gwt.home.desktop.places.fakeseries.TabletAndDesktopSeriesView;
import com.sap.sailing.gwt.home.shared.app.ApplicationHistoryMapper;
import com.sap.sailing.gwt.home.shared.app.NavigationPathDisplay;
import com.sap.sailing.gwt.home.shared.app.PlaceNavigation;
import com.sap.sailing.gwt.home.shared.places.event.EventDefaultPlace;
import com.sap.sailing.gwt.home.shared.places.events.EventsPlace;
import com.sap.sailing.gwt.home.shared.places.fakeseries.AbstractSeriesPlace;
import com.sap.sailing.gwt.home.shared.places.fakeseries.SeriesContext;
import com.sap.sailing.gwt.home.shared.places.fakeseries.SeriesDefaultPlace;
import com.sap.sailing.gwt.home.shared.places.start.StartPlace;
import com.sap.sailing.gwt.ui.client.FlagImageResolver;
import com.sap.sailing.gwt.ui.client.SailingClientFactory;
import com.sap.sailing.gwt.ui.client.SailingServiceAsync;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.client.refresh.ErrorAndBusyClientFactory;
import com.sap.sse.gwt.client.async.AsyncActionsExecutor;
import com.sap.sse.gwt.client.player.Timer;
import com.sap.sse.security.ui.client.UserService;
import com.sap.sse.security.ui.client.subscription.SubscriptionServiceFactory;
import java.util.UUID;

public class SeriesActivity
extends AbstractActivity
implements SeriesView.Presenter {
    protected final AbstractSeriesTabPlace currentPlace;
    protected final SeriesContext ctx;
    protected final SeriesClientFactory clientFactory;
    protected final DesktopPlacesNavigator homePlacesNavigator;
    private static final ApplicationHistoryMapper historyMapper = (ApplicationHistoryMapper)GWT.create(ApplicationHistoryMapper.class);
    private SeriesView<AbstractSeriesTabPlace, SeriesView.Presenter> currentView = new TabletAndDesktopSeriesView();
    private final AsyncActionsExecutor asyncActionsExecutor = new AsyncActionsExecutor();
    private final long delayBetweenAutoAdvancesInMilliseconds = 3000L;
    private final EventSeriesViewDTO series;

    public SeriesActivity(AbstractSeriesTabPlace place, EventSeriesViewDTO series, SeriesClientFactory clientFactory, DesktopPlacesNavigator homePlacesNavigator, NavigationPathDisplay navigationPathDisplay, FlagImageResolver flagImageResolver) {
        this.currentPlace = place;
        this.series = series;
        this.ctx = new SeriesContext(place.getCtx());
        this.clientFactory = clientFactory;
        this.homePlacesNavigator = homePlacesNavigator;
        if (this.ctx.getAnalyticsManager() == null) {
            this.ctx.withAnalyticsManager(new EventSeriesAnalyticsDataManager((SailingClientFactory)clientFactory, this.asyncActionsExecutor, new Timer(Timer.PlayModes.Live, Timer.PlayStates.Paused, 3000L), clientFactory.getErrorReporter(), flagImageResolver));
        }
        this.initNavigationPath(navigationPathDisplay);
    }

    private void initNavigationPath(NavigationPathDisplay navigationPathDisplay) {
        StringMessages i18n = StringMessages.INSTANCE;
        navigationPathDisplay.showNavigationPath(new NavigationPathDisplay.NavigationItem[]{new NavigationPathDisplay.NavigationItem(i18n.home(), this.getHomeNavigation()), new NavigationPathDisplay.NavigationItem(i18n.events(), this.getEventsNavigation()), new NavigationPathDisplay.NavigationItem(this.getSeriesDTO().getDisplayName(), this.getCurrentEventSeriesNavigation())});
    }

    public void start(AcceptsOneWidget panel, EventBus eventBus) {
        this.currentView.registerPresenter((SeriesView.Presenter)this);
        panel.setWidget((IsWidget)this.currentView);
        this.currentView.navigateTabsTo((AbstractSeriesPlace)this.currentPlace);
    }

    public SeriesContext getCtx() {
        return this.ctx;
    }

    public void handleTabPlaceSelection(TabView<?, ? extends SeriesView.Presenter> selectedActivity) {
        Place tabPlaceToGo = selectedActivity.placeToFire();
        this.clientFactory.getPlaceController().goTo(tabPlaceToGo);
    }

    public void navigateTo(Place place) {
        this.clientFactory.getPlaceController().goTo(place);
    }

    public SafeUri getUrl(AbstractSeriesPlace place) {
        String token = historyMapper.getToken((Place)place);
        return UriUtils.fromString((String)("#" + token));
    }

    public PlaceNavigation<StartPlace> getHomeNavigation() {
        return this.homePlacesNavigator.getHomeNavigation();
    }

    public PlaceNavigation<EventsPlace> getEventsNavigation() {
        return this.homePlacesNavigator.getEventsNavigation();
    }

    public PlaceNavigation<EventDefaultPlace> getEventNavigation(UUID eventId) {
        return this.homePlacesNavigator.getEventNavigation(eventId.toString(), null, false);
    }

    public PlaceNavigation<RegattaOverviewPlace> getRegattaNavigation(UUID eventId, String leaderboardName) {
        return this.homePlacesNavigator.getRegattaNavigation(eventId.toString(), leaderboardName, null, false);
    }

    public PlaceNavigation<SeriesDefaultPlace> getCurrentEventSeriesNavigation() {
        return this.homePlacesNavigator.getEventSeriesNavigation(this.ctx, null, false);
    }

    public Timer getAutoRefreshTimer() {
        return this.ctx.getAnalyticsManager().getTimer();
    }

    public EventSeriesViewDTO getSeriesDTO() {
        return this.series;
    }

    public ErrorAndBusyClientFactory getErrorAndBusyClientFactory() {
        return this.clientFactory;
    }

    public UserService getUserService() {
        return this.clientFactory.getUserService();
    }

    public SubscriptionServiceFactory getSubscriptionServiceFactory() {
        return this.clientFactory.getSubscriptionServiceFactory();
    }

    public SailingServiceAsync getSailingService() {
        return this.clientFactory.getSailingService();
    }
}

