/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.home.desktop.places.fakeseries;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.sap.sailing.domain.common.DetailType;
import com.sap.sailing.domain.common.RegattaAndRaceIdentifier;
import com.sap.sailing.domain.common.dto.CompetitorDTO;
import com.sap.sailing.gwt.settings.client.leaderboard.MultiCompetitorLeaderboardChartSettings;
import com.sap.sailing.gwt.settings.client.leaderboard.MultiRaceLeaderboardSettings;
import com.sap.sailing.gwt.ui.client.CompetitorSelectionModel;
import com.sap.sailing.gwt.ui.client.CompetitorSelectionProvider;
import com.sap.sailing.gwt.ui.client.DebugIdHelper;
import com.sap.sailing.gwt.ui.client.FlagImageResolver;
import com.sap.sailing.gwt.ui.client.SailingClientFactory;
import com.sap.sailing.gwt.ui.client.SailingServiceAsync;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.client.shared.charts.MultiCompetitorLeaderboardChart;
import com.sap.sailing.gwt.ui.leaderboard.ClassicLeaderboardStyle;
import com.sap.sailing.gwt.ui.leaderboard.LeaderboardPanel;
import com.sap.sailing.gwt.ui.leaderboard.MultiLeaderboardProxyPanel;
import com.sap.sailing.gwt.ui.leaderboard.MultiRaceLeaderboardPanel;
import com.sap.sse.common.Util;
import com.sap.sse.common.settings.Settings;
import com.sap.sse.gwt.client.ErrorReporter;
import com.sap.sse.gwt.client.async.AsyncActionsExecutor;
import com.sap.sse.gwt.client.player.TimeListener;
import com.sap.sse.gwt.client.player.Timer;
import com.sap.sse.gwt.client.shared.components.Component;
import com.sap.sse.gwt.client.shared.components.SettingsDialog;
import com.sap.sse.gwt.client.shared.settings.ComponentContext;
import com.sap.sse.security.ui.client.WithSecurity;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.function.Function;

public class EventSeriesAnalyticsDataManager {
    private MultiRaceLeaderboardPanel overallLeaderboardPanel;
    private MultiCompetitorLeaderboardChart multiCompetitorChart;
    private MultiLeaderboardProxyPanel multiLeaderboardPanel;
    private final CompetitorSelectionModel competitorSelectionProvider;
    private final AsyncActionsExecutor asyncActionsExecutor;
    private final ErrorReporter errorReporter;
    private final SailingClientFactory sailingCF;
    private final Timer timer;
    private final int MAX_COMPETITORS_IN_CHART = 30;
    private final FlagImageResolver flagImageResolver;

    public EventSeriesAnalyticsDataManager(SailingClientFactory sailingCF, AsyncActionsExecutor asyncActionsExecutor, Timer timer, ErrorReporter errorReporter, FlagImageResolver flagImageResolver) {
        this.flagImageResolver = flagImageResolver;
        this.competitorSelectionProvider = new CompetitorSelectionModel(true);
        this.sailingCF = sailingCF;
        this.asyncActionsExecutor = asyncActionsExecutor;
        this.timer = timer;
        this.errorReporter = errorReporter;
        this.overallLeaderboardPanel = null;
        this.multiCompetitorChart = null;
    }

    public MultiRaceLeaderboardPanel createMultiRaceOverallLeaderboardPanel(Component<?> parent, ComponentContext<?> context, MultiRaceLeaderboardSettings leaderboardSettings, String leaderboardGroupName, String leaderboardName, boolean showRaceDetails, boolean autoExpandLastRaceColumn, Iterable<DetailType> availableDetailTypes) {
        if (this.overallLeaderboardPanel == null) {
            SailingServiceAsync sailingService = this.sailingCF.getSailingService(() -> leaderboardName);
            this.overallLeaderboardPanel = new MultiRaceLeaderboardPanel(parent, context, sailingService, this.asyncActionsExecutor, leaderboardSettings, true, (CompetitorSelectionProvider)this.competitorSelectionProvider, this.timer, leaderboardName, this.errorReporter, StringMessages.INSTANCE, showRaceDetails, null, true, null, autoExpandLastRaceColumn, true, false, false, false, (LeaderboardPanel.LeaderBoardStyle)new ClassicLeaderboardStyle(), this.flagImageResolver, availableDetailTypes, (WithSecurity)this.sailingCF);
        }
        return this.overallLeaderboardPanel;
    }

    public MultiCompetitorLeaderboardChart createMultiCompetitorChart(Component<?> parent, ComponentContext<?> context, String leaderboardName, DetailType chartDetailType) {
        if (this.multiCompetitorChart == null) {
            SailingServiceAsync sailingService = this.sailingCF.getSailingService(() -> leaderboardName);
            this.multiCompetitorChart = new MultiCompetitorLeaderboardChart(parent, context, sailingService, this.asyncActionsExecutor, leaderboardName, chartDetailType, (CompetitorSelectionProvider)this.competitorSelectionProvider, this.timer, StringMessages.INSTANCE, true, this.errorReporter);
            this.multiCompetitorChart.setVisible(false);
        }
        return this.multiCompetitorChart;
    }

    public MultiLeaderboardProxyPanel createMultiLeaderboardPanel(Component<?> parent, ComponentContext<?> context, MultiRaceLeaderboardSettings leaderboardSettings, String preselectedLeaderboardName, String leaderboardGroupName, String metaLeaderboardName, boolean showRaceDetails, boolean autoExpandLastRaceColumn, Iterable<DetailType> availableDetailTypes) {
        if (this.multiLeaderboardPanel == null) {
            Function<String, SailingServiceAsync> sailingServiceFactory = leaderBoardName -> this.sailingCF.getSailingService(() -> leaderBoardName);
            this.multiLeaderboardPanel = new MultiLeaderboardProxyPanel(parent, context, sailingServiceFactory, metaLeaderboardName, this.asyncActionsExecutor, this.timer, true, preselectedLeaderboardName, this.errorReporter, StringMessages.INSTANCE, showRaceDetails, autoExpandLastRaceColumn, leaderboardSettings, this.flagImageResolver, availableDetailTypes, (WithSecurity)this.sailingCF);
        }
        return this.multiLeaderboardPanel;
    }

    public MultiLeaderboardProxyPanel getMultiLeaderboardPanel() {
        return this.multiLeaderboardPanel;
    }

    public MultiRaceLeaderboardPanel getLeaderboardPanel() {
        return this.overallLeaderboardPanel;
    }

    public MultiCompetitorLeaderboardChart getMultiCompetitorChart() {
        return this.multiCompetitorChart;
    }

    public void showCompetitorChart(DetailType chartDetailType) {
        int competitorsCount = Util.size((Iterable)this.competitorSelectionProvider.getAllCompetitors());
        int selectedCompetitorsCount = Util.size((Iterable)this.competitorSelectionProvider.getSelectedCompetitors());
        if (selectedCompetitorsCount == 0 && competitorsCount > 30) {
            ArrayList<CompetitorDTO> selectedCompetitors = new ArrayList<CompetitorDTO>();
            Iterator allCompetitorsIt = this.competitorSelectionProvider.getAllCompetitors().iterator();
            int counter = 0;
            while (counter < 30) {
                selectedCompetitors.add((CompetitorDTO)allCompetitorsIt.next());
                ++counter;
            }
            this.competitorSelectionProvider.setSelection(selectedCompetitors, null);
        }
        MultiCompetitorLeaderboardChart multiCompetitorChart = this.getMultiCompetitorChart();
        MultiCompetitorLeaderboardChartSettings settings = new MultiCompetitorLeaderboardChartSettings(chartDetailType);
        multiCompetitorChart.updateSettings(settings);
        multiCompetitorChart.setVisible(true);
        this.timer.addTimeListener((TimeListener)multiCompetitorChart);
        multiCompetitorChart.clearChart();
        multiCompetitorChart.timeChanged(this.timer.getTime(), null);
    }

    public CompetitorSelectionModel getCompetitorSelectionProvider() {
        return this.competitorSelectionProvider;
    }

    public void hideCompetitorChart() {
        MultiCompetitorLeaderboardChart multiCompetitorChart = this.getMultiCompetitorChart();
        if (multiCompetitorChart != null) {
            multiCompetitorChart.setVisible(false);
            this.timer.removeTimeListener((TimeListener)multiCompetitorChart);
        }
    }

    public void showOverallLeaderboardSettingsDialog() {
        this.showComponentSettingsDialog((Component)this.overallLeaderboardPanel, null);
    }

    public void showRegattaLeaderboardsSettingsDialog() {
        this.showComponentSettingsDialog((Component)this.multiLeaderboardPanel, null);
    }

    public void showChartSettingsDialog() {
        this.showComponentSettingsDialog((Component)this.multiCompetitorChart, null);
    }

    protected <SettingsType extends Settings> void showComponentSettingsDialog(Component<SettingsType> component, String componentDisplayName) {
        String componentName = componentDisplayName != null ? componentDisplayName : component.getLocalizedShortName();
        String debugIdPrefix = DebugIdHelper.createDebugId((String)componentName);
        SettingsDialog dialog = new SettingsDialog(component, (com.sap.sse.gwt.client.StringMessages)StringMessages.INSTANCE);
        dialog.ensureDebugId(String.valueOf(debugIdPrefix) + "SettingsDialog");
        dialog.show();
    }

    public Timer getTimer() {
        return this.timer;
    }

    public void getAvailableDetailTypesForLeaderboard(String leaderboardName, RegattaAndRaceIdentifier raceOrNull, AsyncCallback<Iterable<DetailType>> asyncCallback) {
        SailingServiceAsync sailingService = this.sailingCF.getSailingService(() -> leaderboardName);
        sailingService.getAvailableDetailTypesForLeaderboard(leaderboardName, raceOrNull, asyncCallback);
    }
}

