/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.home.desktop.places.event.regatta;

import com.google.gwt.event.shared.EventBus;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.AcceptsOneWidget;
import com.google.gwt.user.client.ui.IsWidget;
import com.sap.sailing.domain.common.DetailType;
import com.sap.sailing.domain.common.RegattaAndRaceIdentifier;
import com.sap.sailing.gwt.home.communication.event.EventAndLeaderboardReferenceWithStateDTO;
import com.sap.sailing.gwt.home.communication.event.EventState;
import com.sap.sailing.gwt.home.communication.eventview.EventViewDTO;
import com.sap.sailing.gwt.home.communication.eventview.HasRegattaMetadata;
import com.sap.sailing.gwt.home.communication.eventview.RegattaMetadataDTO;
import com.sap.sailing.gwt.home.communication.eventview.RegattaReferenceDTO;
import com.sap.sailing.gwt.home.communication.eventview.SeriesReferenceWithEventsDTO;
import com.sap.sailing.gwt.home.desktop.app.DesktopPlacesNavigator;
import com.sap.sailing.gwt.home.desktop.places.event.AbstractEventActivity;
import com.sap.sailing.gwt.home.desktop.places.event.EventClientFactory;
import com.sap.sailing.gwt.home.desktop.places.event.EventView;
import com.sap.sailing.gwt.home.desktop.places.event.regatta.AbstractEventRegattaPlace;
import com.sap.sailing.gwt.home.desktop.places.event.regatta.EventRegattaView;
import com.sap.sailing.gwt.home.desktop.places.event.regatta.RegattaAnalyticsDataManager;
import com.sap.sailing.gwt.home.desktop.places.event.regatta.TabletAndDesktopRegattaEventView;
import com.sap.sailing.gwt.home.desktop.places.event.regatta.overviewtab.RegattaOverviewPlace;
import com.sap.sailing.gwt.home.shared.app.NavigationPathDisplay;
import com.sap.sailing.gwt.home.shared.app.PlaceNavigation;
import com.sap.sailing.gwt.home.shared.places.event.AbstractEventPlace;
import com.sap.sailing.gwt.home.shared.places.event.EventContext;
import com.sap.sailing.gwt.home.shared.places.fakeseries.SeriesDefaultPlace;
import com.sap.sailing.gwt.ui.client.FlagImageResolver;
import com.sap.sailing.gwt.ui.client.SailingClientFactory;
import com.sap.sse.gwt.client.async.AsyncActionsExecutor;
import com.sap.sse.gwt.client.player.Timer;
import java.util.List;

public class EventRegattaActivity
extends AbstractEventActivity<AbstractEventRegattaPlace>
implements EventRegattaView.Presenter {
    private EventRegattaView currentView;
    private final AsyncActionsExecutor asyncActionsExecutor = new AsyncActionsExecutor();
    private final long delayBetweenAutoAdvancesInMilliseconds = 3000L;

    public EventRegattaActivity(AbstractEventRegattaPlace place, EventViewDTO eventDTO, EventClientFactory clientFactory, DesktopPlacesNavigator homePlacesNavigator, NavigationPathDisplay navigationPathDisplay, FlagImageResolver flagImageResolver) {
        super((AbstractEventPlace)place, eventDTO, clientFactory, homePlacesNavigator);
        this.currentView = new TabletAndDesktopRegattaEventView(flagImageResolver);
        if (this.ctx.getRegattaAnalyticsManager() == null) {
            this.ctx.withRegattaAnalyticsManager(new RegattaAnalyticsDataManager((SailingClientFactory)clientFactory, this.asyncActionsExecutor, new Timer(Timer.PlayModes.Live, Timer.PlayStates.Paused, 3000L), clientFactory.getErrorReporter(), flagImageResolver));
        }
        this.initNavigationPath(navigationPathDisplay);
    }

    public com.google.web.bindery.event.shared.EventBus getEventBus() {
        return this.clientFactory.getEventBus();
    }

    private void initNavigationPath(NavigationPathDisplay navigationPathDisplay) {
        List navigationItems = this.getNavigationPathToEventLevel();
        if (this.showRegattaMetadata()) {
            navigationItems.add(new NavigationPathDisplay.NavigationItem(this.getRegattaMetadata().getDisplayName(), this.getCurrentRegattaOverviewNavigation()));
        }
        navigationPathDisplay.showNavigationPath(navigationItems.toArray(new NavigationPathDisplay.NavigationItem[navigationItems.size()]));
    }

    public void start(AcceptsOneWidget panel, EventBus eventBus) {
        this.currentView.registerPresenter((EventView.Presenter)this);
        panel.setWidget((IsWidget)this.currentView);
        this.currentView.navigateTabsTo((AbstractEventPlace)((AbstractEventRegattaPlace)this.currentPlace));
    }

    public boolean needsSelectionInHeader() {
        EventViewDTO event = this.eventDTO;
        SeriesReferenceWithEventsDTO seriesData = event.getSeriesData();
        return event.isMultiRegatta() || seriesData != null && seriesData.getEventsOfSeries().size() > 1;
    }

    public void forPlaceSelection(EventView.PlaceCallback callback) {
        block3: {
            EventViewDTO event;
            block2: {
                event = this.eventDTO;
                if (!event.isMultiRegatta()) break block2;
                for (RegattaReferenceDTO regatta : event.getRegattas()) {
                    AbstractEventRegattaPlace place = ((AbstractEventRegattaPlace)this.currentPlace).newInstanceWithContext(this.contextForRegatta(regatta.getId()));
                    callback.forPlace((AbstractEventPlace)place, regatta.getDisplayName(), this.getRegattaId().equals(regatta.getId()));
                }
                break block3;
            }
            SeriesReferenceWithEventsDTO seriesData = event.getSeriesData();
            if (seriesData == null) break block3;
            for (EventAndLeaderboardReferenceWithStateDTO seriesEvent : seriesData.getEventsOfSeries()) {
                if (seriesEvent.getState() == EventState.PLANNED) continue;
                AbstractEventRegattaPlace place = ((AbstractEventRegattaPlace)this.currentPlace).newInstanceWithContext(new EventContext().withId(seriesEvent.getId().toString()).withRegattaId(seriesEvent.getLeaderboardName()));
                callback.forPlace((AbstractEventPlace)place, seriesEvent.getDisplayName(), event.getId().equals(seriesEvent.getId()));
            }
        }
    }

    public boolean showRegattaMetadata() {
        return this.eventDTO.isMultiRegatta() && this.getRegatta() != null;
    }

    public PlaceNavigation<RegattaOverviewPlace> getCurrentRegattaOverviewNavigation() {
        return this.homePlacesNavigator.getEventNavigation((AbstractEventPlace)new RegattaOverviewPlace(this.ctx), null, false);
    }

    public PlaceNavigation<SeriesDefaultPlace> getCurrentEventSeriesNavigation() {
        return this.getEventSeriesNavigation(this.getRegattaMetadata().getSeriesReference());
    }

    public Timer getAutoRefreshTimer() {
        return this.ctx.getRegattaAnalyticsManager().getTimer();
    }

    protected EventView<AbstractEventRegattaPlace, ?> getView() {
        return this.currentView;
    }

    public RegattaMetadataDTO getRegatta() {
        String regattaId = this.getRegattaId();
        if (regattaId == null) {
            return null;
        }
        for (RegattaMetadataDTO regatta : this.eventDTO.getRegattas()) {
            if (!regattaId.equals(regatta.getId())) continue;
            return regatta;
        }
        return null;
    }

    public HasRegattaMetadata getRegattaMetadata() {
        return this.getRegatta();
    }

    public boolean isEventOrRegattaLive() {
        if (this.showRegattaMetadata() && this.getRegatta().getState() == HasRegattaMetadata.RegattaState.RUNNING) {
            return true;
        }
        return super.isEventOrRegattaLive();
    }

    public void getAvailableDetailTypesForLeaderboard(String leaderboardName, RegattaAndRaceIdentifier raceOrNull, AsyncCallback<Iterable<DetailType>> asyncCallback) {
        this.clientFactory.getSailingService(() -> leaderboardName).getAvailableDetailTypesForLeaderboard(leaderboardName, raceOrNull, asyncCallback);
    }
}

