/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.home.desktop.partials.updates;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.AnchorElement;
import com.google.gwt.dom.client.DivElement;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.SpanElement;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.EventListener;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.gwt.common.client.BoatClassImageResolver;
import com.sap.sailing.gwt.home.communication.event.news.AbstractRaceNewsEntryDTO;
import com.sap.sailing.gwt.home.communication.event.news.LeaderboardNewsEntryDTO;
import com.sap.sailing.gwt.home.communication.event.news.NewsEntryDTO;
import com.sap.sailing.gwt.home.desktop.partials.updates.UpdatesBoxItem;
import com.sap.sailing.gwt.home.desktop.partials.updates.UpdatesBoxResources;
import com.sap.sailing.gwt.home.desktop.places.event.EventView;
import com.sap.sailing.gwt.home.shared.app.PlaceNavigation;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.shared.util.ConditionalDateTimeFormatter;
import java.util.Date;

public class UpdatesBoxItem
extends Widget {
    private static MyUiBinder uiBinder = (MyUiBinder)GWT.create(MyUiBinder.class);
    @UiField
    AnchorElement link;
    @UiField
    DivElement icon;
    @UiField
    SpanElement titleUi;
    @UiField
    SpanElement boatClassUi;
    @UiField
    DivElement messageUi;
    @UiField
    DivElement timestampUi;

    public UpdatesBoxItem(NewsEntryDTO entry, Date currentTimestamp, EventView.Presenter presenter) {
        Date newsTimestamp;
        UpdatesBoxResources.INSTANCE.css().ensureInjected();
        this.setElement((Element)uiBinder.createAndBindUi((Object)this));
        this.titleUi.setInnerText(entry.getTitle());
        this.messageUi.setInnerText(entry.getMessage());
        String boatClass = entry.getBoatClass();
        if (boatClass != null && !boatClass.isEmpty()) {
            this.icon.getStyle().setBackgroundImage("url(\"" + BoatClassImageResolver.getBoatClassIconResource((String)boatClass).getSafeUri().asString() + "\")");
            this.boatClassUi.setInnerText(" / " + boatClass);
        } else {
            this.boatClassUi.removeFromParent();
        }
        if (boatClass != null) {
            boatClass.isEmpty();
        }
        if ((newsTimestamp = entry.getTimestamp()) == null || currentTimestamp == null) {
            this.timestampUi.removeFromParent();
        } else {
            this.timestampUi.setInnerText(ConditionalDateTimeFormatter.format((Date)newsTimestamp, (Date)currentTimestamp, (StringMessages)StringMessages.INSTANCE));
            if (currentTimestamp.getTime() - 600000L < newsTimestamp.getTime()) {
                this.timestampUi.addClassName(UpdatesBoxResources.INSTANCE.css().updatesbox_item_live());
            }
        }
        String directLink = entry.getExternalURL();
        if (directLink != null) {
            this.link.setHref(directLink);
            this.link.setTarget("_blank");
        } else {
            AbstractRaceNewsEntryDTO raceEntry;
            PlaceNavigation placeNavigation = null;
            if (entry instanceof LeaderboardNewsEntryDTO) {
                directLink = ((LeaderboardNewsEntryDTO)entry).getExternalURL();
                placeNavigation = presenter.getRegattaLeaderboardNavigation(((LeaderboardNewsEntryDTO)entry).getLeaderboardName());
            } else if (entry instanceof AbstractRaceNewsEntryDTO && (raceEntry = (AbstractRaceNewsEntryDTO)entry).getRegattaAndRaceIdentfier() != null) {
                directLink = presenter.getRaceViewerURL(raceEntry.getLeaderboardName(), raceEntry.getLeaderboardGroupName(), raceEntry.getLeaderboardGroupId(), raceEntry.getRegattaAndRaceIdentfier());
            }
            if (placeNavigation != null) {
                this.link.setHref(placeNavigation.getTargetUrl());
                Event.sinkEvents((Element)this.link, (int)1);
                PlaceNavigation pn = placeNavigation;
                Event.setEventListener((Element)this.link, (EventListener)new /* Unavailable Anonymous Inner Class!! */);
            } else {
                this.link.removeFromParent();
                while (this.link.hasChildNodes()) {
                    Node firstChild = this.link.getChild(0);
                    firstChild.removeFromParent();
                    this.getElement().appendChild(firstChild);
                }
                this.addStyleName(UpdatesBoxResources.INSTANCE.css().updatesbox_item());
            }
        }
    }
}

