/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.home.desktop.partials.standings;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.AnchorElement;
import com.google.gwt.dom.client.DivElement;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.SpanElement;
import com.google.gwt.dom.client.Style;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.gwt.home.communication.event.LabelType;
import com.sap.sailing.gwt.home.communication.event.minileaderboard.GetMiniLeaderboardDTO;
import com.sap.sailing.gwt.home.communication.event.minileaderboard.MiniLeaderboardItemDTO;
import com.sap.sailing.gwt.home.desktop.partials.standings.StandingsList;
import com.sap.sailing.gwt.home.desktop.partials.standings.StandingsListCompetitor;
import com.sap.sailing.gwt.home.desktop.partials.standings.StandingsResources;
import com.sap.sailing.gwt.home.shared.app.PlaceNavigation;
import com.sap.sailing.gwt.home.shared.refresh.RefreshableWidget;
import com.sap.sailing.gwt.home.shared.utils.LabelTypeUtil;
import com.sap.sailing.gwt.ui.client.FlagImageResolver;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sse.gwt.client.DateAndTimeFormatterUtil;
import java.util.Date;

public class StandingsList
extends Widget
implements RefreshableWidget<GetMiniLeaderboardDTO> {
    private static MyUiBinder uiBinder = (MyUiBinder)GWT.create(MyUiBinder.class);
    private static final StringMessages i18n = StringMessages.INSTANCE;
    @UiField
    AnchorElement headerLinkUi;
    @UiField
    SpanElement headerTitleUi;
    @UiField
    SpanElement headerLabelUi;
    @UiField
    DivElement headerArrowUi;
    @UiField
    DivElement itemContainerUi;
    @UiField
    DivElement noResultsUi;
    @UiField
    DivElement scoreInformationUi;
    private final boolean finished;
    private final FlagImageResolver flagImageResolver;

    public StandingsList(boolean finished, PlaceNavigation<?> headerNavigation, FlagImageResolver flagImageResolver) {
        this.finished = finished;
        this.flagImageResolver = flagImageResolver;
        StandingsResources.INSTANCE.css().ensureInjected();
        this.setElement((Element)uiBinder.createAndBindUi((Object)this));
        this.setVisible(false);
        if (headerNavigation == null) {
            this.headerArrowUi.removeFromParent();
        } else {
            headerNavigation.configureAnchorElement(this.headerLinkUi);
        }
    }

    public void setData(GetMiniLeaderboardDTO data) {
        String headerText = this.finished ? i18n.results() : i18n.latestRegattaStandings();
        int itemCount = data.getItems().size();
        if (itemCount > 0 && data.getTotalCompetitorCount() > itemCount) {
            headerText = String.valueOf(headerText) + " (" + i18n.topN(itemCount) + ")";
        }
        this.headerTitleUi.setInnerText(headerText);
        this.itemContainerUi.removeAllChildren();
        this.scoreInformationUi.removeAllChildren();
        this.getElement().getStyle().clearDisplay();
        this.updateScoreInformation(data);
        LabelTypeUtil.renderLabelTypeOrHide((Element)this.headerLabelUi, (LabelType)(data.isLive() ? LabelType.LIVE : LabelType.NONE));
        if (data.getItems().isEmpty()) {
            this.noResultsUi.getStyle().clearDisplay();
            return;
        }
        this.noResultsUi.getStyle().setDisplay(Style.Display.NONE);
        boolean showRaceCounts = data.hasDifferentRaceCounts();
        for (MiniLeaderboardItemDTO item : data.getItems()) {
            this.itemContainerUi.appendChild((Node)new StandingsListCompetitor(item, showRaceCounts, this.flagImageResolver).getElement());
        }
    }

    private void updateScoreInformation(GetMiniLeaderboardDTO data) {
        this.scoreInformationUi.removeAllChildren();
        if (data.getItems().isEmpty() || data.getScoreCorrectionText() == null && data.getLastScoreUpdate() == null) {
            this.scoreInformationUi.getStyle().setDisplay(Style.Display.NONE);
            return;
        }
        this.scoreInformationUi.getStyle().clearDisplay();
        if (data.getScoreCorrectionText() != null) {
            DivElement scoreCorrectionText = Document.get().createDivElement();
            scoreCorrectionText.setInnerText(data.getScoreCorrectionText());
            this.scoreInformationUi.appendChild((Node)scoreCorrectionText);
        }
        if (data.getLastScoreUpdate() != null) {
            DivElement lastUpdateElement = Document.get().createDivElement();
            String lastUpdate = DateAndTimeFormatterUtil.formatLongDateAndTimeGMT((Date)data.getLastScoreUpdate());
            lastUpdateElement.setInnerText(String.valueOf(StringMessages.INSTANCE.lastScoreUpdate()) + ": " + lastUpdate);
            this.scoreInformationUi.appendChild((Node)lastUpdateElement);
        }
    }
}

