/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.home.desktop.partials.old.leaderboard;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.DivElement;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FocusWidget;
import com.google.gwt.user.client.ui.HTMLPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.domain.common.ScoringSchemeType;
import com.sap.sailing.domain.common.dto.LeaderboardDTO;
import com.sap.sailing.gwt.home.desktop.partials.old.EventRegattaLeaderboardResources;
import com.sap.sailing.gwt.home.desktop.partials.old.leaderboard.OldLeaderboard;
import com.sap.sailing.gwt.ui.client.DebugIdHelper;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.leaderboard.MultiRaceLeaderboardPanel;
import com.sap.sailing.gwt.ui.leaderboard.ScoringSchemeTypeFormatter;
import com.sap.sse.gwt.client.DateAndTimeFormatterUtil;
import com.sap.sse.gwt.client.controls.busyindicator.BusyIndicator;
import com.sap.sse.gwt.client.controls.busyindicator.BusyStateChangeListener;
import com.sap.sse.gwt.client.player.Timer;
import java.util.Date;
import java.util.Objects;

/*
 * Exception performing whole class analysis ignored.
 */
public class OldLeaderboard
extends Composite
implements BusyStateChangeListener {
    private static OldLeaderboardUiBinder uiBinder = (OldLeaderboardUiBinder)GWT.create(OldLeaderboardUiBinder.class);
    @UiField
    HTMLPanel oldLeaderboardPanel;
    @UiField
    Anchor settingsAnchor;
    @UiField
    Anchor autoRefreshAnchor;
    @UiField
    Anchor showLiveRacesAnchor;
    @UiField
    Anchor fullscreenAnchor;
    @UiField
    DivElement lastScoringUpdateTimeDiv;
    @UiField
    DivElement lastScoringUpdateTextDiv;
    @UiField
    DivElement lastScoringCommentDiv;
    @UiField
    DivElement scoringSchemeDiv;
    @UiField
    DivElement hasLiveRaceDiv;
    @UiField
    BusyIndicator busyIndicator;
    @UiField
    EventRegattaLeaderboardResources local_res;
    private final OldLeaderboardDelegate delegate;
    private MultiRaceLeaderboardPanel leaderboardPanel = null;
    private Timer autoRefreshTimer;

    public OldLeaderboard(OldLeaderboardDelegate delegate) {
        EventRegattaLeaderboardResources.INSTANCE.css().ensureInjected();
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.settingsAnchor.setTitle(StringMessages.INSTANCE.settings());
        this.autoRefreshAnchor.setTitle(StringMessages.INSTANCE.refresh());
        this.showLiveRacesAnchor.setTitle(StringMessages.INSTANCE.showLiveNow());
        this.fullscreenAnchor.setTitle(StringMessages.INSTANCE.openFullscreenView());
        this.delegate = delegate;
        this.setupFullscreenDelegate();
    }

    private void setupFullscreenDelegate() {
        if (this.delegate == null) {
            this.fullscreenAnchor.removeFromParent();
            return;
        }
        this.delegate.addCloseHandler((CloseHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.delegate.getSettingsControl().setTitle(StringMessages.INSTANCE.settings());
        this.delegate.getSettingsControl().addHandler((EventHandler)new /* Unavailable Anonymous Inner Class!! */, (GwtEvent.Type)ClickEvent.getType());
        this.delegate.getAutoRefreshControl().setTitle(StringMessages.INSTANCE.refresh());
        this.delegate.getAutoRefreshControl().addHandler((EventHandler)new /* Unavailable Anonymous Inner Class!! */, (GwtEvent.Type)ClickEvent.getType());
    }

    private void turnOnAutoPlay() {
        if (this.autoRefreshTimer.getPlayState() != Timer.PlayStates.Playing) {
            this.autoRefreshTimer.setPlayMode(Timer.PlayModes.Live);
        }
        this.updateAutoRefreshStylesDependingOnPlayState();
    }

    private void updateAutoRefreshStylesDependingOnPlayState() {
        boolean isPlaying = this.autoRefreshTimer != null && this.autoRefreshTimer.getPlayState() == Timer.PlayStates.Playing;
        String isPlayingStyleName = this.local_res.css().regattaleaderboard_meta_reload_live();
        this.autoRefreshAnchor.setStyleName(isPlayingStyleName, isPlaying);
        if (Objects.nonNull(this.delegate)) {
            this.delegate.getAutoRefreshControl().setStyleName(isPlayingStyleName, isPlaying);
        }
    }

    @UiHandler(value={"autoRefreshAnchor"})
    void toogleAutoRefreshClicked(ClickEvent event) {
        this.autoRefreshAnchor.removeStyleName(this.local_res.css().regattaleaderboard_meta_reload_live());
        this.autoRefreshAnchor.removeStyleName(this.local_res.css().regattaleaderboard_meta_reload_playing());
        if (this.delegate != null) {
            this.delegate.getAutoRefreshControl().removeStyleName(this.local_res.css().regattaleaderboard_meta_reload_live());
            this.delegate.getAutoRefreshControl().removeStyleName(this.local_res.css().regattaleaderboard_meta_reload_playing());
        }
        if (this.autoRefreshTimer != null) {
            if (this.autoRefreshTimer.getPlayState() == Timer.PlayStates.Playing) {
                this.autoRefreshTimer.pause();
            } else {
                this.autoRefreshTimer.setPlayMode(Timer.PlayModes.Live);
                this.updateAutoRefreshStylesDependingOnPlayState();
            }
        }
    }

    @UiHandler(value={"settingsAnchor"})
    void settingsClicked(ClickEvent event) {
        if (this.leaderboardPanel != null) {
            String componentName = this.leaderboardPanel.getLocalizedShortName();
            String debugIdPrefix = DebugIdHelper.createDebugId((String)componentName);
            4 dialog = new /* Unavailable Anonymous Inner Class!! */;
            dialog.ensureDebugId(String.valueOf(debugIdPrefix) + "SettingsDialog");
            dialog.show();
        }
    }

    @UiHandler(value={"fullscreenAnchor"})
    void fullscreenClicked(ClickEvent event) {
        if (this.leaderboardPanel != null && this.delegate != null) {
            this.leaderboardPanel.removeFromParent();
            this.delegate.setLeaderboardPanel((Widget)this.leaderboardPanel);
        }
    }

    public FocusWidget getShowLiveRacesControl() {
        return this.showLiveRacesAnchor;
    }

    public FocusWidget getFullscreenControl() {
        return this.fullscreenAnchor;
    }

    public void setLeaderboard(MultiRaceLeaderboardPanel leaderboardPanel, Timer timer) {
        this.autoRefreshTimer = timer;
        this.leaderboardPanel = leaderboardPanel;
        if (leaderboardPanel.getComponentContext() == null) {
            throw new IllegalStateException("Leaderboard Component with null Context");
        }
        this.updateAutoRefreshStylesDependingOnPlayState();
        this.oldLeaderboardPanel.add((Widget)leaderboardPanel);
        leaderboardPanel.addBusyStateChangeListener((BusyStateChangeListener)this);
    }

    public void updatedLeaderboard(LeaderboardDTO leaderboard) {
        boolean hasLiveRace = this.leaderboardPanel.hasLiveRace();
        if (leaderboard != null) {
            String comment = leaderboard.getComment() != null ? leaderboard.getComment() : "";
            String scoringScheme = leaderboard.scoringScheme != null ? ScoringSchemeTypeFormatter.getDescription((ScoringSchemeType)leaderboard.scoringScheme, (StringMessages)StringMessages.INSTANCE) : "";
            this.lastScoringCommentDiv.setInnerText(comment);
            this.hasLiveRaceDiv.setInnerText(this.leaderboardPanel.getLiveRacesText());
            this.scoringSchemeDiv.setInnerText(scoringScheme);
            if (this.delegate != null) {
                this.delegate.getLastScoringCommentElement().setInnerText(comment);
                this.delegate.getHasLiveRaceElement().setInnerText(this.leaderboardPanel.getLiveRacesText());
                this.delegate.getScoringSchemeElement().setInnerText(scoringScheme);
            }
            if (leaderboard.getTimePointOfLastCorrectionsValidity() != null) {
                Date lastCorrectionDate = leaderboard.getTimePointOfLastCorrectionsValidity();
                String lastUpdate = String.valueOf(DateAndTimeFormatterUtil.defaultDateFormatterUTC.render(lastCorrectionDate)) + ", " + DateAndTimeFormatterUtil.longTimeFormatterUTC.render(lastCorrectionDate);
                this.lastScoringUpdateTimeDiv.setInnerText(lastUpdate);
                this.lastScoringUpdateTextDiv.setInnerText(StringMessages.INSTANCE.eventRegattaLeaderboardLastScoreUpdate());
                if (this.delegate != null) {
                    this.delegate.getLastScoringUpdateTimeElement().setInnerText(lastUpdate);
                    this.delegate.getLastScoringUpdateTextElement().setInnerText(StringMessages.INSTANCE.eventRegattaLeaderboardLastScoreUpdate());
                }
            } else {
                this.lastScoringUpdateTimeDiv.setInnerHTML("&nbsp;");
                this.lastScoringUpdateTextDiv.setInnerHTML("&nbsp;");
            }
            OldLeaderboard.setVisible((Element)this.hasLiveRaceDiv, (boolean)hasLiveRace);
            OldLeaderboard.setVisible((Element)this.lastScoringCommentDiv, (!hasLiveRace ? 1 : 0) != 0);
            OldLeaderboard.setVisible((Element)this.lastScoringUpdateTextDiv, (!hasLiveRace ? 1 : 0) != 0);
            OldLeaderboard.setVisible((Element)this.lastScoringUpdateTimeDiv, (!hasLiveRace ? 1 : 0) != 0);
            OldLeaderboard.setVisible((Element)this.scoringSchemeDiv, (boolean)true);
            if (this.delegate != null) {
                OldLeaderboard.setVisible((Element)this.delegate.getHasLiveRaceElement(), (boolean)hasLiveRace);
                OldLeaderboard.setVisible((Element)this.delegate.getLastScoringCommentElement(), (!hasLiveRace ? 1 : 0) != 0);
                OldLeaderboard.setVisible((Element)this.delegate.getLastScoringUpdateTextElement(), (!hasLiveRace ? 1 : 0) != 0);
                OldLeaderboard.setVisible((Element)this.delegate.getLastScoringUpdateTimeElement(), (!hasLiveRace ? 1 : 0) != 0);
                OldLeaderboard.setVisible((Element)this.delegate.getScoringSchemeElement(), (boolean)true);
            }
            if (hasLiveRace) {
                this.turnOnAutoPlay();
            }
        }
    }

    public void hideRefresh() {
        this.autoRefreshAnchor.setVisible(false);
        if (this.delegate != null) {
            this.delegate.getAutoRefreshControl().setVisible(false);
        }
        this.lastScoringUpdateTimeDiv.getStyle().setVisibility(Style.Visibility.HIDDEN);
    }

    public void onBusyStateChange(boolean busyState) {
        this.busyIndicator.setBusy(busyState);
        if (this.delegate != null) {
            this.delegate.setBusyState(busyState);
        }
    }

    static /* synthetic */ MultiRaceLeaderboardPanel access$0(OldLeaderboard oldLeaderboard) {
        return oldLeaderboard.leaderboardPanel;
    }
}

