/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.home.desktop.partials.media;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.DivElement;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.ImageElement;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.HasClickHandlers;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.event.shared.HasHandlers;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.ResizeComposite;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.SelectionChangeEvent;
import com.sap.sailing.gwt.home.desktop.partials.media.SailingGalleryPlayer;
import com.sap.sailing.gwt.ui.shared.SailingImageDTO;
import com.sap.sse.common.Util;
import com.sap.sse.gwt.client.media.MediaMenuIcon;
import com.sap.sse.gwt.client.media.TakedownNoticeService;
import com.sap.sse.gwt.common.CommonSharedResources;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SailingGalleryPlayer
extends ResizeComposite
implements SelectionChangeEvent.HasSelectionChangedHandlers,
HasClickHandlers {
    private static MyBinder uiBinder = (MyBinder)GWT.create(MyBinder.class);
    @UiField
    DivElement mainSliderUi;
    @UiField
    DivElement subSliderUi;
    private boolean autoplay;
    private int selectedIdx;
    private final List<SailingImageDTO> images;

    public SailingGalleryPlayer(SailingImageDTO selected, Collection<SailingImageDTO> images, TakedownNoticeService takedownNoticeService) {
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.selectedIdx = Math.max(0, Util.indexOf(images, (Object)selected));
        this.images = new ArrayList(images.size());
        for (SailingImageDTO i : images) {
            DivElement mainImgElement = this.createMainImgElement(i);
            MediaMenuIcon mmi = new MediaMenuIcon(takedownNoticeService, "takedownRequestForEventGalleryImage");
            mmi.setFontSize("20px");
            RootPanel.get().add((Widget)mmi);
            mmi.setData(i.getEventLink().getDisplayName(), i.getSourceRef());
            mainImgElement.appendChild((Node)mmi.getElement());
            this.mainSliderUi.appendChild((Node)mainImgElement);
            this.subSliderUi.appendChild((Node)this.createThumbImgElement(i));
            this.images.add(i);
        }
    }

    public HandlerRegistration addSelectionChangeHandler(SelectionChangeEvent.Handler handler) {
        return this.addHandler((EventHandler)handler, SelectionChangeEvent.getType());
    }

    public HandlerRegistration addClickHandler(ClickHandler handler) {
        this.mainSliderUi.getStyle().setCursor(Style.Cursor.POINTER);
        return this.addHandler((EventHandler)handler, (GwtEvent.Type)ClickEvent.getType());
    }

    public SailingImageDTO getSelectedImage() {
        return (SailingImageDTO)this.images.get(this.selectedIdx);
    }

    private ImageElement createThumbImgElement(SailingImageDTO i) {
        ImageElement img = Document.get().createImageElement();
        img.setAttribute("src", i.getSourceRef());
        img.getStyle().setHeight(103.0, Style.Unit.PX);
        return img;
    }

    private DivElement createMainImgElement(SailingImageDTO i) {
        DivElement img = Document.get().createDivElement();
        img.addClassName(CommonSharedResources.INSTANCE.mainCss().media_wrapper());
        img.getStyle().setBackgroundImage("url(\"" + i.getSourceRef() + "\")");
        img.getStyle().setProperty("backgroundSize", "contain");
        img.getStyle().setProperty("backgroundRepeat", "no-repeat");
        img.getStyle().setProperty("backgroundPosition", "center");
        return img;
    }

    private void updateCurrentSlide(int currentIndex) {
        this.selectedIdx = currentIndex;
        SelectionChangeEvent.fire((SelectionChangeEvent.HasSelectionChangedHandlers)this);
    }

    private void onMainSlideClicked(NativeEvent nativeEvent) {
        ClickEvent.fireNativeEvent((NativeEvent)nativeEvent, (HasHandlers)this);
    }

    protected void onLoad() {
        this._onLoad(this);
        ((Element)this.mainSliderUi.getFirstChild().cast()).setTabIndex(0);
        this.focus();
    }

    public void onResize() {
        this.refreshSlider();
    }

    native void refreshSlider();

    native void _onLoad(SailingGalleryPlayer var1);

    private native void _slickPlay();

    private native void _slickPause();

    public void toggleAutoplay() {
        boolean bl = this.autoplay = !this.autoplay;
        if (this.autoplay) {
            this._slickPlay();
        } else {
            this._slickPause();
        }
    }

    public void focus() {
        ((Element)this.mainSliderUi.getFirstChild().cast()).focus();
    }

    protected void onUnload() {
        if (this.isAutoplaying()) {
            this.toggleAutoplay();
        }
    }

    public boolean isAutoplaying() {
        return this.autoplay;
    }
}

