/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.home.communication.user.profile.sailorprofile;

import com.google.gwt.core.shared.GwtIncompatible;
import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.CompetitorAndBoatStore;
import com.sap.sailing.domain.base.Event;
import com.sap.sailing.domain.base.EventBase;
import com.sap.sailing.domain.base.Regatta;
import com.sap.sailing.domain.leaderboard.Leaderboard;
import com.sap.sailing.domain.leaderboard.LeaderboardGroup;
import com.sap.sailing.gwt.home.communication.SailingAction;
import com.sap.sailing.gwt.home.communication.SailingDispatchContext;
import com.sap.sailing.gwt.home.communication.event.SimpleCompetitorWithIdDTO;
import com.sap.sailing.gwt.home.communication.user.profile.domain.ParticipatedEventDTO;
import com.sap.sailing.gwt.home.communication.user.profile.domain.ParticipatedRegattaDTO;
import com.sap.sailing.gwt.home.communication.user.profile.domain.SailorProfileEventsDTO;
import com.sap.sailing.gwt.home.communication.user.profile.sailorprofile.SailorProfileConverter;
import com.sap.sailing.server.preferences.SailorProfilePreference;
import com.sap.sailing.server.preferences.SailorProfilePreferences;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import com.sap.sse.gwt.dispatch.shared.exceptions.DispatchException;
import java.util.ArrayList;
import java.util.UUID;

public class GetEventsForSailorProfileAction
implements SailingAction<SailorProfileEventsDTO>,
SailorProfileConverter {
    private UUID uuid;

    public GetEventsForSailorProfileAction(UUID uuid) {
        this.uuid = uuid;
    }

    public GetEventsForSailorProfileAction() {
    }

    @GwtIncompatible
    public SailorProfileEventsDTO execute(SailingDispatchContext ctx) throws DispatchException {
        CompetitorAndBoatStore store = ctx.getRacingEventService().getCompetitorAndBoatStore();
        SailorProfilePreferences prefs = (SailorProfilePreferences)ctx.getPreferenceForCurrentUser("user.profile.sailorProfiles");
        SailorProfilePreference pref = this.findSailorProfile(store, prefs);
        ArrayList<ParticipatedEventDTO> participatedEvents = new ArrayList<ParticipatedEventDTO>();
        for (Event event : ctx.getRacingEventService().getAllEvents()) {
            ArrayList<ParticipatedRegattaDTO> participatedRegattas = new ArrayList<ParticipatedRegattaDTO>();
            for (LeaderboardGroup leaderboardGroup : event.getLeaderboardGroups()) {
                if (leaderboardGroup.hasOverallLeaderboard()) {
                    leaderboardGroup.getOverallLeaderboard();
                }
                for (Leaderboard leaderboard : leaderboardGroup.getLeaderboards()) {
                    ArrayList<Competitor> containedCompetitors = new ArrayList<Competitor>();
                    for (Competitor competitor : pref.getCompetitors()) {
                        if (leaderboard.getCompetitors() == null || !Util.contains((Iterable)leaderboard.getCompetitors(), (Object)competitor)) continue;
                        containedCompetitors.add(competitor);
                    }
                    if (containedCompetitors.size() == 0) continue;
                    for (Competitor competitor : containedCompetitors) {
                        int rank = leaderboard.getTotalRankOfCompetitor(competitor, MillisecondsTimePoint.now());
                        double points = leaderboard.getNetPoints(competitor, MillisecondsTimePoint.now());
                        String regattaName = leaderboard.getName();
                        Regatta regatta = ctx.getRacingEventService().getRegattaByName(regattaName);
                        if (regatta == null || !leaderboard.isPartOfEvent((EventBase)event) && leaderboardGroup.hasOverallLeaderboard() && !leaderboardGroup.getOverallLeaderboard().isPartOfEvent((EventBase)event)) continue;
                        participatedRegattas.add(new ParticipatedRegattaDTO(regattaName, rank, new SimpleCompetitorWithIdDTO(competitor), "" + regatta.getId(), "" + event.getId(), points));
                    }
                }
            }
            if (participatedRegattas.size() <= 0) continue;
            participatedEvents.add(new ParticipatedEventDTO(event.getName(), event.getId().toString(), participatedRegattas));
        }
        return new SailorProfileEventsDTO(participatedEvents);
    }

    @GwtIncompatible
    private SailorProfilePreference findSailorProfile(CompetitorAndBoatStore store, SailorProfilePreferences prefs) {
        if (prefs == null) {
            throw new NullPointerException("no sailor profile present");
        }
        for (SailorProfilePreference p : prefs.getSailorProfiles()) {
            if (!p.getUuid().equals(this.uuid)) continue;
            return p;
        }
        return null;
    }
}

