/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.home.communication.user.profile;

import com.google.gwt.core.shared.GwtIncompatible;
import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.CompetitorAndBoatStore;
import com.sap.sailing.domain.base.impl.DynamicCompetitor;
import com.sap.sailing.domain.common.dto.BoatClassDTO;
import com.sap.sailing.gwt.home.communication.SailingAction;
import com.sap.sailing.gwt.home.communication.SailingDispatchContext;
import com.sap.sailing.gwt.home.communication.event.SimpleCompetitorWithIdDTO;
import com.sap.sailing.gwt.home.communication.user.profile.FavoriteBoatClassesDTO;
import com.sap.sailing.gwt.home.communication.user.profile.FavoriteCompetitorsDTO;
import com.sap.sailing.gwt.home.communication.user.profile.FavoritesResult;
import com.sap.sailing.server.impl.preferences.model.BoatClassNotificationPreference;
import com.sap.sailing.server.impl.preferences.model.BoatClassNotificationPreferences;
import com.sap.sailing.server.impl.preferences.model.CompetitorNotificationPreference;
import com.sap.sailing.server.impl.preferences.model.CompetitorNotificationPreferences;
import com.sap.sailing.server.interfaces.RacingEventService;
import com.sap.sse.gwt.dispatch.shared.exceptions.DispatchException;
import java.util.TreeSet;

public class GetFavoritesAction
implements SailingAction<FavoritesResult> {
    @GwtIncompatible
    public FavoritesResult execute(SailingDispatchContext ctx) throws DispatchException {
        return new FavoritesResult(this.getFavoriteBoatClasses(ctx), this.getFavoriteCompetitors(ctx));
    }

    @GwtIncompatible
    private FavoriteBoatClassesDTO getFavoriteBoatClasses(SailingDispatchContext ctx) {
        BoatClassNotificationPreferences preferences = (BoatClassNotificationPreferences)ctx.getPreferenceForCurrentUser("sailing.notifications.boatclasses");
        TreeSet<BoatClassDTO> selected = new TreeSet<BoatClassDTO>();
        boolean notifyAboutUpcomingRaces = false;
        boolean notifyAboutResults = false;
        if (preferences != null) {
            for (BoatClassNotificationPreference pref : preferences.getBoatClasses()) {
                String name = pref.getBoatClass().getName();
                selected.add(new BoatClassDTO(name, pref.getBoatClass().getHullLength(), pref.getBoatClass().getHullBeam()));
                notifyAboutUpcomingRaces |= pref.isNotifyAboutUpcomingRaces();
                notifyAboutResults |= pref.isNotifyAboutResults();
            }
        }
        return new FavoriteBoatClassesDTO(selected, notifyAboutUpcomingRaces, notifyAboutResults);
    }

    @GwtIncompatible
    private FavoriteCompetitorsDTO getFavoriteCompetitors(SailingDispatchContext ctx) {
        CompetitorNotificationPreferences preferences = (CompetitorNotificationPreferences)ctx.getPreferenceForCurrentUser("sailing.notifications.competitors");
        TreeSet<SimpleCompetitorWithIdDTO> selected = new TreeSet<SimpleCompetitorWithIdDTO>();
        boolean notifyAboutResults = false;
        if (preferences != null) {
            RacingEventService racingEventService = ctx.getRacingEventService();
            CompetitorAndBoatStore competitorAndBoatStore = racingEventService.getCompetitorAndBoatStore();
            for (CompetitorNotificationPreference pref : preferences.getCompetitors()) {
                SimpleCompetitorWithIdDTO competitorDTO;
                String competitorId = pref.getCompetitorIdAsString();
                DynamicCompetitor competitor = competitorAndBoatStore.getExistingCompetitorByIdAsString(competitorId);
                if (competitor == null) {
                    String competitorName = pref.getCompetitorName();
                    String conveyedCompetitorName = competitorName == null ? "Not found." : competitorName;
                    competitorDTO = new SimpleCompetitorWithIdDTO(competitorId, conveyedCompetitorName, "Unknown", null, null);
                } else {
                    competitorDTO = new SimpleCompetitorWithIdDTO((Competitor)competitor);
                }
                selected.add(competitorDTO);
                notifyAboutResults |= pref.isNotifyAboutResults();
            }
        }
        FavoriteCompetitorsDTO favoriteCompetitorsDTO = new FavoriteCompetitorsDTO(selected, notifyAboutResults);
        return favoriteCompetitorsDTO;
    }
}

