/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.home.communication.start;

import com.google.gwt.core.shared.GwtIncompatible;
import com.sap.sailing.domain.base.EventBase;
import com.sap.sailing.gwt.home.communication.SailingAction;
import com.sap.sailing.gwt.home.communication.SailingDispatchContext;
import com.sap.sailing.gwt.home.communication.start.StageEventType;
import com.sap.sailing.gwt.home.communication.start.StartViewDTO;
import com.sap.sailing.gwt.server.EventHolder;
import com.sap.sailing.gwt.server.EventStageCandidateCalculator;
import com.sap.sailing.gwt.server.HomeServiceUtil;
import com.sap.sailing.gwt.server.RecentEventsCalculator;
import com.sap.sailing.gwt.ui.client.shared.SailingVideoDTO;
import com.sap.sailing.gwt.ui.shared.EventLinkDTO;
import com.sap.sailing.gwt.ui.shared.EventReferenceDTO;
import com.sap.sailing.gwt.ui.shared.SailingImageDTO;
import com.sap.sailing.server.interfaces.RacingEventService;
import com.sap.sse.common.Util;
import com.sap.sse.common.media.MediaTagConstants;
import com.sap.sse.common.media.MimeType;
import com.sap.sse.gwt.dispatch.shared.caching.IsClientCacheable;
import com.sap.sse.security.SecurityService;
import com.sap.sse.shared.media.ImageDescriptor;
import com.sap.sse.shared.media.VideoDescriptor;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;
import javax.servlet.http.HttpServletRequest;

public class GetStartViewAction
implements SailingAction<StartViewDTO>,
IsClientCacheable {
    private static final int MAX_RECENT_EVENTS = 3;
    private static final int MAX_VIDEO_COUNT = 3;
    private static final int MAX_IMAGE_COUNT = 100;

    @GwtIncompatible
    public StartViewDTO execute(SailingDispatchContext context) {
        EventStageCandidateCalculator stageCandidateCalculator = new EventStageCandidateCalculator();
        RecentEventsCalculator recentEventsCalculator = new RecentEventsCalculator();
        HomeServiceUtil.forAllPublicEventsWithReadPermission((RacingEventService)context.getRacingEventService(), (HttpServletRequest)context.getRequest(), (SecurityService)context.getSecurityService(), (HomeServiceUtil.EventVisitor[])new HomeServiceUtil.EventVisitor[]{stageCandidateCalculator, recentEventsCalculator});
        StartViewDTO result = new StartViewDTO();
        int count = 0;
        for (Util.Pair pair : stageCandidateCalculator.getFeaturedEvents()) {
            VideoDescriptor youTubeRandomUrl;
            MimeType type;
            StageEventType stageType = (StageEventType)pair.getA();
            EventHolder holder = (EventHolder)pair.getB();
            if (++count > 5 && stageType != StageEventType.RUNNING) break;
            result.addStageEvent(HomeServiceUtil.convertToEventStageDTO((EventBase)holder.event, (URL)holder.baseURL, (boolean)holder.onRemoteServer, (StageEventType)stageType, (RacingEventService)context.getRacingEventService(), (boolean)false));
            EventReferenceDTO eventRef = new EventReferenceDTO(holder.event);
            Iterable videosOfEvent = holder.event.getVideos();
            if (Util.isEmpty((Iterable)videosOfEvent) || result.getVideos().size() >= 3 || !MediaTagConstants.SUPPORTED_VIDEO_TYPES.contains(type = (youTubeRandomUrl = HomeServiceUtil.getRandomVideo((Iterable)videosOfEvent)).getMimeType())) continue;
            SailingVideoDTO candidate = new SailingVideoDTO(eventRef, youTubeRandomUrl.getURL().toString(), type, youTubeRandomUrl.getCreatedAtDate().asDate());
            candidate.setTitle(holder.event.getName());
            result.addVideo(candidate);
        }
        HashSet<SailingImageDTO> photoGalleryUrls = new HashSet<SailingImageDTO>();
        ArrayList<SailingVideoDTO> videoCandidates = new ArrayList<SailingVideoDTO>();
        for (EventHolder holder : recentEventsCalculator.getEventsNewestFirst()) {
            if (result.getRecentEvents().size() < 3) {
                result.addRecentEvent(HomeServiceUtil.convertToEventListDTO((EventBase)holder.event, (URL)holder.baseURL, (boolean)holder.onRemoteServer));
            }
            EventBase event = holder.event;
            EventLinkDTO eventLink = HomeServiceUtil.convertToEventLinkDTO((EventBase)holder.event, (URL)holder.baseURL, (boolean)holder.onRemoteServer);
            EventReferenceDTO eventRef = new EventReferenceDTO(holder.event);
            for (ImageDescriptor url : HomeServiceUtil.getSailingLovesPhotographyImages((EventBase)event)) {
                if (!url.hasSize()) continue;
                SailingImageDTO sailingImageDTO = new SailingImageDTO(eventLink, url.getURL().toString(), null);
                sailingImageDTO.setSizeInPx(url.getWidthInPx(), url.getHeightInPx());
                photoGalleryUrls.add(sailingImageDTO);
            }
            for (VideoDescriptor videoUrl : event.getVideos()) {
                MimeType type = videoUrl.getMimeType();
                if (!MediaTagConstants.SUPPORTED_VIDEO_TYPES.contains(type)) continue;
                SailingVideoDTO candidate = new SailingVideoDTO(eventRef, videoUrl.getURL().toString(), type, videoUrl.getCreatedAtDate().asDate());
                candidate.setTitle(holder.event.getName());
                videoCandidates.add(candidate);
            }
        }
        int numberOfCandidatesAvailable = videoCandidates.size();
        if (numberOfCandidatesAvailable <= 3 - result.getVideos().size()) {
            for (SailingVideoDTO video : videoCandidates) {
                result.addVideo(video);
            }
        } else {
            Random videosRandomizer = new Random(numberOfCandidatesAvailable);
            int i = 0;
            while (i < numberOfCandidatesAvailable) {
                int nextVideoindex = videosRandomizer.nextInt(numberOfCandidatesAvailable);
                SailingVideoDTO video = (SailingVideoDTO)videoCandidates.get(nextVideoindex);
                result.addVideo(video);
                if (result.getVideos().size() != 3) {
                    ++i;
                    continue;
                }
                break;
            }
        }
        Iterator i = photoGalleryUrls.iterator();
        int photoCount = 0;
        while (i.hasNext() && photoCount++ < 100) {
            result.addPhoto((SailingImageDTO)i.next());
        }
        return result;
    }

    public void cacheInstanceKey(StringBuilder key) {
    }
}

