/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.home.communication.event.news;

import com.google.gwt.core.shared.GwtIncompatible;
import com.sap.sailing.domain.base.Event;
import com.sap.sailing.gwt.home.communication.SailingAction;
import com.sap.sailing.gwt.home.communication.SailingDispatchContext;
import com.sap.sailing.gwt.home.communication.event.news.InfoNewsEntryDTO;
import com.sap.sailing.gwt.home.communication.event.news.LeaderboardNewsEntryDTO;
import com.sap.sailing.gwt.home.communication.event.news.NewsEntryDTO;
import com.sap.sailing.gwt.home.server.EventActionUtil;
import com.sap.sailing.news.EventNewsItem;
import com.sap.sailing.news.impl.InfoEventNewsItem;
import com.sap.sailing.news.impl.LeaderboardUpdateNewsItem;
import com.sap.sse.gwt.dispatch.shared.caching.IsClientCacheable;
import com.sap.sse.gwt.dispatch.shared.commands.ListResult;
import com.sap.sse.gwt.dispatch.shared.commands.ResultWithTTL;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class GetEventOverviewNewsAction
implements SailingAction<ResultWithTTL<ListResult<NewsEntryDTO>>>,
IsClientCacheable {
    private UUID eventId;
    private int limit = 0;

    private GetEventOverviewNewsAction() {
    }

    public GetEventOverviewNewsAction(UUID eventId) {
        this.eventId = eventId;
    }

    public GetEventOverviewNewsAction(UUID eventId, int limit) {
        this.eventId = eventId;
        this.limit = limit;
    }

    @GwtIncompatible
    public ResultWithTTL<ListResult<NewsEntryDTO>> execute(SailingDispatchContext context) {
        return EventActionUtil.withLiveRaceOrDefaultScheduleWithReadPermissions((SailingDispatchContext)context, (UUID)this.eventId, (EventActionUtil.CalculationWithEvent)new /* Unavailable Anonymous Inner Class!! */);
    }

    @GwtIncompatible
    private List<NewsEntryDTO> getNews(SailingDispatchContext dispatchContext, Event event) {
        List newsItems = dispatchContext.getEventNewsService().getNews(event);
        if (this.limit > 0 && newsItems.size() > this.limit) {
            newsItems = newsItems.subList(0, this.limit);
        }
        ArrayList<NewsEntryDTO> news = new ArrayList<NewsEntryDTO>(newsItems.size());
        for (EventNewsItem newsItem : newsItems) {
            if (newsItem instanceof InfoEventNewsItem) {
                news.add((NewsEntryDTO)new InfoNewsEntryDTO((InfoEventNewsItem)newsItem, dispatchContext.getClientLocale()));
            }
            if (!(newsItem instanceof LeaderboardUpdateNewsItem)) continue;
            news.add((NewsEntryDTO)new LeaderboardNewsEntryDTO((LeaderboardUpdateNewsItem)newsItem));
        }
        return news;
    }

    public void cacheInstanceKey(StringBuilder key) {
        key.append(this.eventId).append("_").append(this.limit);
    }

    static /* synthetic */ List access$2(GetEventOverviewNewsAction getEventOverviewNewsAction, SailingDispatchContext sailingDispatchContext, Event event) {
        return getEventOverviewNewsAction.getNews(sailingDispatchContext, event);
    }
}

