/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.common.client.controls.tabbar;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.place.shared.Place;
import com.google.gwt.place.shared.PlaceHistoryMapper;
import com.google.gwt.uibinder.client.UiChild;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.ui.AcceptsOneWidget;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.gwt.common.client.controls.tabbar.TabBar;
import com.sap.sailing.gwt.common.client.controls.tabbar.TabPanel;
import com.sap.sailing.gwt.common.client.controls.tabbar.TabPanelPlaceSelectionEvent;
import com.sap.sailing.gwt.common.client.controls.tabbar.TabView;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TabPanel<PLACE extends Place, PRESENTER, TABVIEW extends TabView<PLACE, PRESENTER>>
extends Composite {
    private static final Logger logger = Logger.getLogger(TabPanel.class.getName());
    private static TabPanelUiBinder ourUiBinder = (TabPanelUiBinder)GWT.create(TabPanelUiBinder.class);
    private final Map<Class<PLACE>, TABVIEW> knownTabs = new LinkedHashMap();
    private final Map<Class<PLACE>, String> knownTabTitles = new HashMap();
    @UiField
    SimplePanel additionalHeader;
    @UiField
    SimplePanel tabContentPanelUi;
    @UiField
    TabBar<Class<?>> tabBar;
    @UiField
    FlowPanel tabExtension;
    private TABVIEW currentTab;
    private final PlaceHistoryMapper historyMapper;
    private final PRESENTER presenter;

    public TabPanel(PRESENTER presenter, PlaceHistoryMapper historyMapper) {
        this.presenter = presenter;
        this.historyMapper = historyMapper;
        this.initWidget((Widget)ourUiBinder.createAndBindUi((Object)this));
    }

    public TABVIEW getCurrentTab() {
        return (TABVIEW)this.currentTab;
    }

    @UiChild(limit=1)
    public void addHeader(Widget widget) {
        this.additionalHeader.setWidget(widget);
    }

    @UiChild
    public void addTabContent(TABVIEW tab, String title) {
        GWT.log((String)("Adding TAB: " + title));
        tab.setPresenter(this.presenter);
        Class classForActivation = tab.getPlaceClassForActivation();
        this.knownTabs.put(classForActivation, tab);
        this.knownTabTitles.put(classForActivation, title);
        if (tab.getState() == TabView.State.VISIBLE) {
            String link = "#" + this.historyMapper.getToken(tab.placeToFire());
            this.tabBar.addTab(title, (Object)classForActivation, link);
        }
    }

    @UiHandler(value={"tabBar"})
    void onTabSelection(SelectionEvent<Class<?>> event) {
        TabView selectedTabActivity = (TabView)this.knownTabs.get(event.getSelectedItem());
        if (selectedTabActivity != null) {
            GWT.log((String)("Tab selection: " + selectedTabActivity.getPlaceClassForActivation().getName()));
            if (this.currentTab != null) {
                this.currentTab.stop();
            }
            this.fireEvent((GwtEvent)new TabPanelPlaceSelectionEvent(selectedTabActivity));
        }
    }

    public void activatePlace(PLACE placeToGo) {
        if (this.knownTabs.containsKey(placeToGo.getClass())) {
            TabView newTab = (TabView)this.knownTabs.get(placeToGo.getClass());
            if (newTab.getState() == TabView.State.NOT_AVAILABLE_REDIRECT || newTab.getState() == TabView.State.NOT_AVAILABLE_SHOW_NEXT_AVAILABLE) {
                for (TabView tab : this.knownTabs.values()) {
                    if (tab.getState() != TabView.State.VISIBLE) continue;
                    if (this.currentTab != null) {
                        this.currentTab.stop();
                    }
                    if (newTab.getState() == TabView.State.NOT_AVAILABLE_REDIRECT) {
                        this.fireEvent((GwtEvent)new TabPanelPlaceSelectionEvent(tab));
                    } else {
                        this.activatePlace(tab.placeToFire());
                    }
                    return;
                }
            }
            try {
                newTab.start(placeToGo, (AcceptsOneWidget)this.tabContentPanelUi);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Error while initializing Tab for place " + placeToGo.getClass().getName(), e);
            }
            Class<?> placeClass = placeToGo.getClass();
            this.tabBar.select(placeClass);
            this.currentTab = newTab;
        }
    }

    public void overrideCurrentContentInTab(IsWidget widget) {
        this.tabContentPanelUi.setWidget(widget);
    }

    public HandlerRegistration addTabPanelPlaceSelectionEventHandler(TabPanelPlaceSelectionEvent.Handler handler) {
        return this.addHandler((EventHandler)handler, TabPanelPlaceSelectionEvent.TYPE);
    }

    public String getCurrentTabTitle() {
        if (this.currentTab == null) {
            return null;
        }
        return (String)this.knownTabTitles.get(this.currentTab.getPlaceClassForActivation());
    }

    @UiChild
    public void addTabExtension(IsWidget widget) {
        this.tabExtension.add(widget);
    }
}

