/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.common.client;

import com.sap.sailing.domain.base.Event;
import com.sap.sailing.domain.common.windfinder.SpotBase;
import com.sap.sailing.domain.common.windfinder.SpotDTO;
import com.sap.sailing.domain.windfinder.Spot;
import com.sap.sailing.domain.windfinder.WindFinderTrackerFactory;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.concurrent.ExecutionException;
import java.util.logging.Logger;
import org.json.simple.parser.ParseException;

public class EventWindFinderUtil {
    private static final Logger logger = Logger.getLogger(EventWindFinderUtil.class.getName());

    public Iterable<SpotDTO> getWindFinderSpotsToConsider(Event event, WindFinderTrackerFactory windFinderTrackerFactory, boolean useCachedSpotsForTrackedRaces) {
        LinkedHashSet<SpotDTO> windFinderSpots = new LinkedHashSet<SpotDTO>();
        for (String spotsCollectionId : event.getWindFinderReviewedSpotsCollectionIds()) {
            try {
                for (Spot spot : windFinderTrackerFactory.getReviewedSpotsCollectionById(spotsCollectionId, true).getSpots(true)) {
                    windFinderSpots.add(new SpotDTO((SpotBase)spot));
                }
            }
            catch (IOException | InterruptedException | ExecutionException | ParseException e) {
                logger.warning("Unable to determine WindFinder spots for reviewed spot collection with ID " + spotsCollectionId);
            }
        }
        for (String spotIdFromTrackedRace : event.getAllFinderSpotIdsUsedByTrackedRacesInEvent()) {
            try {
                Spot spotById = windFinderTrackerFactory.getSpotById(spotIdFromTrackedRace, true);
                if (spotById != null) {
                    windFinderSpots.add(new SpotDTO((SpotBase)spotById));
                    continue;
                }
                logger.warning("Couldn't find WindFinder spot with ID " + spotIdFromTrackedRace);
            }
            catch (IOException | InterruptedException | ExecutionException | ParseException e) {
                logger.warning("Unable to determine WindFinder spot with ID " + spotIdFromTrackedRace);
            }
        }
        return windFinderSpots;
    }
}

