/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.autoplay.client.utils;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.web.bindery.event.shared.EventBus;
import com.sap.sailing.domain.common.RaceIdentifier;
import com.sap.sailing.domain.common.RegattaAndRaceIdentifier;
import com.sap.sailing.domain.common.dto.AbstractLeaderboardDTO;
import com.sap.sailing.domain.common.dto.BoatDTO;
import com.sap.sailing.domain.common.dto.CompetitorDTO;
import com.sap.sailing.domain.common.dto.FleetDTO;
import com.sap.sailing.domain.common.dto.RaceColumnDTO;
import com.sap.sailing.gwt.autoplay.client.utils.AutoplayHelper;
import com.sap.sailing.gwt.home.communication.SailingDispatchSystem;
import com.sap.sailing.gwt.ui.client.RaceTimesInfoProvider;
import com.sap.sailing.gwt.ui.client.RaceTimesInfoProviderListener;
import com.sap.sailing.gwt.ui.client.SailingServiceAsync;
import com.sap.sailing.gwt.ui.client.shared.racemap.RaceMapResources;
import com.sap.sailing.gwt.ui.raceboard.AbstractQuickFlagDataProvider;
import com.sap.sailing.gwt.ui.shared.EventDTO;
import com.sap.sailing.gwt.ui.shared.LeaderboardGroupDTO;
import com.sap.sailing.gwt.ui.shared.RaceTimesInfoDTO;
import com.sap.sailing.gwt.ui.shared.StrippedLeaderboardDTO;
import com.sap.sse.common.Util;
import com.sap.sse.gwt.client.ErrorReporter;
import com.sap.sse.gwt.client.async.AsyncActionsExecutor;
import com.sap.sse.gwt.client.player.Timer;
import com.sap.sse.security.ui.client.UserService;
import com.sap.sse.security.ui.client.subscription.SubscriptionServiceFactory;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Logger;

/*
 * Exception performing whole class analysis ignored.
 */
public class AutoplayHelper {
    private static final Logger LOGGER = Logger.getLogger(AutoplayHelper.class.getName());
    private static final RaceMapResources raceMapResources = (RaceMapResources)GWT.create(RaceMapResources.class);
    private static Timer fastCurrentTimeProvider = new Timer(Timer.PlayModes.Live, 1000L);
    private static Date startOfLiveRace;
    public static final AsyncActionsExecutor asyncActionsExecutor;
    private static final long NEGATIVE_SANITY_CHECK = -86400000L;

    static {
        asyncActionsExecutor = new AsyncActionsExecutor();
    }

    public static long durationOfCurrentLiveRaceRunning() {
        if (startOfLiveRace != null) {
            return fastCurrentTimeProvider.getLiveTimePointInMillis() - startOfLiveRace.getTime();
        }
        return 0L;
    }

    public static void getLiveRace(SailingServiceAsync sailingService, ErrorReporter errorReporter, EventDTO event, String leaderBoardName, SailingDispatchSystem dispatch, long waitTimeAfterRaceEndInMillis, long switchBeforeRaceStartInMillis, AsyncCallback<Util.Pair<Long, RegattaAndRaceIdentifier>> callback) {
        if (fastCurrentTimeProvider.getRefreshInterval() != 1000L) {
            fastCurrentTimeProvider.setRefreshInterval(1000L);
        }
        RaceTimesInfoProvider raceTimesInfoProvider = new RaceTimesInfoProvider(sailingService, asyncActionsExecutor, errorReporter, new ArrayList(), 10000L);
        StrippedLeaderboardDTO selectedLeaderboard = AutoplayHelper.getSelectedLeaderboard((EventDTO)event, (String)leaderBoardName);
        if (selectedLeaderboard != null) {
            for (RaceColumnDTO race : selectedLeaderboard.getRaceList()) {
                for (FleetDTO fleet : race.getFleets()) {
                    RegattaAndRaceIdentifier raceIdentifier = race.getRaceIdentifier(fleet);
                    if (raceIdentifier == null || raceTimesInfoProvider.containsRaceIdentifier((RaceIdentifier)raceIdentifier)) continue;
                    raceTimesInfoProvider.addRaceIdentifier(raceIdentifier, false);
                }
            }
        }
        if (raceTimesInfoProvider.getRaceIdentifiers().isEmpty()) {
            LOGGER.warning("No raceidentifier was found. Can not determine current live race. Check event configuration in case you expect a race to be in live state.");
            callback.onSuccess(null);
        }
        raceTimesInfoProvider.addRaceTimesInfoProviderListener((RaceTimesInfoProviderListener)new /* Unavailable Anonymous Inner Class!! */);
        raceTimesInfoProvider.forceTimesInfosUpdate();
    }

    public static StrippedLeaderboardDTO getSelectedLeaderboard(EventDTO event, String leaderBoardName) {
        for (LeaderboardGroupDTO leaderboardGroup : event.getLeaderboardGroups()) {
            for (StrippedLeaderboardDTO leaderboard : leaderboardGroup.getLeaderboards()) {
                if (!leaderboard.getName().equals(leaderBoardName)) continue;
                return leaderboard;
            }
        }
        return null;
    }

    public static Util.Pair<Long, RegattaAndRaceIdentifier> checkForLiveRace(AbstractLeaderboardDTO currentLeaderboard, Date serverTimeDuringRequest, RaceTimesInfoProvider raceTimesInfoProvider, long waitTimeAfterRaceEndInMillis, long switchBeforeRaceStartInMillis) {
        Map raceTimesInfos = raceTimesInfoProvider.getRaceTimesInfos();
        for (RaceColumnDTO race : currentLeaderboard.getRaceList()) {
            for (FleetDTO fleet : race.getFleets()) {
                long startTimeInMs;
                long startIn;
                boolean raceHasNotEndedOrOnlyRecentlyEnded;
                RegattaAndRaceIdentifier raceIdentifier = race.getRaceIdentifier(fleet);
                if (raceIdentifier == null) continue;
                RaceTimesInfoDTO raceTimes = (RaceTimesInfoDTO)raceTimesInfos.get(raceIdentifier);
                boolean notNullInRequiredValues = raceTimes != null && raceTimes.startOfTracking != null && raceTimes.getStartOfRace() != null;
                Date endTime = raceTimes.getFinishedTime() != null ? raceTimes.getFinishedTime() : raceTimes.getEndOfRace();
                boolean bl = raceHasNotEndedOrOnlyRecentlyEnded = endTime == null || serverTimeDuringRequest.getTime() - raceTimes.delayToLiveInMs < endTime.getTime() + waitTimeAfterRaceEndInMillis;
                if (!notNullInRequiredValues || !raceHasNotEndedOrOnlyRecentlyEnded || (startIn = (startTimeInMs = raceTimes.getStartOfRace().getTime()) - serverTimeDuringRequest.getTime() - raceTimes.delayToLiveInMs) > switchBeforeRaceStartInMillis || startIn <= -86400000L) continue;
                startOfLiveRace = raceTimes.getStartOfRace();
                return new Util.Pair((Object)startIn, (Object)raceIdentifier);
            }
        }
        startOfLiveRace = null;
        return null;
    }

    public static void create(SailingServiceAsync sailingService, UserService userService, ErrorReporter errorReporter, String leaderBoardName, UUID eventId, EventDTO event, EventBus eventBus, SailingDispatchSystem sailingDispatchSystem, RegattaAndRaceIdentifier regattaAndRaceIdentifier, AsyncCallback<RVWrapper> callback, SubscriptionServiceFactory subscriptionServiceFactory) {
        LOGGER.info("Creating map for " + regattaAndRaceIdentifier);
        Timer creationTimer = new Timer(Timer.PlayModes.Live, 1000L);
        creationTimer.setLivePlayDelayInMillis(1000L);
        creationTimer.setRefreshInterval(1000L);
        StrippedLeaderboardDTO selectedLeaderboard = AutoplayHelper.getSelectedLeaderboard((EventDTO)event, (String)leaderBoardName);
        sailingService.getCompetitorsOfLeaderboard(leaderBoardName, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected static void continouslyLoadRaceTimeData(AbstractLeaderboardDTO selectedLeaderboard, RaceTimesInfoProviderListener callback, RaceTimesInfoProvider raceTimesInfoProvider) {
        for (RaceColumnDTO race : selectedLeaderboard.getRaceList()) {
            for (FleetDTO fleet : race.getFleets()) {
                RegattaAndRaceIdentifier raceIdentifier = race.getRaceIdentifier(fleet);
                if (raceIdentifier == null || raceTimesInfoProvider.containsRaceIdentifier((RaceIdentifier)raceIdentifier)) continue;
                raceTimesInfoProvider.addRaceIdentifier(raceIdentifier, false);
            }
        }
        raceTimesInfoProvider.addRaceTimesInfoProviderListener((RaceTimesInfoProviderListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    private static void createRaceMapIfNotExist(RegattaAndRaceIdentifier currentLiveRace, StrippedLeaderboardDTO selectedLeaderboard, Map<CompetitorDTO, BoatDTO> competitorsAndTheirBoats, Iterable<CompetitorDTO> competitors, SailingServiceAsync sailingService, UserService userService, AsyncActionsExecutor asyncActionsExecutor, ErrorReporter errorReporter, Timer raceboardTimer, AsyncCallback<RVWrapper> callback, long clientTimeWhenResponseWasReceived, Date serverTimeDuringRequest, long clientTimeWhenRequestWasSent, Map<RegattaAndRaceIdentifier, RaceTimesInfoDTO> raceTimesInfos, RaceTimesInfoProvider creationTimeProvider, AbstractQuickFlagDataProvider provider, SubscriptionServiceFactory subscriptionServiceFactory) {
        userService.createEssentialSecuredDTOByIdAndType(currentLiveRace.getPermissionType(), currentLiveRace.getName(), currentLiveRace.getTypeRelativeObjectIdentifier(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    static /* synthetic */ Timer access$0() {
        return fastCurrentTimeProvider;
    }

    static /* synthetic */ void access$1(RegattaAndRaceIdentifier regattaAndRaceIdentifier, StrippedLeaderboardDTO strippedLeaderboardDTO, Map map, Iterable iterable, SailingServiceAsync sailingServiceAsync, UserService userService, AsyncActionsExecutor asyncActionsExecutor, ErrorReporter errorReporter, Timer timer, AsyncCallback asyncCallback, long l, Date date, long l2, Map map2, RaceTimesInfoProvider raceTimesInfoProvider, AbstractQuickFlagDataProvider abstractQuickFlagDataProvider, SubscriptionServiceFactory subscriptionServiceFactory) {
        AutoplayHelper.createRaceMapIfNotExist((RegattaAndRaceIdentifier)regattaAndRaceIdentifier, (StrippedLeaderboardDTO)strippedLeaderboardDTO, (Map)map, (Iterable)iterable, (SailingServiceAsync)sailingServiceAsync, (UserService)userService, (AsyncActionsExecutor)asyncActionsExecutor, (ErrorReporter)errorReporter, (Timer)timer, (AsyncCallback)asyncCallback, (long)l, (Date)date, (long)l2, (Map)map2, (RaceTimesInfoProvider)raceTimesInfoProvider, (AbstractQuickFlagDataProvider)abstractQuickFlagDataProvider, (SubscriptionServiceFactory)subscriptionServiceFactory);
    }

    static /* synthetic */ RaceMapResources access$2() {
        return raceMapResources;
    }

    static /* synthetic */ Logger access$3() {
        return LOGGER;
    }
}

