/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.autoplay.client.shared.oldleaderboard;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.DivElement;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTMLPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.domain.common.RaceIdentifier;
import com.sap.sailing.domain.common.ScoringSchemeType;
import com.sap.sailing.domain.common.dto.LeaderboardDTO;
import com.sap.sailing.domain.common.dto.RaceColumnDTO;
import com.sap.sailing.gwt.autoplay.client.shared.oldleaderboard.OldLeaderboard;
import com.sap.sailing.gwt.autoplay.client.shared.oldleaderboard.OldLeaderboardResources;
import com.sap.sailing.gwt.ui.client.LeaderboardUpdateListener;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.leaderboard.MultiRaceLeaderboardPanel;
import com.sap.sailing.gwt.ui.leaderboard.ScoringSchemeTypeFormatter;
import com.sap.sse.gwt.client.DateAndTimeFormatterUtil;
import java.util.Date;

public class OldLeaderboard
extends Composite
implements LeaderboardUpdateListener {
    private static LeaderboardUiBinder uiBinder = (LeaderboardUiBinder)GWT.create(LeaderboardUiBinder.class);
    @UiField
    HTMLPanel oldLeaderboardPanel;
    @UiField
    HTMLPanel contentPanel;
    @UiField
    DivElement lastScoringUpdateTimeDiv;
    @UiField
    DivElement lastScoringUpdateTextDiv;
    @UiField
    DivElement lastScoringCommentDiv;
    @UiField
    DivElement scoringSchemeDiv;
    private MultiRaceLeaderboardPanel leaderboardPanel;
    private final StringMessages stringmessages;

    public OldLeaderboard(MultiRaceLeaderboardPanel leaderboardPanel, StringMessages stringmessages) {
        this.stringmessages = stringmessages;
        this.leaderboardPanel = leaderboardPanel;
        OldLeaderboardResources.INSTANCE.css().ensureInjected();
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.oldLeaderboardPanel.add((Widget)this.leaderboardPanel);
    }

    public Widget getContentWidget() {
        return this.contentPanel;
    }

    public void updatedLeaderboard(LeaderboardDTO leaderboard) {
        if (leaderboard != null) {
            this.lastScoringCommentDiv.setInnerText(leaderboard.getComment() != null ? leaderboard.getComment() : "");
            this.scoringSchemeDiv.setInnerText(leaderboard.scoringScheme != null ? ScoringSchemeTypeFormatter.getDescription((ScoringSchemeType)leaderboard.scoringScheme, (StringMessages)this.stringmessages) : "");
            if (leaderboard.getTimePointOfLastCorrectionsValidity() != null) {
                Date lastCorrectionDate = leaderboard.getTimePointOfLastCorrectionsValidity();
                String lastUpdate = String.valueOf(DateAndTimeFormatterUtil.defaultDateFormatterUTC.render(lastCorrectionDate)) + ", " + DateAndTimeFormatterUtil.longTimeFormatterUTC.render(lastCorrectionDate);
                this.lastScoringUpdateTimeDiv.setInnerText(lastUpdate);
                this.lastScoringUpdateTextDiv.setInnerText(this.stringmessages.eventRegattaLeaderboardLastScoreUpdate());
            } else {
                this.lastScoringUpdateTimeDiv.setInnerText("");
                this.lastScoringUpdateTextDiv.setInnerText("");
            }
        }
    }

    public void currentRaceSelected(RaceIdentifier raceIdentifier, RaceColumnDTO raceColumn) {
    }
}

