/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.autoplay.client.places.screens.preliveraceloop.racemap;

import com.google.gwt.core.client.GWT;
import com.google.gwt.i18n.client.NumberFormat;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.AcceptsOneWidget;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ResizeComposite;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.domain.common.RegattaAndRaceIdentifier;
import com.sap.sailing.gwt.autoplay.client.places.screens.preliveraceloop.racemap.PreRaceRacemapPresenterImpl;
import com.sap.sailing.gwt.autoplay.client.places.screens.preliveraceloop.racemap.PreRaceRacemapView;
import com.sap.sailing.gwt.autoplay.client.places.screens.preliveraceloop.racemap.PreRaceRacemapViewImpl;
import com.sap.sailing.gwt.autoplay.client.places.screens.preliveraceloop.racemap.statistic.PreRaceStatisticsBox;
import com.sap.sailing.gwt.autoplay.client.places.screens.preliveraceloop.racemap.statistic.PreRaceStatisticsBoxResources;
import com.sap.sailing.gwt.home.communication.event.sixtyinch.GetSixtyInchStatisticDTO;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.client.shared.racemap.RaceMap;
import com.sap.sse.gwt.client.panels.ResizableFlowPanel;

public class PreRaceRacemapViewImpl
extends ResizeComposite
implements PreRaceRacemapView {
    private static PreRaceRacemapViewImplUiBinder uiBinder = (PreRaceRacemapViewImplUiBinder)GWT.create(PreRaceRacemapViewImplUiBinder.class);
    @UiField
    ResizableFlowPanel racemap;
    @UiField
    ResizableFlowPanel raceInfoHolder;
    @UiField
    Label bottomInfoPanel;
    PreRaceStatisticsBox statistics = new PreRaceStatisticsBox();
    private NumberFormat compactFormat = NumberFormat.getFormat((String)"#.0");

    public PreRaceRacemapViewImpl() {
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
    }

    public void showErrorNoLive(PreRaceRacemapPresenterImpl slide7PresenterImpl, AcceptsOneWidget panel, Throwable error) {
        panel.setWidget((IsWidget)new Label("Could not load RaceMap: " + error.getMessage()));
    }

    public void startingWith(PreRaceRacemapView.Slide7Presenter p, AcceptsOneWidget panel, RaceMap raceMap) {
        panel.setWidget((IsWidget)this);
        this.racemap.add((Widget)raceMap);
        this.raceInfoHolder.add((Widget)this.statistics);
    }

    public void updateStatistic(GetSixtyInchStatisticDTO result, String url, String windSpeed, String windDegree) {
        this.racemap.onResize();
        this.statistics.clear();
        this.statistics.addItem(PreRaceStatisticsBoxResources.INSTANCE.competitors(), StringMessages.INSTANCE.competitors(), (Object)result.getCompetitors());
        this.statistics.addItem(PreRaceStatisticsBoxResources.INSTANCE.strongestWind(), StringMessages.INSTANCE.wind(), (Object)windSpeed);
        this.statistics.addItem(PreRaceStatisticsBoxResources.INSTANCE.wind(), StringMessages.INSTANCE.averageDirection(), (Object)windDegree);
        this.statistics.addItem(PreRaceStatisticsBoxResources.INSTANCE.legs(), StringMessages.INSTANCE.legs(), (Object)result.getLegs());
        try {
            this.statistics.addItem(PreRaceStatisticsBoxResources.INSTANCE.sumMiles(), StringMessages.INSTANCE.estimatedDistance(), (Object)(String.valueOf(this.compactFormat.format(result.getDistance().getNauticalMiles())) + " " + StringMessages.INSTANCE.nauticalMiles()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.statistics.addItem(PreRaceStatisticsBoxResources.INSTANCE.time(), StringMessages.INSTANCE.estimatedTime(), (Object)(String.valueOf(this.compactFormat.format(result.getDuration().asMinutes())) + " " + StringMessages.INSTANCE.minutes()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.statistics.addQRItem(PreRaceStatisticsBoxResources.INSTANCE.raceviewer(), StringMessages.INSTANCE.raceViewer(), url);
    }

    public void nextRace(RegattaAndRaceIdentifier race) {
        this.bottomInfoPanel.setText(String.valueOf(StringMessages.INSTANCE.next()) + " " + race.getRegattaName() + " " + race.getRaceName());
    }
}

