/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.autoplay.client.nodes.base;

import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.web.bindery.event.shared.Event;
import com.sap.sailing.domain.common.RegattaAndRaceIdentifier;
import com.sap.sailing.gwt.autoplay.client.app.AutoPlayClientFactory;
import com.sap.sailing.gwt.autoplay.client.events.AutoPlayFailureEvent;
import com.sap.sailing.gwt.autoplay.client.events.FailureEvent;
import com.sap.sailing.gwt.autoplay.client.nodes.base.BaseCompositeNode;
import com.sap.sailing.gwt.autoplay.client.nodes.base.RootNodeState;
import com.sap.sailing.gwt.autoplay.client.utils.AutoplayHelper;
import com.sap.sailing.gwt.home.communication.SailingDispatchSystem;
import com.sap.sailing.gwt.ui.client.SailingServiceAsync;
import com.sap.sailing.gwt.ui.shared.EventDTO;
import com.sap.sse.gwt.client.ErrorReporter;
import java.util.UUID;

public abstract class RootNodeBase
extends BaseCompositeNode {
    private static final int LIVE_SWITCH_DELAY_MILLIS = 1000;
    private static final int UPDATE_STATE_TIMER_MILLIS = 5000;
    private final AutoPlayClientFactory cf;
    private String leaderBoardName;
    private int errorCount = 0;
    private RootNodeState currentState;
    boolean firstTimeEventLoaded = true;
    private Timer checkTimer = new /* Unavailable Anonymous Inner Class!! */;

    protected RootNodeBase(String name, AutoPlayClientFactory cf) {
        super(name);
        this.cf = cf;
    }

    public final void onStart() {
        if (!this.cf.isConfigured()) {
            this.backToConfig();
            return;
        }
        this.getBus().addHandler((Event.Type)AutoPlayFailureEvent.TYPE, (Object)new /* Unavailable Anonymous Inner Class!! */);
        this.doCheck();
    }

    public final void onStop() {
        this.checkTimer.cancel();
    }

    private void doCheck() {
        this.checkTimer.schedule(5000);
        UUID eventUUID = this.cf.getAutoPlayCtxSignalError().getContextDefinition().getEventId();
        this.cf.getSailingService().getEventById(eventUUID, true, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void _doCheck() {
        RegattaAndRaceIdentifier currentPreLiveRace = this.cf.getAutoPlayCtxSignalError().getPreLiveRace();
        RegattaAndRaceIdentifier currentLiveRace = this.cf.getAutoPlayCtxSignalError().getLiveRace();
        this.leaderBoardName = this.cf.getAutoPlayCtxSignalError().getContextDefinition().getLeaderboardName();
        AutoplayHelper.getLiveRace((SailingServiceAsync)this.cf.getSailingService(), (ErrorReporter)this.cf.getErrorReporter(), (EventDTO)this.cf.getAutoPlayCtxSignalError().getEvent(), (String)this.leaderBoardName, (SailingDispatchSystem)this.cf.getDispatch(), (long)this.getWaitTimeAfterRaceEndInMillis(), (long)this.getSwitchBeforeRaceStartInMillis(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected abstract long getSwitchBeforeRaceStartInMillis();

    protected abstract long getWaitTimeAfterRaceEndInMillis();

    private final void setCurrentState(boolean isPreLiveRace, RegattaAndRaceIdentifier liveRace, RootNodeState goingTo, RootNodeState comingFrom) {
        if (goingTo != comingFrom) {
            this.log("RootNodeBase transition " + comingFrom + " -> " + goingTo);
            RegattaAndRaceIdentifier candidatePreLiveRace = isPreLiveRace ? liveRace : null;
            RegattaAndRaceIdentifier candidateLiveRace = isPreLiveRace ? null : liveRace;
            boolean veto = this.processStateTransition(candidatePreLiveRace, candidateLiveRace, goingTo, comingFrom);
            if (veto) {
                this.log("Vetoed switching to state " + goingTo + " coming from " + comingFrom);
            } else {
                this.log("Switching to state " + goingTo + " coming from " + comingFrom);
                this.currentState = goingTo;
            }
        }
    }

    public AutoPlayClientFactory getClientFactory() {
        return this.cf;
    }

    protected void backToConfig() {
        this.cf.getPlaceController().goTo(this.cf.getDefaultPlace());
    }

    protected abstract boolean processStateTransition(RegattaAndRaceIdentifier var1, RegattaAndRaceIdentifier var2, RootNodeState var3, RootNodeState var4);

    protected abstract void processFailure(FailureEvent var1);

    static /* synthetic */ void access$0(RootNodeBase rootNodeBase) {
        rootNodeBase.doCheck();
    }

    static /* synthetic */ AutoPlayClientFactory access$1(RootNodeBase rootNodeBase) {
        return rootNodeBase.cf;
    }

    static /* synthetic */ void access$2(RootNodeBase rootNodeBase) {
        rootNodeBase._doCheck();
    }

    static /* synthetic */ RootNodeState access$3(RootNodeBase rootNodeBase) {
        return rootNodeBase.currentState;
    }

    static /* synthetic */ void access$4(RootNodeBase rootNodeBase, boolean bl, RegattaAndRaceIdentifier regattaAndRaceIdentifier, RootNodeState rootNodeState, RootNodeState rootNodeState2) {
        rootNodeBase.setCurrentState(bl, regattaAndRaceIdentifier, rootNodeState, rootNodeState2);
    }

    static /* synthetic */ Timer access$5(RootNodeBase rootNodeBase) {
        return rootNodeBase.checkTimer;
    }

    static /* synthetic */ void access$6(RootNodeBase rootNodeBase, int n) {
        rootNodeBase.errorCount = n;
    }

    static /* synthetic */ int access$7(RootNodeBase rootNodeBase) {
        return rootNodeBase.errorCount;
    }
}

