/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.autoplay.client.app;

import com.sap.sailing.domain.common.DetailType;
import com.sap.sailing.domain.common.dto.AbstractLeaderboardDTO;
import com.sap.sailing.domain.common.dto.RaceDTO;
import com.sap.sailing.domain.common.subscription.PremiumRole;
import com.sap.sailing.gwt.autoplay.client.app.AutoplayPerspectiveOwnSettings;
import com.sap.sailing.gwt.autoplay.client.app.AutoplaySettingsDialogComponent;
import com.sap.sailing.gwt.autoplay.client.shared.leaderboard.LeaderboardWithZoomingPerspectiveLifecycle;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.raceboard.RaceBoardPerspectiveLifecycle;
import com.sap.sse.gwt.client.shared.components.ComponentLifecycle;
import com.sap.sse.gwt.client.shared.components.SettingsDialogComponent;
import com.sap.sse.gwt.client.shared.perspective.AbstractPerspectiveLifecycle;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.dto.SecuredDTO;
import com.sap.sse.security.ui.client.UserService;
import com.sap.sse.security.ui.client.premium.PaywallResolver;
import com.sap.sse.security.ui.client.premium.PaywallResolverImpl;
import com.sap.sse.security.ui.client.subscription.SubscriptionServiceFactory;
import com.sap.sse.security.ui.shared.EssentialSecuredDTO;
import java.util.Set;

public class AutoplayPerspectiveLifecycle
extends AbstractPerspectiveLifecycle<AutoplayPerspectiveOwnSettings> {
    public static final String ID = "ap";
    private LeaderboardWithZoomingPerspectiveLifecycle leaderboardLifecycle;
    private RaceBoardPerspectiveLifecycle raceboardLifecycle;

    public AutoplayPerspectiveLifecycle(AbstractLeaderboardDTO leaderboard, UserService userService, SubscriptionServiceFactory subscriptionServiceFactory, Iterable<DetailType> availableDetailTypes) {
        PaywallResolverImpl paywallResolver = new PaywallResolverImpl(userService, subscriptionServiceFactory);
        this.leaderboardLifecycle = new LeaderboardWithZoomingPerspectiveLifecycle(leaderboard, StringMessages.INSTANCE, availableDetailTypes, (PaywallResolver)paywallResolver);
        this.raceboardLifecycle = new RaceBoardPerspectiveLifecycle(leaderboard, StringMessages.INSTANCE, (Iterable)DetailType.getAutoplayDetailTypesForChart(), userService, (PaywallResolver)paywallResolver, availableDetailTypes, this.getEssentialRaceDTOWithPremiumActionACLs());
        this.addLifeCycle((ComponentLifecycle)this.leaderboardLifecycle);
        this.addLifeCycle((ComponentLifecycle)this.raceboardLifecycle);
    }

    public AutoplayPerspectiveLifecycle(AbstractLeaderboardDTO leaderboard, UserService userService, PaywallResolver paywallResolver, Iterable<DetailType> availableDetailTypes) {
        this.leaderboardLifecycle = new LeaderboardWithZoomingPerspectiveLifecycle(leaderboard, StringMessages.INSTANCE, availableDetailTypes, paywallResolver);
        this.raceboardLifecycle = new RaceBoardPerspectiveLifecycle(leaderboard, StringMessages.INSTANCE, (Iterable)DetailType.getAutoplayDetailTypesForChart(), userService, paywallResolver, availableDetailTypes, this.getEssentialRaceDTOWithPremiumActionACLs());
        this.addLifeCycle((ComponentLifecycle)this.leaderboardLifecycle);
        this.addLifeCycle((ComponentLifecycle)this.raceboardLifecycle);
    }

    private SecuredDTO getEssentialRaceDTOWithPremiumActionACLs() {
        return EssentialSecuredDTO.getInstanceByPermissionTypeFromPermissionSet((HasPermissions)RaceDTO.getPermissionTypeForClass(), (Set)PremiumRole.getInstance().getPermissions());
    }

    public AutoplayPerspectiveOwnSettings createPerspectiveOwnDefaultSettings() {
        return new AutoplayPerspectiveOwnSettings();
    }

    public SettingsDialogComponent<AutoplayPerspectiveOwnSettings> getPerspectiveOwnSettingsDialogComponent(AutoplayPerspectiveOwnSettings settings) {
        return new AutoplaySettingsDialogComponent(settings);
    }

    public LeaderboardWithZoomingPerspectiveLifecycle getLeaderboardLifecycle() {
        return this.leaderboardLifecycle;
    }

    public RaceBoardPerspectiveLifecycle getRaceboardLifecycle() {
        return this.raceboardLifecycle;
    }

    public String getLocalizedShortName() {
        return StringMessages.INSTANCE.autoplayConfiguration();
    }

    public String getComponentId() {
        return ID;
    }

    public boolean hasSettings() {
        return true;
    }

    protected AutoplayPerspectiveOwnSettings extractOwnUserSettings(AutoplayPerspectiveOwnSettings settings) {
        return settings;
    }

    protected AutoplayPerspectiveOwnSettings extractOwnDocumentSettings(AutoplayPerspectiveOwnSettings settings) {
        return settings;
    }
}

