/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.autoplay.client.app;

import com.sap.sailing.domain.common.RegattaAndRaceIdentifier;
import com.sap.sailing.gwt.autoplay.client.app.AutoPlayContext;
import com.sap.sailing.gwt.autoplay.client.app.AutoplayPerspectiveLifecycle;
import com.sap.sailing.gwt.autoplay.client.app.AutoplayPerspectiveOwnSettings;
import com.sap.sailing.gwt.autoplay.client.configs.AutoPlayConfiguration;
import com.sap.sailing.gwt.autoplay.client.configs.AutoPlayContextDefinition;
import com.sap.sailing.gwt.autoplay.client.nodes.base.AutoPlaySequenceNode;
import com.sap.sailing.gwt.ui.shared.EventDTO;
import com.sap.sse.gwt.client.shared.perspective.PerspectiveCompositeSettings;
import java.util.logging.Logger;

public class AutoPlayContextImpl
implements AutoPlayContext {
    private static final Logger LOG = Logger.getLogger(AutoPlaySequenceNode.class.getName());
    private AutoPlayConfiguration configuration;
    private AutoPlayContextDefinition contextDefinition;
    private EventDTO event;
    private RegattaAndRaceIdentifier liveRace;
    private RegattaAndRaceIdentifier lastRace;
    private RegattaAndRaceIdentifier preLiveRace;
    private AutoplayPerspectiveLifecycle autoplayLifecycle;
    private PerspectiveCompositeSettings<AutoplayPerspectiveOwnSettings> autoplaySettings;

    public AutoPlayContextImpl(AutoplayPerspectiveLifecycle autoplayLifecycle, PerspectiveCompositeSettings<AutoplayPerspectiveOwnSettings> autoplaySettings, AutoPlayConfiguration configuration, AutoPlayContextDefinition contextDefinition, EventDTO initialEventData) {
        this(configuration, contextDefinition, initialEventData);
        if (autoplayLifecycle == null) {
            throw new IllegalStateException("No autoplayLifecycle in creation");
        }
        if (autoplaySettings == null) {
            throw new IllegalStateException("No autoplaySettings in creation");
        }
        this.autoplayLifecycle = autoplayLifecycle;
        this.autoplaySettings = autoplaySettings;
    }

    public AutoPlayContextImpl(AutoPlayConfiguration configuration, AutoPlayContextDefinition contextDefinition, EventDTO initialEventData) {
        if (configuration == null) {
            throw new IllegalStateException("No configuration in creation");
        }
        if (contextDefinition == null) {
            throw new IllegalStateException("No settings in creation");
        }
        this.configuration = configuration;
        this.contextDefinition = contextDefinition;
        this.event = initialEventData;
    }

    public AutoPlayContextDefinition getContextDefinition() {
        return this.contextDefinition;
    }

    public void updateLiveRace(RegattaAndRaceIdentifier currentPreLifeRace, RegattaAndRaceIdentifier currentLiveRace) {
        if (this.liveRace != null && !this.liveRace.equals(currentLiveRace)) {
            LOG.info("Autoplay: Last race was " + this.lastRace + " live race is now " + this.liveRace);
            this.lastRace = this.liveRace;
        }
        this.preLiveRace = currentPreLifeRace;
        this.liveRace = currentLiveRace;
    }

    public AutoPlayConfiguration getAutoPlayConfiguration() {
        return this.configuration;
    }

    public EventDTO getEvent() {
        return this.event;
    }

    public void updateEvent(EventDTO event) {
        this.event = event;
    }

    public RegattaAndRaceIdentifier getLiveRace() {
        return this.liveRace;
    }

    public RegattaAndRaceIdentifier getPreLiveRace() {
        return this.preLiveRace;
    }

    public RegattaAndRaceIdentifier getLastRace() {
        return this.lastRace;
    }

    public PerspectiveCompositeSettings<AutoplayPerspectiveOwnSettings> getAutoplaySettings() {
        return this.autoplaySettings;
    }

    public AutoplayPerspectiveLifecycle getAutoplayLifecycle() {
        return this.autoplayLifecycle;
    }

    public RegattaAndRaceIdentifier getLifeOrPreLiveRace() {
        if (this.getLiveRace() != null) {
            return this.getLiveRace();
        }
        return this.getPreLiveRace();
    }
}

