/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.declination.impl;

import com.sap.sailing.declination.Declination;
import com.sap.sailing.declination.impl.DeclinationImporter;
import com.sap.sailing.declination.impl.DeclinationRecordImpl;
import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.impl.DegreePosition;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.impl.DegreeBearingImpl;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class BGSImporter
extends DeclinationImporter {
    private static final String URL_PATTERN_PRE_2025 = "http://geomag.bgs.ac.uk/web_service/GMModels/igrf/13/?latitude=%f&longitude=%f&altitude=0&date=%d-%d-%d&format=xml";
    private static final String URL_PATTERN_POST_2025 = "https://geomag.bgs.ac.uk/web_service/GMModels/wmm/2025?latitude=%f&longitude=%f&altitude=0&date=%d-%d-%d&format=xml";

    public Declination getDeclinationFromXml(InputStream is) throws SAXException, IOException, ParserConfigurationException {
        XmlElementHandler handler = new XmlElementHandler();
        SAXParserFactory.newInstance().newSAXParser().parse(is, (DefaultHandler)handler);
        return handler.getDeclination();
    }

    @Override
    public Declination importRecord(Position position, TimePoint timePoint) throws IOException, ParserConfigurationException, SAXException {
        GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        cal.setTime(timePoint.asDate());
        int year = cal.get(1);
        URL url = new URL(String.format(year >= 2025 ? URL_PATTERN_POST_2025 : URL_PATTERN_PRE_2025, position.getLatDeg(), position.getLngDeg(), year, cal.get(2) + 1, cal.get(5)));
        return this.getDeclinationFromXml(url.openStream());
    }

    private static class XmlElementHandler
    extends DefaultHandler {
        private Date dateAsDecimalYear;
        private double latDeg;
        private double lngDeg;
        private double declinationDeg;
        private double annualDeclinationChangeDeg;
        private boolean inFieldValue;
        private boolean inSecularVariation;
        private StringBuilder elementContent = new StringBuilder();

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            switch (qName) {
                case "field-value": {
                    this.inFieldValue = true;
                    break;
                }
                case "secular-variation": {
                    this.inSecularVariation = true;
                }
            }
            this.elementContent.delete(0, this.elementContent.length());
            super.startElement(uri, localName, qName, attributes);
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            this.elementContent.append(ch, start, length);
            super.characters(ch, start, length);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            String content = this.elementContent.toString();
            switch (qName) {
                case "field-value": {
                    this.inFieldValue = false;
                    break;
                }
                case "secular-variation": {
                    this.inSecularVariation = false;
                    break;
                }
                case "date": {
                    try {
                        this.dateAsDecimalYear = new SimpleDateFormat("yyyy-MM-dd").parse(content);
                        break;
                    }
                    catch (ParseException e) {
                        throw new RuntimeException(e);
                    }
                }
                case "latitude": {
                    this.latDeg = Double.valueOf(content);
                    break;
                }
                case "longitude": {
                    this.lngDeg = Double.valueOf(content);
                    break;
                }
                case "declination": {
                    if (this.inFieldValue) {
                        this.declinationDeg = Double.valueOf(content);
                        break;
                    }
                    if (!this.inSecularVariation) break;
                    this.annualDeclinationChangeDeg = Double.valueOf(content) / 60.0;
                }
            }
            super.endElement(uri, localName, qName);
        }

        Declination getDeclination() {
            return new DeclinationRecordImpl((Position)new DegreePosition(this.latDeg, this.lngDeg), (TimePoint)new MillisecondsTimePoint(this.dateAsDecimalYear), (Bearing)new DegreeBearingImpl(this.declinationDeg), (Bearing)new DegreeBearingImpl(this.annualDeclinationChangeDeg));
        }
    }
}

