/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.gwt.adminconsole;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sse.gwt.adminconsole.AdditionalServerInformationDialog;
import com.sap.sse.gwt.adminconsole.StringMessages;
import com.sap.sse.gwt.client.ErrorReporter;
import com.sap.sse.gwt.client.ServerInfoDTO;

public class SystemInformationPanel
extends FlowPanel {
    private final Label buildVersionText = new Label();
    private String fullVersionText;
    private boolean buildVersionCut;
    private Anchor additionalInformation;

    public SystemInformationPanel(final ServerInfoDTO serverInfo, ErrorReporter errorReporter, final StringMessages stringMessages) {
        if (serverInfo != null) {
            this.fullVersionText = serverInfo.getBuildVersion();
            if (this.fullVersionText.length() > 70) {
                this.buildVersionCut = true;
                int toIndex = this.fullVersionText.indexOf(" ") - 1;
                this.buildVersionText.setText(stringMessages.version(String.valueOf(this.fullVersionText.substring(0, toIndex)) + "..."));
            } else {
                this.buildVersionText.setText(stringMessages.version(this.fullVersionText));
            }
        } else {
            this.buildVersionText.setText(stringMessages.version(stringMessages.unknown()));
        }
        this.add((Widget)this.buildVersionText);
        if (this.buildVersionCut) {
            this.additionalInformation = new Anchor(stringMessages.additionalInformation());
            this.additionalInformation.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    AdditionalServerInformationDialog additionalInformationDialog = new AdditionalServerInformationDialog(stringMessages, serverInfo);
                    additionalInformationDialog.show();
                }
            });
            this.add((Widget)this.additionalInformation);
        }
    }
}

