/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.gwt.adminconsole;

import com.google.gwt.dom.client.Style;
import com.google.gwt.event.logical.shared.HasSelectionHandlers;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.place.shared.Place;
import com.google.gwt.place.shared.PlaceController;
import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.DockPanel;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HeaderPanel;
import com.google.gwt.user.client.ui.ResizeComposite;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sse.common.Util;
import com.sap.sse.gwt.adminconsole.AdminConsolePanelSupplier;
import com.sap.sse.gwt.adminconsole.AdminConsolePlace;
import com.sap.sse.gwt.adminconsole.FilterableAdminConsolePlace;
import com.sap.sse.gwt.adminconsole.FilterablePanelProvider;
import com.sap.sse.gwt.adminconsole.PanelSupplierScollPanel;
import com.sap.sse.gwt.adminconsole.RefreshableAdminConsolePanel;
import com.sap.sse.gwt.adminconsole.StringMessages;
import com.sap.sse.gwt.adminconsole.SystemInformationPanel;
import com.sap.sse.gwt.client.AbstractEntryPoint;
import com.sap.sse.gwt.client.ErrorReporter;
import com.sap.sse.gwt.client.ServerInfoDTO;
import com.sap.sse.gwt.client.panels.AbstractTabLayoutPanel;
import com.sap.sse.gwt.client.panels.HorizontalTabLayoutPanel;
import com.sap.sse.gwt.client.panels.VerticalTabLayoutPanel;
import com.sap.sse.gwt.shared.ClientConfiguration;
import com.sap.sse.security.shared.WildcardPermission;
import com.sap.sse.security.shared.dto.UserDTO;
import com.sap.sse.security.ui.client.UserService;
import com.sap.sse.security.ui.client.UserStatusEventHandler;
import com.sap.sse.security.ui.loginpanel.LoginPanelCss;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BooleanSupplier;

public class AdminConsolePanel<T extends Place>
extends HeaderPanel {
    private final UserService userService;
    private final LinkedHashSet<Util.Triple<VerticalOrHorizontalTabLayoutPanel, Widget, String>> roleSpecificTabs;
    private final Map<Widget, Set<BooleanSupplier>> permissionsAnyOfWhichIsRequiredToSeeWidget;
    private final Map<Widget, T> widgetPlacesMap;
    private final Map<String, String> verticalTabNameToTitleMap;
    private final Map<Widget, String> panelAndDebugId;
    private final Map<Class<?>, String> placeAndDebugId;
    private final SelectionHandler<Integer> tabSelectionHandler;
    private final VerticalTabLayoutPanel topLevelTabPanel;
    private final VerticalOrHorizontalTabLayoutPanel topLevelTabPanelWrapper;
    private final Map<Widget, RefreshableAdminConsolePanel<? extends Widget>> panelsByWidget;
    private final PlaceController placeController;
    private T currentPlace;

    private static Widget unwrapScrollPanel(Widget widgetMaybeWrappedByScrollPanel) {
        Widget target = widgetMaybeWrappedByScrollPanel instanceof ScrollPanel ? ((ScrollPanel)widgetMaybeWrappedByScrollPanel).getWidget() : widgetMaybeWrappedByScrollPanel;
        return target;
    }

    public AdminConsolePanel(UserService userService, ServerInfoDTO serverInfo, String releaseNotesAnchorLabel, String releaseNotesURL, Anchor footerAnchor, ErrorReporter errorReporter, LoginPanelCss loginPanelCss, StringMessages stringMessages, PlaceController placeController) {
        this.placeController = placeController;
        this.permissionsAnyOfWhichIsRequiredToSeeWidget = new HashMap<Widget, Set<BooleanSupplier>>();
        this.userService = userService;
        this.roleSpecificTabs = new LinkedHashSet();
        this.panelsByWidget = new HashMap<Widget, RefreshableAdminConsolePanel<? extends Widget>>();
        this.widgetPlacesMap = new HashMap<Widget, T>();
        this.verticalTabNameToTitleMap = new HashMap<String, String>();
        this.panelAndDebugId = new HashMap<Widget, String>();
        this.placeAndDebugId = new HashMap();
        this.getUserService().addUserStatusEventHandler(new UserStatusEventHandler(){

            public void onUserStatusChange(UserDTO user, boolean preAuthenticated) {
                AdminConsolePanel.this.updateTabDisplayForCurrentUser(user, true);
            }
        });
        this.tabSelectionHandler = new TabSelectionHandler();
        this.topLevelTabPanel = new VerticalTabLayoutPanel(2.5, Style.Unit.EM);
        this.topLevelTabPanel.addSelectionHandler(this.tabSelectionHandler);
        this.topLevelTabPanel.ensureDebugId("AdministrationTabs");
        this.topLevelTabPanelWrapper = new VerticalOrHorizontalTabLayoutPanel(){

            @Override
            public void add(Widget child, String text, boolean asHtml, boolean fireEvents) {
                child.setTitle(text);
                AdminConsolePanel.this.topLevelTabPanel.add(child, text, asHtml, fireEvents);
                AdminConsolePanel.this.topLevelTabPanel.forceLayout();
            }

            @Override
            public boolean remove(Widget child) {
                return AdminConsolePanel.this.topLevelTabPanel.remove(child);
            }

            @Override
            public boolean remove(Widget child, boolean fireEvents) {
                return AdminConsolePanel.this.topLevelTabPanel.remove(AdminConsolePanel.this.topLevelTabPanel.getWidgetIndex(child), fireEvents);
            }

            @Override
            public Widget getPanel() {
                return AdminConsolePanel.this.topLevelTabPanel;
            }

            @Override
            public void selectTab(int index) {
                AdminConsolePanel.this.topLevelTabPanel.selectTab(index);
            }

            @Override
            public void selectTab(int index, boolean fireEvent) {
                AdminConsolePanel.this.topLevelTabPanel.selectTab(index, fireEvent);
            }

            @Override
            public int getWidgetIndex(Widget child) {
                return AdminConsolePanel.this.topLevelTabPanel.getWidgetIndex(child);
            }
        };
        DockPanel informationPanel = new DockPanel();
        informationPanel.setWidth("100%");
        informationPanel.setSpacing(10);
        Widget persistentInformationWidget = errorReporter.getPersistentInformationWidget();
        persistentInformationWidget.addStyleName("footerInfoPanel");
        informationPanel.add(persistentInformationWidget, DockPanel.CENTER);
        SystemInformationPanel sysinfoPanel = new SystemInformationPanel(serverInfo, errorReporter, stringMessages);
        sysinfoPanel.addStyleName("systemInformationPanel");
        sysinfoPanel.ensureDebugId("SystemInformation");
        if (ClientConfiguration.getInstance().isBrandingActive()) {
            Anchor releaseNotesLink = new Anchor(SafeHtmlUtils.htmlEscape((String)releaseNotesAnchorLabel), releaseNotesURL);
            releaseNotesLink.addStyleName("releaseNotesAnchor");
            sysinfoPanel.add((Widget)releaseNotesLink);
            informationPanel.add((Widget)releaseNotesLink, DockPanel.EAST);
        }
        if (footerAnchor != null) {
            informationPanel.add((Widget)footerAnchor, DockPanel.EAST);
        }
        informationPanel.add((Widget)sysinfoPanel, DockPanel.EAST);
        informationPanel.setCellHorizontalAlignment((Widget)sysinfoPanel, HasHorizontalAlignment.ALIGN_RIGHT);
        this.setFooterWidget((Widget)informationPanel);
        this.topLevelTabPanel.setSize("100%", "100%");
        this.setContentWidget((Widget)this.topLevelTabPanel);
    }

    public void initUI(T place) {
        this.updateTabDisplayForCurrentUser(this.getUserService().getCurrentUser(), false);
        if (place == null) {
            if (this.topLevelTabPanel.getWidgetCount() > 0) {
                this.topLevelTabPanel.selectTab(0);
                Widget currentSelectedWidget = this.topLevelTabPanel.getWidget(0);
                if (currentSelectedWidget instanceof PanelSupplierScollPanel) {
                    PanelSupplierScollPanel supplierScollPanel = (PanelSupplierScollPanel)currentSelectedWidget;
                    supplierScollPanel.activate(t -> {});
                }
            }
        } else {
            this.selectTabByPlace(place, false);
        }
    }

    private UserService getUserService() {
        return this.userService;
    }

    public HorizontalTabLayoutPanel addVerticalTab(String tabTitle, String tabDebugId, T place, WildcardPermission ... requiresAnyOfThesePermissions) {
        HorizontalTabLayoutPanel newTabPanel = new HorizontalTabLayoutPanel(2.5, Style.Unit.EM);
        AbstractEntryPoint.setTabPanelSize((ResizeComposite)newTabPanel, (String)"100%", (String)"100%");
        newTabPanel.addSelectionHandler(this.tabSelectionHandler);
        newTabPanel.ensureDebugId(tabDebugId);
        this.panelAndDebugId.put((Widget)newTabPanel, tabDebugId);
        this.rememberWidgetLocationAndPermissions(this.topLevelTabPanelWrapper, (Widget)newTabPanel, tabTitle, this.anyPermissionCheck(requiresAnyOfThesePermissions), place);
        return newTabPanel;
    }

    public HorizontalTabLayoutPanel addVerticalTab(String tabTitle, String tabDebugId, WildcardPermission ... requiresAnyOfThesePermissions) {
        this.verticalTabNameToTitleMap.put(tabDebugId, tabTitle);
        return this.addVerticalTab(tabTitle, tabDebugId, (T)null, requiresAnyOfThesePermissions);
    }

    public void addToVerticalTabPanel(RefreshableAdminConsolePanel<? extends Widget> panelToAdd, String tabTitle, T place, WildcardPermission ... requiresAnyOfThesePermissions) {
        this.addToTabPanel(this.topLevelTabPanelWrapper, panelToAdd, tabTitle, this.anyPermissionCheck(requiresAnyOfThesePermissions), place);
    }

    private ScrollPanel wrapInScrollPanel(Widget panelToAdd) {
        ScrollPanel scrollPanel = new ScrollPanel();
        scrollPanel.add(panelToAdd);
        panelToAdd.setSize("100%", "100%");
        return scrollPanel;
    }

    private ScrollPanel wrapInDummyScrollPanel(AdminConsolePanelSupplier<? extends Widget> supplierToAdd) {
        PanelSupplierScollPanel scrollPanel = new PanelSupplierScollPanel(supplierToAdd);
        return scrollPanel;
    }

    public void addToTabPanel(HorizontalTabLayoutPanel tabPanel, RefreshableAdminConsolePanel<? extends Widget> panelToAdd, String tabTitle, T place) {
        this.addToTabPanel(tabPanel, panelToAdd, tabTitle, place, new WildcardPermission("*"));
    }

    public BooleanSupplier anyPermissionCheck(WildcardPermission ... requiresAnyOfThesePermissions) {
        return () -> {
            boolean permitted = false;
            WildcardPermission[] wildcardPermissionArray2 = requiresAnyOfThesePermissions;
            int n = requiresAnyOfThesePermissions.length;
            int n2 = 0;
            while (n2 < n) {
                WildcardPermission requiredPermission = wildcardPermissionArray2[n2];
                if (this.userService.hasCurrentUserAnyPermission(requiredPermission, null)) {
                    permitted = true;
                    break;
                }
                ++n2;
            }
            return permitted;
        };
    }

    public void addToTabPanel(HorizontalTabLayoutPanel tabPanel, RefreshableAdminConsolePanel<? extends Widget> panelToAdd, String tabTitle, T place, WildcardPermission ... requiresAnyOfThesePermissions) {
        this.addToTabPanel(tabPanel, panelToAdd, tabTitle, place, this.anyPermissionCheck(requiresAnyOfThesePermissions));
    }

    public void addToTabPanel(final HorizontalTabLayoutPanel tabPanel, RefreshableAdminConsolePanel<? extends Widget> panelToAdd, String tabTitle, BooleanSupplier permissionCheck, T place) {
        VerticalOrHorizontalTabLayoutPanel wrapper = new VerticalOrHorizontalTabLayoutPanel(){

            @Override
            public void add(Widget child, String text, boolean asHtml, boolean fireEvents) {
                child.setTitle(text);
                tabPanel.add(child, text, asHtml, fireEvents);
                tabPanel.forceLayout();
            }

            @Override
            public boolean remove(Widget child) {
                return tabPanel.remove(child);
            }

            @Override
            public boolean remove(Widget child, boolean fireEvents) {
                return tabPanel.remove(tabPanel.getWidgetIndex(child), fireEvents);
            }

            @Override
            public Widget getPanel() {
                return tabPanel;
            }

            @Override
            public void selectTab(int index) {
                tabPanel.selectTab(index);
            }

            @Override
            public void selectTab(int index, boolean fireEvent) {
                tabPanel.selectTab(index, fireEvent);
            }

            @Override
            public int getWidgetIndex(Widget child) {
                return tabPanel.getWidgetIndex(child);
            }
        };
        this.addToTabPanel(wrapper, panelToAdd, tabTitle, permissionCheck, place);
    }

    public void addToTabPanel(final HorizontalTabLayoutPanel tabPanel, RefreshableAdminConsolePanel<? extends Widget> panelToAdd, String tabTitle, T place, BooleanSupplier permissionCheck) {
        VerticalOrHorizontalTabLayoutPanel wrapper = new VerticalOrHorizontalTabLayoutPanel(){

            @Override
            public void add(Widget child, String text, boolean asHtml, boolean fireEvents) {
                child.setTitle(text);
                tabPanel.add(child, text, asHtml, fireEvents);
                tabPanel.forceLayout();
            }

            @Override
            public boolean remove(Widget child) {
                return tabPanel.remove(child);
            }

            @Override
            public boolean remove(Widget child, boolean fireEvents) {
                return tabPanel.remove(tabPanel.getWidgetIndex(child), fireEvents);
            }

            @Override
            public Widget getPanel() {
                return tabPanel;
            }

            @Override
            public void selectTab(int index) {
                tabPanel.selectTab(index);
            }

            @Override
            public void selectTab(int index, boolean fireEvent) {
                tabPanel.selectTab(index, fireEvent);
            }

            @Override
            public int getWidgetIndex(Widget child) {
                return tabPanel.getWidgetIndex(child);
            }
        };
        this.addToTabPanel(wrapper, panelToAdd, tabTitle, permissionCheck, place);
        String debugId = this.panelAndDebugId.get(tabPanel);
        if (debugId != null) {
            this.placeAndDebugId.put(place.getClass(), debugId);
        }
    }

    private void addToTabPanel(VerticalOrHorizontalTabLayoutPanel tabPanel, RefreshableAdminConsolePanel<? extends Widget> panelToAdd, String tabTitle, BooleanSupplier permissionCheck, T place) {
        if (panelToAdd.getAdminConsolePanelSupplier() != null) {
            panelToAdd.getAdminConsolePanelSupplier().setTitle(tabTitle);
            ScrollPanel wrapped = this.wrapInDummyScrollPanel(panelToAdd.getAdminConsolePanelSupplier());
            this.rememberWidgetLocationAndPermissions(tabPanel, (Widget)wrapped, tabTitle, permissionCheck, place);
            this.panelsByWidget.put((Widget)wrapped, panelToAdd);
        } else {
            panelToAdd.getWidget().setTitle(tabTitle);
            ScrollPanel wrapped = this.wrapInScrollPanel(panelToAdd.getWidget());
            this.rememberWidgetLocationAndPermissions(tabPanel, (Widget)wrapped, tabTitle, permissionCheck, place);
            this.panelsByWidget.put(panelToAdd.getWidget(), panelToAdd);
        }
    }

    private void rememberWidgetLocationAndPermissions(VerticalOrHorizontalTabLayoutPanel tabPanel, Widget widgetToAdd, String tabTitle, BooleanSupplier permissionCheck, T place) {
        this.roleSpecificTabs.add((Util.Triple<VerticalOrHorizontalTabLayoutPanel, Widget, String>)new Util.Triple((Object)tabPanel, (Object)widgetToAdd, (Object)tabTitle));
        HashSet<BooleanSupplier> permissionChecksAsSet = new HashSet<BooleanSupplier>(Arrays.asList(permissionCheck));
        this.permissionsAnyOfWhichIsRequiredToSeeWidget.put(widgetToAdd, permissionChecksAsSet);
        Util.addToValueSet(this.permissionsAnyOfWhichIsRequiredToSeeWidget, (Object)tabPanel.getPanel(), (Object)permissionCheck);
        if (place != null) {
            this.widgetPlacesMap.put(widgetToAdd, place);
        }
    }

    private void updateTabDisplayForCurrentUser(UserDTO user, boolean fireEvents) {
        Widget selectedPanel = this.getSelectedTab(null);
        for (Util.Triple triple : this.roleSpecificTabs) {
            Widget widgetToAddOrRemove = (Widget)triple.getB();
            if (user != null && this.userHasPermissionsToSeeWidget(user, (Widget)triple.getB())) {
                if (((VerticalOrHorizontalTabLayoutPanel)triple.getA()).getWidgetIndex(widgetToAddOrRemove) != -1) continue;
                ((VerticalOrHorizontalTabLayoutPanel)triple.getA()).add(widgetToAddOrRemove, (String)triple.getC(), false, fireEvents);
                continue;
            }
            ((VerticalOrHorizontalTabLayoutPanel)triple.getA()).remove(widgetToAddOrRemove, false);
        }
        this.getSelectedTab(selectedPanel);
    }

    private Widget getSelectedTab(Widget reselectCurrentSelectionIfNotSameAsThis) {
        Widget topLevelSelectedTab;
        Widget selectedTabInHorizontalTabPanel = null;
        if (this.topLevelTabPanel.getSelectedIndex() != -1) {
            topLevelSelectedTab = AdminConsolePanel.unwrapScrollPanel(this.topLevelTabPanel.getWidget(this.topLevelTabPanel.getSelectedIndex()));
            if (topLevelSelectedTab instanceof AbstractTabLayoutPanel) {
                AbstractTabLayoutPanel p = (AbstractTabLayoutPanel)topLevelSelectedTab;
                if (p.getSelectedIndex() != -1) {
                    selectedTabInHorizontalTabPanel = AdminConsolePanel.unwrapScrollPanel(p.getWidget(p.getSelectedIndex()));
                    if (reselectCurrentSelectionIfNotSameAsThis != null && selectedTabInHorizontalTabPanel != reselectCurrentSelectionIfNotSameAsThis) {
                        SelectionEvent.fire((HasSelectionHandlers)p, (Object)p.getSelectedIndex());
                    }
                } else {
                    selectedTabInHorizontalTabPanel = null;
                }
            } else if (reselectCurrentSelectionIfNotSameAsThis != null && topLevelSelectedTab != reselectCurrentSelectionIfNotSameAsThis) {
                SelectionEvent.fire((HasSelectionHandlers)this.topLevelTabPanel, (Object)this.topLevelTabPanel.getSelectedIndex());
            }
        } else {
            topLevelSelectedTab = null;
        }
        return selectedTabInHorizontalTabPanel != null ? selectedTabInHorizontalTabPanel : topLevelSelectedTab;
    }

    public void selectTabByPlace(T place) {
        this.selectTabByPlace(place, true);
    }

    public void selectTabByPlace(T place, boolean fireEvent) {
        String verticalTabTitle = null;
        String placeVerticalTabName = this.placeAndDebugId.get(place.getClass());
        if (placeVerticalTabName != null && this.verticalTabNameToTitleMap.containsKey(placeVerticalTabName)) {
            verticalTabTitle = this.verticalTabNameToTitleMap.get(placeVerticalTabName);
        }
        for (Util.Triple triple : this.roleSpecificTabs) {
            VerticalOrHorizontalTabLayoutPanel panel = (VerticalOrHorizontalTabLayoutPanel)triple.getA();
            Widget currentWidget = (Widget)triple.getB();
            if (!this.isWidgetForPlace(place, (Util.Triple<VerticalOrHorizontalTabLayoutPanel, Widget, String>)triple, verticalTabTitle)) continue;
            int index = panel.getWidgetIndex(currentWidget);
            this.currentPlace = place;
            panel.selectTab(index, fireEvent);
            if (currentWidget instanceof PanelSupplierScollPanel) {
                PanelSupplierScollPanel supplierScollPanel = (PanelSupplierScollPanel)currentWidget;
                supplierScollPanel.activate(t -> {
                    this.filterAndSelect(place, AdminConsolePanel.unwrapScrollPanel((Widget)t));
                    this.refreshDataFor((Widget)t);
                });
                continue;
            }
            this.filterAndSelect(place, AdminConsolePanel.unwrapScrollPanel(currentWidget));
            this.refreshDataFor(currentWidget);
        }
    }

    private void refreshDataFor(Widget target) {
        RefreshableAdminConsolePanel<? extends Widget> refreshTarget = target instanceof PanelSupplierScollPanel ? this.panelsByWidget.get(target) : this.panelsByWidget.get(AdminConsolePanel.unwrapScrollPanel(target));
        if (refreshTarget != null) {
            refreshTarget.refreshAfterBecomingVisible();
        }
    }

    private boolean isWidgetForPlace(T place, Util.Triple<VerticalOrHorizontalTabLayoutPanel, Widget, String> panelWidgetName, String verticalTabTitle) {
        boolean isHorizontalMenu;
        Widget currentWidget = (Widget)panelWidgetName.getB();
        boolean bl = isHorizontalMenu = this.widgetPlacesMap.containsKey(currentWidget) && ((AdminConsolePlace)place).isSamePlace(this.widgetPlacesMap.get(currentWidget));
        if (isHorizontalMenu) {
            return true;
        }
        VerticalOrHorizontalTabLayoutPanel panel = (VerticalOrHorizontalTabLayoutPanel)panelWidgetName.getA();
        String verticalPanelName = (String)panelWidgetName.getC();
        boolean isVerticalTab = panel == this.topLevelTabPanelWrapper && verticalTabTitle != null && verticalTabTitle.equals(verticalPanelName);
        return isVerticalTab;
    }

    private void filterAndSelect(T place, Widget widget) {
        if (widget instanceof FilterablePanelProvider && place instanceof FilterableAdminConsolePlace && ((FilterableAdminConsolePlace)place).getFilterAndSelectParameters() != null) {
            FilterablePanelProvider filterablePanelProvider = (FilterablePanelProvider)widget;
            FilterableAdminConsolePlace filterablePlace = (FilterableAdminConsolePlace)place;
            filterablePanelProvider.getFilterablePanel().filterAndSelect(filterablePlace.getFilterAndSelectParameters());
        }
    }

    private boolean userHasPermissionsToSeeWidget(UserDTO user, Widget widget) {
        boolean hasPermission;
        Set<BooleanSupplier> permissionsRequired = this.permissionsAnyOfWhichIsRequiredToSeeWidget.get(widget);
        if (permissionsRequired.isEmpty()) {
            hasPermission = true;
        } else {
            hasPermission = false;
            for (BooleanSupplier requiredPermission : permissionsRequired) {
                if (!requiredPermission.getAsBoolean()) continue;
                hasPermission = true;
                break;
            }
        }
        return hasPermission;
    }

    private class TabSelectionHandler
    implements SelectionHandler<Integer> {
        private TabSelectionHandler() {
        }

        public void onSelection(SelectionEvent<Integer> event) {
            Object source = event.getSource();
            if (source != null) {
                if (source instanceof HorizontalTabLayoutPanel) {
                    HorizontalTabLayoutPanel tabPanel = (HorizontalTabLayoutPanel)source;
                    Widget selectedPanel = tabPanel.getWidget(((Integer)event.getSelectedItem()).intValue());
                    if (selectedPanel instanceof PanelSupplierScollPanel) {
                        PanelSupplierScollPanel supplierScollPanel = (PanelSupplierScollPanel)selectedPanel;
                        supplierScollPanel.activate(panelSupplierScollPanel -> this.goToWidgetsPlace((Widget)panelSupplierScollPanel));
                    } else {
                        this.goToWidgetsPlace(selectedPanel);
                    }
                } else if (source instanceof VerticalTabLayoutPanel) {
                    HorizontalTabLayoutPanel selectedTabLayoutPanel;
                    int selectedIndex;
                    VerticalTabLayoutPanel verticalTabLayoutPanel = (VerticalTabLayoutPanel)source;
                    Widget widgetAssociatedToVerticalTab = verticalTabLayoutPanel.getWidget(verticalTabLayoutPanel.getSelectedIndex());
                    if (widgetAssociatedToVerticalTab instanceof HorizontalTabLayoutPanel && (selectedIndex = (selectedTabLayoutPanel = (HorizontalTabLayoutPanel)widgetAssociatedToVerticalTab).getSelectedIndex()) >= 0) {
                        widgetAssociatedToVerticalTab = selectedTabLayoutPanel.getWidget(selectedIndex);
                    }
                    if (widgetAssociatedToVerticalTab instanceof PanelSupplierScollPanel) {
                        PanelSupplierScollPanel dummyScrollPanel = (PanelSupplierScollPanel)widgetAssociatedToVerticalTab;
                        dummyScrollPanel.activate(panelSupplierScollPanel -> this.goToWidgetsPlace((Widget)panelSupplierScollPanel));
                    } else {
                        this.goToWidgetsPlace(widgetAssociatedToVerticalTab);
                    }
                }
            }
        }

        private void goToWidgetsPlace(Widget widget) {
            Place gotoPlace = null;
            if (AdminConsolePanel.this.widgetPlacesMap.containsKey(widget)) {
                gotoPlace = (Place)AdminConsolePanel.this.widgetPlacesMap.get(widget);
            }
            if (AdminConsolePanel.this.currentPlace == null || gotoPlace != null && !((AdminConsolePlace)AdminConsolePanel.this.currentPlace).isSamePlace(gotoPlace)) {
                AdminConsolePanel.this.placeController.goTo(gotoPlace);
            }
        }
    }

    public static interface VerticalOrHorizontalTabLayoutPanel {
        public void add(Widget var1, String var2, boolean var3, boolean var4);

        public boolean remove(Widget var1);

        public boolean remove(Widget var1, boolean var2);

        public Widget getPanel();

        public void selectTab(int var1);

        public void selectTab(int var1, boolean var2);

        public int getWidgetIndex(Widget var1);
    }
}

