/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.serialization.impl;

import com.sap.sailing.domain.anniversary.SimpleRaceInfo;
import com.sap.sailing.domain.common.RegattaAndRaceIdentifier;
import com.sap.sailing.domain.common.RegattaNameAndRaceName;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import com.sap.sse.shared.json.JsonDeserializationException;
import com.sap.sse.shared.json.JsonSerializer;
import java.net.URL;
import java.util.UUID;
import org.json.simple.JSONObject;

public class SimpleRaceInfoJsonSerializer
implements JsonSerializer<SimpleRaceInfo> {
    public static final String FIELD_RACE_NAME = "raceName";
    public static final String FIELD_REGATTA_NAME = "regattaName";
    public static final String FIELD_START_OF_RACE = "startOfRaceAsMillis";
    public static final String FIELD_EVENT_UUID = "eventId";

    public JSONObject serialize(SimpleRaceInfo object) {
        JSONObject result = new JSONObject();
        result.put((Object)FIELD_RACE_NAME, (Object)object.getIdentifier().getRaceName());
        result.put((Object)FIELD_REGATTA_NAME, (Object)object.getIdentifier().getRegattaName());
        result.put((Object)FIELD_START_OF_RACE, (Object)object.getStartOfRace().asMillis());
        if (object.getEventID() != null) {
            result.put((Object)FIELD_EVENT_UUID, (Object)object.getEventID().toString());
        }
        return result;
    }

    public SimpleRaceInfo deserialize(JSONObject object, URL remoteUrl) throws JsonDeserializationException {
        String raceName = object.get((Object)FIELD_RACE_NAME).toString();
        String regattaName = object.get((Object)FIELD_REGATTA_NAME).toString();
        MillisecondsTimePoint startOfRace = new MillisecondsTimePoint(((Number)object.get((Object)FIELD_START_OF_RACE)).longValue());
        Object objEventId = object.get((Object)FIELD_EVENT_UUID);
        UUID eventId = objEventId != null ? UUID.fromString(objEventId.toString()) : null;
        return new SimpleRaceInfo((RegattaAndRaceIdentifier)new RegattaNameAndRaceName(regattaName, raceName), (TimePoint)startOfRace, remoteUrl, eventId);
    }
}

